/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPrivateKey;

public class LeaseSetKeys
extends DataStructureImpl {
    private Destination _dest;
    private SigningPrivateKey _revocationKey;
    private PrivateKey _decryptionKey;

    public LeaseSetKeys() {
    }

    public LeaseSetKeys(Destination dest, SigningPrivateKey revocationKey, PrivateKey decryptionKey) {
        this._dest = dest;
        this._revocationKey = revocationKey;
        this._decryptionKey = decryptionKey;
    }

    public Destination getDestination() {
        return this._dest;
    }

    public SigningPrivateKey getRevocationKey() {
        return this._revocationKey;
    }

    public PrivateKey getDecryptionKey() {
        return this._decryptionKey;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._dest = new Destination();
        this._dest.readBytes(in);
        this._decryptionKey = new PrivateKey();
        this._decryptionKey.readBytes(in);
        this._revocationKey = new SigningPrivateKey();
        this._revocationKey.readBytes(in);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._dest == null) {
            throw new DataFormatException("Null destination");
        }
        if (this._decryptionKey == null) {
            throw new DataFormatException("Null decryption key");
        }
        if (this._revocationKey == null) {
            throw new DataFormatException("Null revocation key");
        }
        this._dest.writeBytes(out);
        this._decryptionKey.writeBytes(out);
        this._revocationKey.writeBytes(out);
    }

    public int hashCode() {
        int rv = DataHelper.hashCode((Object)this._dest);
        rv += DataHelper.hashCode((Object)this._revocationKey);
        return rv += DataHelper.hashCode((Object)this._decryptionKey);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LeaseSetKeys) {
            LeaseSetKeys keys = (LeaseSetKeys)((Object)obj);
            return DataHelper.eq((Object)this.getDestination(), (Object)keys.getDestination()) && DataHelper.eq((Object)this.getDecryptionKey(), (Object)keys.getDecryptionKey()) && DataHelper.eq((Object)this.getRevocationKey(), (Object)keys.getRevocationKey());
        }
        return false;
    }
}

