/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.socks.MultiSink;
import net.i2p.i2ptunnel.socks.SOCKSUDPPort;
import net.i2p.i2ptunnel.udpTunnel.I2PTunnelUDPClientBase;

public class SOCKSUDPTunnel
extends I2PTunnelUDPClientBase {
    private Map<Integer, SOCKSUDPPort> ports = new ConcurrentHashMap<Integer, SOCKSUDPPort>(1);
    private Map<Destination, SOCKSUDPPort> cache = new ConcurrentHashMap<Destination, SOCKSUDPPort>(1);
    private MultiSink demuxer = new MultiSink(this.cache);

    public SOCKSUDPTunnel(I2PTunnel tunnel) {
        super(null, tunnel, tunnel, tunnel);
        this.setSink(this.demuxer);
    }

    public int add(InetAddress host, int port) {
        SOCKSUDPPort sup = new SOCKSUDPPort(host, port, this.cache);
        this.ports.put(sup.getPort(), sup);
        sup.setSink(this);
        sup.start();
        return sup.getPort();
    }

    public void remove(Integer port) {
        SOCKSUDPPort sup = this.ports.remove(port);
        if (sup != null) {
            sup.stop();
        }
        Iterator<Map.Entry<Destination, SOCKSUDPPort>> iter = this.cache.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Destination, SOCKSUDPPort> e = iter.next();
            if (e.getValue() != sup) continue;
            iter.remove();
        }
    }

    public final void startRunning() {
        super.startRunning();
        this.startall();
    }

    public boolean close(boolean forced) {
        this.stopall();
        return super.close(forced);
    }

    private void startall() {
    }

    private void stopall() {
        for (SOCKSUDPPort sup : this.ports.values()) {
            sup.stop();
        }
        this.ports.clear();
        this.cache.clear();
    }
}

