/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PException;
import net.i2p.client.I2PSessionException;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.sam.SAMDatagramSession;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMRawSession;
import net.i2p.sam.SAMStreamSession;
import net.i2p.sam.SAMUtils;
import net.i2p.sam.SAMv1Handler;
import net.i2p.sam.SAMv3DatagramSession;
import net.i2p.sam.SAMv3RawSession;
import net.i2p.sam.SAMv3StreamSession;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class SAMv3Handler
extends SAMv1Handler {
    private static final Log _log = new Log(SAMv3Handler.class);
    protected SAMv3RawSession rawSession = null;
    protected SAMv3DatagramSession datagramSession = null;
    protected SAMv3StreamSession streamSession = null;
    protected Session session = null;
    public static SessionsDB sSessionsHash = new SessionsDB();
    boolean stolenSocket = false;
    boolean streamForwardingSocket = false;

    protected SAMRawSession getRawSession() {
        return this.rawSession;
    }

    protected SAMDatagramSession getDatagramSession() {
        return this.datagramSession;
    }

    protected SAMStreamSession getStreamSession() {
        return this.streamSession;
    }

    public SAMv3Handler(SocketChannel s, int verMajor, int verMinor) throws SAMException, IOException {
        this(s, verMajor, verMinor, new Properties());
    }

    public SAMv3Handler(SocketChannel s, int verMajor, int verMinor, Properties i2cpProps) throws SAMException, IOException {
        super(s, verMajor, verMinor, i2cpProps);
        _log.debug("SAM version 3 handler instantiated");
    }

    public boolean verifVersion() {
        return this.verMajor == 3 && this.verMinor == 0;
    }

    public String getClientIP() {
        return this.socket.socket().getInetAddress().getHostAddress();
    }

    public void stealSocket() {
        this.stolenSocket = true;
        this.stopHandling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handle() {
        block45: {
            Exception e2222;
            String msg;
            block43: {
                msg = null;
                String domain = null;
                String opcode = null;
                boolean canContinue = false;
                this.thread.setName("SAMv3Handler " + this._id);
                _log.debug("SAM handling started");
                InputStream in = this.getClientSocket().socket().getInputStream();
                while (true) {
                    if (this.shouldStop()) {
                        _log.debug("Stop request found");
                        break;
                    }
                    String line = DataHelper.readLine(in);
                    if (line == null) {
                        _log.debug("Connection closed by client (line read : null)");
                        break;
                    }
                    msg = line.trim();
                    if (_log.shouldLog(10)) {
                        _log.debug("New message received: [" + msg + "]");
                    }
                    if (msg.equals("")) {
                        _log.debug("Ignoring newline");
                        continue;
                    }
                    StringTokenizer tok = new StringTokenizer(msg, " ");
                    if (tok.countTokens() < 2) {
                        _log.debug("Error in message format");
                        break;
                    }
                    domain = tok.nextToken();
                    opcode = tok.nextToken();
                    if (_log.shouldLog(10)) {
                        _log.debug("Parsing (domain: \"" + domain + "\"; opcode: \"" + opcode + "\")");
                    }
                    Properties props = SAMUtils.parseParams(tok);
                    if (domain.equals("STREAM")) {
                        canContinue = this.execStreamMessage(opcode, props);
                    } else if (domain.equals("SESSION")) {
                        if (this.i2cpProps != null) {
                            props.putAll((Map<?, ?>)this.i2cpProps);
                        }
                        canContinue = this.execSessionMessage(opcode, props);
                    } else if (domain.equals("DEST")) {
                        canContinue = this.execDestMessage(opcode, props);
                    } else if (domain.equals("NAMING")) {
                        canContinue = this.execNamingMessage(opcode, props);
                    } else {
                        if (!domain.equals("DATAGRAM")) {
                            _log.debug("Unrecognized message domain: \"" + domain + "\"");
                            break;
                        }
                        canContinue = this.execDatagramMessage(opcode, props);
                    }
                    if (!canContinue) break;
                }
                Object var10_11 = null;
                _log.debug("Stopping handler");
                if (this.stolenSocket) break block43;
                try {
                    this.closeClientSocket();
                }
                catch (IOException e2222) {
                    _log.error("Error closing socket: " + e2222.getMessage());
                }
            }
            if (this.streamForwardingSocket && this.getStreamSession() != null) {
                try {
                    this.streamSession.stopForwardingIncoming();
                }
                catch (SAMException e2222) {
                    _log.error("Error while stopping forwarding connections: " + e2222.getMessage());
                }
                catch (InterruptedIOException e2222) {
                    _log.error("Interrupted while stopping forwarding connections: " + e2222.getMessage());
                }
            }
            this.die();
            {
                break block45;
                catch (IOException e3) {
                    Exception e2222;
                    _log.debug("Caught IOException (" + e3.getMessage() + ") for message [" + msg + "]", e3);
                    Object var10_12 = null;
                    _log.debug("Stopping handler");
                    if (!this.stolenSocket) {
                        try {
                            this.closeClientSocket();
                        }
                        catch (IOException e2222) {
                            _log.error("Error closing socket: " + e2222.getMessage());
                        }
                    }
                    if (this.streamForwardingSocket && this.getStreamSession() != null) {
                        try {
                            this.streamSession.stopForwardingIncoming();
                        }
                        catch (SAMException e2222) {
                            _log.error("Error while stopping forwarding connections: " + e2222.getMessage());
                        }
                        catch (InterruptedIOException e2222) {
                            _log.error("Interrupted while stopping forwarding connections: " + e2222.getMessage());
                        }
                    }
                    this.die();
                    break block45;
                }
                catch (Exception e4) {
                    Exception e2222;
                    _log.error("Unexpected exception for message [" + msg + "]", e4);
                    Object var10_13 = null;
                    _log.debug("Stopping handler");
                    if (!this.stolenSocket) {
                        try {
                            this.closeClientSocket();
                        }
                        catch (IOException e2222) {
                            _log.error("Error closing socket: " + e2222.getMessage());
                        }
                    }
                    if (this.streamForwardingSocket && this.getStreamSession() != null) {
                        try {
                            this.streamSession.stopForwardingIncoming();
                        }
                        catch (SAMException e2222) {
                            _log.error("Error while stopping forwarding connections: " + e2222.getMessage());
                        }
                        catch (InterruptedIOException e2222) {
                            _log.error("Interrupted while stopping forwarding connections: " + e2222.getMessage());
                        }
                    }
                    this.die();
                }
            }
            catch (Throwable throwable) {
                Exception e2222;
                Object var10_14 = null;
                _log.debug("Stopping handler");
                if (!this.stolenSocket) {
                    try {
                        this.closeClientSocket();
                    }
                    catch (IOException e2222) {
                        _log.error("Error closing socket: " + e2222.getMessage());
                    }
                }
                if (this.streamForwardingSocket && this.getStreamSession() != null) {
                    try {
                        this.streamSession.stopForwardingIncoming();
                    }
                    catch (SAMException e2222) {
                        _log.error("Error while stopping forwarding connections: " + e2222.getMessage());
                    }
                    catch (InterruptedIOException e2222) {
                        _log.error("Interrupted while stopping forwarding connections: " + e2222.getMessage());
                    }
                }
                this.die();
                throw throwable;
            }
        }
    }

    protected void die() {
        SessionRecord rec = null;
        if (this.session != null) {
            this.session.close();
            rec = sSessionsHash.get(this.session.getNick());
        }
        if (rec != null) {
            rec.getThreadGroup().interrupt();
            while (rec.getThreadGroup().activeCount() > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            rec.getThreadGroup().destroy();
            sSessionsHash.del(this.session.getNick());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean execSessionMessage(String opcode, Properties props) {
        boolean style2;
        boolean ok;
        String nick;
        block33: {
            boolean bl;
            block32: {
                boolean bl2;
                block31: {
                    boolean bl3;
                    block30: {
                        boolean e2;
                        block29: {
                            boolean bl4;
                            block28: {
                                boolean bl5;
                                block27: {
                                    boolean bl6;
                                    block26: {
                                        String dest = "BUG!";
                                        nick = null;
                                        ok = false;
                                        try {
                                            try {
                                                if (opcode.equals("CREATE")) {
                                                    if (this.getRawSession() != null || this.getDatagramSession() != null || this.getStreamSession() != null) {
                                                        _log.debug("Trying to create a session, but one still exists");
                                                        bl6 = this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"Session already exists\"\n");
                                                        Object var11_17 = null;
                                                        if (ok) return bl6;
                                                        if (nick == null) return bl6;
                                                        sSessionsHash.del(nick);
                                                        break block26;
                                                    }
                                                    if (props == null) {
                                                        _log.debug("No parameters specified in SESSION CREATE message");
                                                        bl5 = this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"No parameters for SESSION CREATE\"\n");
                                                        break block27;
                                                    }
                                                    dest = props.getProperty("DESTINATION");
                                                    if (dest == null) {
                                                        _log.debug("SESSION DESTINATION parameter not specified");
                                                        bl4 = this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"DESTINATION not specified\"\n");
                                                        break block28;
                                                    }
                                                    props.remove("DESTINATION");
                                                    if (dest.equals("TRANSIENT")) {
                                                        _log.debug("TRANSIENT destination requested");
                                                        ByteArrayOutputStream priv = new ByteArrayOutputStream(640);
                                                        SAMUtils.genRandomKey(priv, null);
                                                        dest = Base64.encode(priv.toByteArray());
                                                    } else {
                                                        _log.debug("Custom destination specified [" + dest + "]");
                                                    }
                                                    try {
                                                        SAMUtils.checkPrivateDestination(dest);
                                                    }
                                                    catch (SAMUtils.InvalidDestination e2) {
                                                        boolean bl7 = this.writeString("SESSION STATUS RESULT=INVALID_KEY\n");
                                                        Object var11_20 = null;
                                                        if (ok) return bl7;
                                                        if (nick == null) return bl7;
                                                        sSessionsHash.del(nick);
                                                        this.session = null;
                                                        return bl7;
                                                    }
                                                    nick = props.getProperty("ID");
                                                    if (nick == null) {
                                                        _log.debug("SESSION ID parameter not specified");
                                                        e2 = this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"ID not specified\"\n");
                                                        break block29;
                                                    }
                                                    props.remove("ID");
                                                    String style2 = props.getProperty("STYLE");
                                                    if (style2 == null) {
                                                        _log.debug("SESSION STYLE parameter not specified");
                                                        bl3 = this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"No SESSION STYLE specified\"\n");
                                                        break block30;
                                                    }
                                                    props.remove("STYLE");
                                                    this.i2cpProps.setProperty("i2cp.messageReliability", "none");
                                                    Properties allProps = new Properties();
                                                    allProps.putAll((Map<?, ?>)this.i2cpProps);
                                                    allProps.putAll((Map<?, ?>)props);
                                                    try {
                                                        sSessionsHash.put(nick, new SessionRecord(dest, allProps, this));
                                                    }
                                                    catch (SessionsDB.ExistingId e3) {
                                                        _log.debug("SESSION ID parameter already in use");
                                                        boolean bl8 = this.writeString("SESSION STATUS RESULT=DUPLICATED_ID\n");
                                                        Object var11_23 = null;
                                                        if (ok) return bl8;
                                                        if (nick == null) return bl8;
                                                        sSessionsHash.del(nick);
                                                        this.session = null;
                                                        return bl8;
                                                    }
                                                    catch (SessionsDB.ExistingDest e4) {
                                                        boolean bl9 = this.writeString("SESSION STATUS RESULT=DUPLICATED_DEST\n");
                                                        Object var11_24 = null;
                                                        if (ok) return bl9;
                                                        if (nick == null) return bl9;
                                                        sSessionsHash.del(nick);
                                                        this.session = null;
                                                        return bl9;
                                                    }
                                                    if (style2.equals("RAW")) {
                                                        DatagramServer.getInstance(this.i2cpProps);
                                                        this.rawSession = this.newSAMRawSession(nick);
                                                        this.session = this.rawSession;
                                                    } else if (style2.equals("DATAGRAM")) {
                                                        DatagramServer.getInstance(this.i2cpProps);
                                                        this.datagramSession = this.newSAMDatagramSession(nick);
                                                        this.session = this.datagramSession;
                                                    } else {
                                                        if (!style2.equals("STREAM")) {
                                                            _log.debug("Unrecognized SESSION STYLE: \"" + style2 + "\"");
                                                            bl2 = this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"Unrecognized SESSION STYLE\"\n");
                                                            break block31;
                                                        }
                                                        this.streamSession = this.newSAMStreamSession(nick);
                                                        this.session = this.streamSession;
                                                    }
                                                    ok = true;
                                                    bl = this.writeString("SESSION STATUS RESULT=OK DESTINATION=" + dest + "\n");
                                                    break block32;
                                                }
                                                _log.debug("Unrecognized SESSION message opcode: \"" + opcode + "\"");
                                                style2 = this.writeString("SESSION STATUS RESULT=I2P_ERROR MESSAGE=\"Unrecognized opcode\"\n");
                                                break block33;
                                            }
                                            catch (DataFormatException e5) {
                                                _log.debug("Invalid destination specified");
                                                boolean bl10 = this.writeString("SESSION STATUS RESULT=INVALID_KEY DESTINATION=" + dest + " MESSAGE=\"" + e5.getMessage() + "\"\n");
                                                Object var11_28 = null;
                                                if (ok) return bl10;
                                                if (nick == null) return bl10;
                                                sSessionsHash.del(nick);
                                                this.session = null;
                                                return bl10;
                                            }
                                            catch (I2PSessionException e6) {
                                                _log.debug("I2P error when instantiating session", e6);
                                                boolean bl11 = this.writeString("SESSION STATUS RESULT=I2P_ERROR DESTINATION=" + dest + " MESSAGE=\"" + e6.getMessage() + "\"\n");
                                                Object var11_29 = null;
                                                if (ok) return bl11;
                                                if (nick == null) return bl11;
                                                sSessionsHash.del(nick);
                                                this.session = null;
                                                return bl11;
                                            }
                                            catch (SAMException e7) {
                                                _log.info("Funny SAM error", e7);
                                                boolean bl12 = this.writeString("SESSION STATUS RESULT=I2P_ERROR DESTINATION=" + dest + " MESSAGE=\"" + e7.getMessage() + "\"\n");
                                                Object var11_30 = null;
                                                if (ok) return bl12;
                                                if (nick == null) return bl12;
                                                sSessionsHash.del(nick);
                                                this.session = null;
                                                return bl12;
                                            }
                                            catch (IOException e8) {
                                                _log.error("Unexpected IOException", e8);
                                                boolean bl13 = this.writeString("SESSION STATUS RESULT=I2P_ERROR DESTINATION=" + dest + " MESSAGE=\"" + e8.getMessage() + "\"\n");
                                                Object var11_31 = null;
                                                if (ok) return bl13;
                                                if (nick == null) return bl13;
                                                sSessionsHash.del(nick);
                                                this.session = null;
                                                return bl13;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var11_32 = null;
                                            if (ok) throw throwable;
                                            if (nick == null) throw throwable;
                                            sSessionsHash.del(nick);
                                            this.session = null;
                                            throw throwable;
                                        }
                                    }
                                    this.session = null;
                                    return bl6;
                                }
                                Object var11_18 = null;
                                if (ok) return bl5;
                                if (nick == null) return bl5;
                                sSessionsHash.del(nick);
                                this.session = null;
                                return bl5;
                            }
                            Object var11_19 = null;
                            if (ok) return bl4;
                            if (nick == null) return bl4;
                            sSessionsHash.del(nick);
                            this.session = null;
                            return bl4;
                        }
                        Object var11_21 = null;
                        if (ok) return e2;
                        if (nick == null) return e2;
                        sSessionsHash.del(nick);
                        this.session = null;
                        return e2;
                    }
                    Object var11_22 = null;
                    if (ok) return bl3;
                    if (nick == null) return bl3;
                    sSessionsHash.del(nick);
                    this.session = null;
                    return bl3;
                }
                Object var11_25 = null;
                if (ok) return bl2;
                if (nick == null) return bl2;
                sSessionsHash.del(nick);
                this.session = null;
                return bl2;
            }
            Object var11_26 = null;
            if (ok) return bl;
            if (nick == null) return bl;
            sSessionsHash.del(nick);
            this.session = null;
            return bl;
        }
        Object var11_27 = null;
        if (ok) return style2;
        if (nick == null) return style2;
        sSessionsHash.del(nick);
        this.session = null;
        return style2;
    }

    SAMv3StreamSession newSAMStreamSession(String login) throws IOException, DataFormatException, SAMException {
        return new SAMv3StreamSession(login);
    }

    SAMv3RawSession newSAMRawSession(String login) throws IOException, DataFormatException, SAMException, I2PSessionException {
        return new SAMv3RawSession(login);
    }

    SAMv3DatagramSession newSAMDatagramSession(String login) throws IOException, DataFormatException, SAMException, I2PSessionException {
        return new SAMv3DatagramSession(login);
    }

    protected boolean execStreamMessage(String opcode, Properties props) {
        String nick = null;
        SessionRecord rec = null;
        if (this.session != null) {
            _log.error("STREAM message received, but this session is a master session");
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "master session cannot be used for streams");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        nick = props.getProperty("ID");
        if (nick == null) {
            _log.debug("SESSION ID parameter not specified");
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "ID not specified");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        props.remove("ID");
        rec = sSessionsHash.get(nick);
        if (rec == null) {
            _log.debug("STREAM SESSION ID does not exist");
            try {
                this.notifyStreamResult(true, "INVALID_ID", "STREAM SESSION ID does not exist");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        this.streamSession = rec.getHandler().streamSession;
        if (this.streamSession == null) {
            _log.debug("specified ID is not a stream session");
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "specified ID is not a STREAM session");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        if (opcode.equals("CONNECT")) {
            return this.execStreamConnect(props);
        }
        if (opcode.equals("ACCEPT")) {
            return this.execStreamAccept(props);
        }
        if (opcode.equals("FORWARD")) {
            return this.execStreamForwardIncoming(props);
        }
        _log.debug("Unrecognized RAW message opcode: \"" + opcode + "\"");
        try {
            this.notifyStreamResult(true, "I2P_ERROR", "Unrecognized RAW message opcode: " + opcode);
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    protected boolean execStreamConnect(Properties props) {
        try {
            if (props == null) {
                this.notifyStreamResult(true, "I2P_ERROR", "No parameters specified in STREAM CONNECT message");
                _log.debug("No parameters specified in STREAM CONNECT message");
                return false;
            }
            boolean verbose = props.getProperty("SILENT", "false").equals("false");
            String dest = props.getProperty("DESTINATION");
            if (dest == null) {
                this.notifyStreamResult(verbose, "I2P_ERROR", "Destination not specified in RAW SEND message");
                _log.debug("Destination not specified in RAW SEND message");
                return false;
            }
            props.remove("DESTINATION");
            try {
                this.streamSession.connect(this, dest, props);
                return true;
            }
            catch (DataFormatException e) {
                _log.debug("Invalid destination in STREAM CONNECT message");
                this.notifyStreamResult(verbose, "INVALID_KEY", null);
            }
            catch (ConnectException e) {
                _log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "CONNECTION_REFUSED", null);
            }
            catch (NoRouteToHostException e) {
                _log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "CANT_REACH_PEER", null);
            }
            catch (InterruptedIOException e) {
                _log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "TIMEOUT", null);
            }
            catch (I2PException e) {
                _log.debug("STREAM CONNECT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "I2P_ERROR", e.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected boolean execStreamForwardIncoming(Properties props) {
        try {
            try {
                this.streamForwardingSocket = true;
                this.streamSession.startForwardingIncoming(props);
                this.notifyStreamResult(true, "OK", null);
                return true;
            }
            catch (SAMException e) {
                _log.debug("Forwarding STREAM connections failed: " + e.getMessage());
                this.notifyStreamResult(true, "I2P_ERROR", "Forwarding failed : " + e.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected boolean execStreamAccept(Properties props) {
        boolean verbose = props.getProperty("SILENT", "false").equals("false");
        try {
            try {
                this.notifyStreamResult(verbose, "OK", null);
                this.streamSession.accept(this, verbose);
                return true;
            }
            catch (InterruptedIOException e) {
                _log.debug("STREAM ACCEPT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "TIMEOUT", e.getMessage());
            }
            catch (I2PException e) {
                _log.debug("STREAM ACCEPT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "I2P_ERROR", e.getMessage());
            }
            catch (SAMException e) {
                _log.debug("STREAM ACCEPT failed: " + e.getMessage());
                this.notifyStreamResult(verbose, "ALREADY_ACCEPTING", null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void notifyStreamResult(boolean verbose, String result, String message) throws IOException {
        if (!verbose) {
            return;
        }
        String out = "STREAM STATUS RESULT=" + result;
        if (message != null) {
            out = out + " MESSAGE=\"" + message + "\"";
        }
        if (!this.writeString(out = out + '\n')) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public void notifyStreamIncomingConnection(Destination d) throws IOException {
        if (this.getStreamSession() == null) {
            _log.error("BUG! Received stream connection, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        if (!this.writeString(d.toBase64() + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public static void notifyStreamIncomingConnection(SocketChannel client, Destination d) throws IOException {
        if (!SAMv3Handler.writeString(d.toBase64() + "\n", client)) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public static class DatagramServer {
        private static DatagramServer _instance = null;
        private static DatagramChannel server = null;

        public static DatagramServer getInstance() throws IOException {
            return DatagramServer.getInstance(new Properties());
        }

        public static DatagramServer getInstance(Properties props) throws IOException {
            if (_instance == null) {
                _instance = new DatagramServer(props);
            }
            return _instance;
        }

        public DatagramServer(Properties props) throws IOException {
            int port;
            if (server == null) {
                server = DatagramChannel.open();
            }
            String host = props.getProperty("sam.udp.host", "0.0.0.0");
            String portStr = props.getProperty("sam.udp.port", "7655");
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                port = Integer.parseInt("7655");
            }
            server.socket().bind(new InetSocketAddress(host, port));
            new I2PAppThread(new Listener(server), "DatagramListener").start();
        }

        public void send(SocketAddress addr, ByteBuffer msg) throws IOException {
            server.send(msg, addr);
        }

        class Listener
        implements Runnable {
            final DatagramChannel server;

            public Listener(DatagramChannel server) {
                this.server = server;
            }

            public void run() {
                ByteBuffer inBuf = ByteBuffer.allocateDirect(33792);
                while (!Thread.interrupted()) {
                    inBuf.clear();
                    try {
                        this.server.receive(inBuf);
                    }
                    catch (IOException e) {
                        break;
                    }
                    inBuf.flip();
                    ByteBuffer outBuf = ByteBuffer.wrap(new byte[inBuf.remaining()]);
                    outBuf.put(inBuf);
                    outBuf.flip();
                    new I2PAppThread(new MessageDispatcher(outBuf.array()), "MessageDispatcher").start();
                }
            }
        }
    }

    public static class MessageDispatcher
    implements Runnable {
        final ByteArrayInputStream is;

        public MessageDispatcher(byte[] buf) {
            this.is = new ByteArrayInputStream(buf);
        }

        public void run() {
            String header = null;
            try {
                header = DataHelper.readLine(this.is).trim();
                StringTokenizer tok = new StringTokenizer(header, " ");
                if (tok.countTokens() != 3) {
                    _log.debug("Error in message format");
                    return;
                }
                String version = tok.nextToken();
                if (!"3.0".equals(version)) {
                    return;
                }
                String nick = tok.nextToken();
                String dest = tok.nextToken();
                byte[] data = new byte[this.is.available()];
                this.is.read(data);
                SessionRecord rec = sSessionsHash.get(nick);
                if (rec != null) {
                    rec.getHandler().session.sendBytes(dest, data);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    static interface Session {
        public String getNick();

        public void close();

        public boolean sendBytes(String var1, byte[] var2) throws DataFormatException;
    }

    public class SessionRecord {
        protected final String m_dest;
        protected final Properties m_props;
        protected ThreadGroup m_threadgroup;
        protected final SAMv3Handler m_handler;

        public SessionRecord(String dest, Properties props, SAMv3Handler handler) {
            this.m_dest = new String(dest);
            this.m_props = new Properties();
            this.m_props.putAll((Map<?, ?>)props);
            this.m_threadgroup = null;
            this.m_handler = handler;
        }

        public SessionRecord(SessionRecord in) {
            this.m_dest = in.getDest();
            this.m_props = in.getProps();
            this.m_threadgroup = in.getThreadGroup();
            this.m_handler = in.getHandler();
        }

        public synchronized String getDest() {
            return new String(this.m_dest);
        }

        public synchronized Properties getProps() {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)this.m_props);
            return this.m_props;
        }

        public synchronized SAMv3Handler getHandler() {
            return this.m_handler;
        }

        public synchronized ThreadGroup getThreadGroup() {
            return this.m_threadgroup;
        }

        public synchronized void createThreadGroup(String name) {
            if (this.m_threadgroup == null) {
                this.m_threadgroup = new ThreadGroup(name);
            }
        }
    }

    public static class SessionsDB {
        static final long serialVersionUID = 1L;
        final HashMap<String, SessionRecord> map = new HashMap();

        public synchronized boolean put(String nick, SessionRecord session) throws ExistingId, ExistingDest {
            if (this.map.containsKey(nick)) {
                throw new ExistingId();
            }
            for (SessionRecord r : this.map.values()) {
                if (!r.getDest().equals(session.getDest())) continue;
                throw new ExistingDest();
            }
            if (!this.map.containsKey(nick)) {
                session.createThreadGroup("SAM session " + nick);
                this.map.put(nick, session);
                return true;
            }
            return false;
        }

        public synchronized boolean del(String nick) {
            SessionRecord rec = this.map.get(nick);
            if (rec != null) {
                this.map.remove(nick);
                return true;
            }
            return false;
        }

        public synchronized SessionRecord get(String nick) {
            return this.map.get(nick);
        }

        public synchronized boolean containsKey(String nick) {
            return this.map.containsKey(nick);
        }

        class ExistingDest
        extends Exception {
            static final long serialVersionUID = 1L;

            ExistingDest() {
            }
        }

        class ExistingId
        extends Exception {
            static final long serialVersionUID = 1L;

            ExistingId() {
            }
        }
    }
}

