/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;

public class I2PProperties
extends Properties {
    private final List<I2PPropertyCallback> _callbacks = new CopyOnWriteArrayList<I2PPropertyCallback>();

    public I2PProperties() {
    }

    public I2PProperties(Properties defaults) {
        super(defaults);
    }

    public void addCallBack(I2PPropertyCallback callback) {
        this._callbacks.add(callback);
    }

    public void removeCallBack(I2PPropertyCallback callback) {
        this._callbacks.remove(callback);
    }

    public Object setProperty(String key, String value) {
        Object returnValue = super.setProperty(key, value);
        for (I2PPropertyCallback callback : this._callbacks) {
            callback.propertyChanged(key, value);
        }
        return returnValue;
    }

    public static interface I2PPropertyCallback {
        public void propertyChanged(String var1, String var2);
    }
}

