/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public abstract class DataStructureImpl
implements DataStructure {
    public String toBase64() {
        byte[] data = this.toByteArray();
        if (data == null) {
            return null;
        }
        return Base64.encode(data);
    }

    public void fromBase64(String data) throws DataFormatException {
        if (data == null) {
            throw new DataFormatException("Null data passed in");
        }
        byte[] bytes = Base64.decode(data);
        this.fromByteArray(bytes);
    }

    public Hash calculateHash() {
        byte[] data = this.toByteArray();
        if (data != null) {
            return SHA256Generator.getInstance().calculateHash(data);
        }
        return null;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            this.writeBytes(baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
            log.error("Error writing out the byte array", ioe);
            return null;
        }
        catch (DataFormatException dfe) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
            log.error("Error writing out the byte array", dfe);
            return null;
        }
    }

    public void fromByteArray(byte[] data) throws DataFormatException {
        if (data == null) {
            throw new DataFormatException("Null data passed in");
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            this.readBytes(bais);
        }
        catch (IOException ioe) {
            throw new DataFormatException("Error reading the byte array", ioe);
        }
    }

    protected int read(InputStream in, byte[] target) throws IOException {
        return DataHelper.read(in, target);
    }
}

