/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportEventListener;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.UPnPManager;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.Translate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportManager
implements TransportEventListener {
    private final Log _log;
    private final Map<String, Transport> _transports;
    private final RouterContext _context;
    private final UPnPManager _upnpManager;
    private final DHSessionKeyBuilder.PrecalcRunner _dhThread;
    public static final String PROP_ENABLE_UDP = "i2np.udp.enable";
    public static final String PROP_ENABLE_NTCP = "i2np.ntcp.enable";
    public static final String PROP_ENABLE_UPNP = "i2np.upnp.enable";
    private static final int HIGH_CAPACITY_PCT = 50;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public TransportManager(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(TransportManager.class);
        this._context.statManager().createRateStat("transport.banlistOnUnreachable", "Add a peer to the banlist since none of the transports can reach them", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.noBidsYetNotAllUnreachable", "Add a peer to the banlist since none of the transports can reach them", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailBanlisted", "Could not attempt to bid on message, as they were banlisted", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailSelf", "Could not attempt to bid on message, as it targeted ourselves", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailNoTransports", "Could not attempt to bid on message, as none of the transports could attempt it", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("transport.bidFailAllTransports", "Could not attempt to bid on message, as all of the transports had failed", "Transport", new long[]{60000L, 600000L, 3600000L});
        this._transports = new ConcurrentHashMap<String, Transport>(2);
        this._upnpManager = this._context.getBooleanPropertyDefaultTrue(PROP_ENABLE_UPNP) ? new UPnPManager(context, this) : null;
        this._dhThread = new DHSessionKeyBuilder.PrecalcRunner(context);
    }

    public void addTransport(Transport transport) {
        if (transport == null) {
            return;
        }
        this._transports.put(transport.getStyle(), transport);
        transport.setListener(this);
    }

    public void removeTransport(Transport transport) {
        if (transport == null) {
            return;
        }
        this._transports.remove(transport.getStyle());
        transport.setListener(null);
    }

    private void configTransports() {
        boolean enableUDP = this._context.getBooleanPropertyDefaultTrue(PROP_ENABLE_UDP);
        if (enableUDP) {
            UDPTransport udp = new UDPTransport(this._context, this._dhThread);
            this.addTransport(udp);
            this.initializeAddress(udp);
        }
        if (TransportManager.isNTCPEnabled(this._context)) {
            this.addTransport(new NTCPTransport(this._context, this._dhThread));
        }
        if (this._transports.isEmpty()) {
            this._log.log(50, "No transports are enabled");
        }
    }

    public static boolean isNTCPEnabled(RouterContext ctx) {
        return ctx.getBooleanPropertyDefaultTrue(PROP_ENABLE_NTCP);
    }

    private void initializeAddress(Transport t) {
        InetAddress ia;
        String ips = Addresses.getAnyAddress();
        if (ips == null) {
            return;
        }
        try {
            ia = InetAddress.getByName(ips);
        }
        catch (UnknownHostException e) {
            this._log.error("UDP failed to bind to local address", (Throwable)e);
            return;
        }
        byte[] ip = ia.getAddress();
        t.externalAddressReceived("local", ip, 0);
    }

    public void externalAddressReceived(String source, byte[] ip, int port) {
        Transport t = this.getTransport("SSU");
        if (t != null) {
            t.externalAddressReceived(source, ip, port);
        }
    }

    public void forwardPortStatus(String style, int port, int externalPort, boolean success, String reason) {
        Transport t = this.getTransport(style);
        if (t != null) {
            t.forwardPortStatus(port, externalPort, success, reason);
        }
    }

    public synchronized void startListening() {
        if (this._dhThread.getState() == Thread.State.NEW) {
            this._dhThread.start();
        }
        if (this._upnpManager != null && Addresses.getAnyAddress() == null) {
            this._upnpManager.start();
        }
        this.configTransports();
        this._log.debug("Starting up the transport manager");
        for (Transport t : this._transports.values()) {
            t.startListening();
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Transport " + t.getStyle() + " started");
        }
        this.transportAddressChanged();
        this._log.debug("Done start listening on transports");
        this._context.router().rebuildRouterInfo();
    }

    public synchronized void restart() {
        this.stopListening();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startListening();
    }

    public synchronized void stopListening() {
        if (this._upnpManager != null) {
            this._upnpManager.stop();
        }
        for (Transport t : this._transports.values()) {
            t.stopListening();
        }
        this._transports.clear();
    }

    public synchronized void shutdown() {
        this.stopListening();
        this._dhThread.shutdown();
        Addresses.clearCaches();
        TransportImpl.clearCaches();
    }

    public Transport getTransport(String style) {
        return this._transports.get(style);
    }

    int getTransportCount() {
        return this._transports.size();
    }

    public int countActivePeers() {
        int peers = 0;
        for (Transport t : this._transports.values()) {
            peers += t.countActivePeers();
        }
        return peers;
    }

    public int countActiveSendPeers() {
        int peers = 0;
        for (Transport t : this._transports.values()) {
            peers += t.countActiveSendPeers();
        }
        return peers;
    }

    public boolean haveOutboundCapacity(int pct) {
        for (Transport t : this._transports.values()) {
            if (!t.haveCapacity(pct)) continue;
            return true;
        }
        return false;
    }

    public boolean haveHighOutboundCapacity() {
        if (this._transports.isEmpty()) {
            return false;
        }
        for (Transport t : this._transports.values()) {
            if (t.haveCapacity(50)) continue;
            return false;
        }
        return true;
    }

    public boolean haveInboundCapacity(int pct) {
        for (Transport t : this._transports.values()) {
            if (t.getCurrentAddress() == null || !t.haveCapacity(pct)) continue;
            return true;
        }
        return false;
    }

    public Vector getClockSkews() {
        Vector skews = new Vector();
        for (Transport t : this._transports.values()) {
            Vector tempSkews = t.getClockSkews();
            if (tempSkews == null || tempSkews.isEmpty()) continue;
            skews.addAll(tempSkews);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Transport manager returning " + skews.size() + " peer clock skews.");
        }
        return skews;
    }

    public short getReachabilityStatus() {
        short rv = 5;
        for (Transport t : this._transports.values()) {
            short s = t.getReachabilityStatus();
            if (s >= rv) continue;
            rv = s;
        }
        return rv;
    }

    public void recheckReachability() {
        for (Transport t : this._transports.values()) {
            t.recheckReachability();
        }
    }

    public boolean isBacklogged(Hash dest) {
        for (Transport t : this._transports.values()) {
            if (!t.isBacklogged(dest)) continue;
            return true;
        }
        return false;
    }

    public boolean isEstablished(Hash dest) {
        for (Transport t : this._transports.values()) {
            if (!t.isEstablished(dest)) continue;
            return true;
        }
        return false;
    }

    public boolean wasUnreachable(Hash dest) {
        for (Transport t : this._transports.values()) {
            if (t.wasUnreachable(dest)) continue;
            return false;
        }
        return true;
    }

    public byte[] getIP(Hash dest) {
        return TransportImpl.getIP(dest);
    }

    public Map<String, RouterAddress> getAddresses() {
        HashMap<String, RouterAddress> rv = new HashMap<String, RouterAddress>(this._transports.size());
        for (Transport t : this._transports.values()) {
            t.updateAddress();
        }
        for (Transport t : this._transports.values()) {
            if (t.getCurrentAddress() == null) continue;
            rv.put(t.getStyle(), t.getCurrentAddress());
        }
        return rv;
    }

    private Map<String, Integer> getPorts() {
        HashMap<String, Integer> rv = new HashMap<String, Integer>(this._transports.size());
        for (Transport t : this._transports.values()) {
            Transport udp;
            int port = t.getRequestedPort();
            if (t.getStyle().equals("NTCP") && port <= 0 && this._context.getBooleanProperty("i2np.ntcp.autoport") && (udp = this.getTransport("SSU")) != null) {
                port = t.getRequestedPort();
            }
            if (port <= 0) continue;
            rv.put(t.getStyle(), port);
        }
        return rv;
    }

    public TransportBid getBid(OutNetMessage msg) {
        List<TransportBid> bids = this.getBids(msg);
        if (bids == null || bids.isEmpty()) {
            return null;
        }
        return bids.get(0);
    }

    public List<TransportBid> getBids(OutNetMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Null message?  no bidding on a null outNetMessage!");
        }
        if (this._context.router().getRouterInfo().equals((Object)msg.getTarget())) {
            throw new IllegalArgumentException("WTF, bids for a message bound to ourselves?");
        }
        ArrayList<TransportBid> rv = new ArrayList<TransportBid>(this._transports.size());
        Set failedTransports = msg.getFailedTransports();
        for (Transport t : this._transports.values()) {
            if (failedTransports.contains(t.getStyle())) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping transport " + t.getStyle() + " as it already failed");
                continue;
            }
            TransportBid bid = t.bid(msg.getTarget(), msg.getMessageSize());
            if (bid != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Transport " + t.getStyle() + " bid: " + bid);
                }
                rv.add(bid);
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Transport " + t.getStyle() + " did not produce a bid");
        }
        return rv;
    }

    public TransportBid getNextBid(OutNetMessage msg) {
        int unreachableTransports = 0;
        Hash peer = msg.getTarget().getIdentity().calculateHash();
        Set failedTransports = msg.getFailedTransports();
        TransportBid rv = null;
        for (Transport t : this._transports.values()) {
            if (t.isUnreachable(peer)) {
                ++unreachableTransports;
                msg.transportFailed(t.getStyle());
                continue;
            }
            if (failedTransports.contains(t.getStyle())) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping transport " + t.getStyle() + " as it already failed");
                continue;
            }
            TransportBid bid = t.bid(msg.getTarget(), msg.getMessageSize());
            if (bid != null) {
                if (bid.getLatencyMs() == 999999) {
                    msg.transportFailed(t.getStyle());
                } else if (rv == null || rv.getLatencyMs() > bid.getLatencyMs()) {
                    rv = bid;
                }
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Transport " + t.getStyle() + " bid: " + bid + " currently winning? " + (rv == bid) + " (winning latency: " + rv.getLatencyMs() + " / " + rv + ")");
                continue;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Transport " + t.getStyle() + " did not produce a bid");
            }
            if (!t.isUnreachable(peer)) continue;
            ++unreachableTransports;
        }
        if (unreachableTransports >= this._transports.size()) {
            if (unreachableTransports >= this._transports.size() && this.countActivePeers() > 0) {
                this._context.statManager().addRateData("transport.banlistOnUnreachable", msg.getLifetime(), msg.getLifetime());
                this._context.banlist().banlistRouter(peer, TransportManager._x("Unreachable on any transport"));
            }
        } else if (rv == null) {
            this._context.statManager().addRateData("transport.noBidsYetNotAllUnreachable", (long)unreachableTransports, msg.getLifetime());
        }
        return rv;
    }

    @Override
    public void messageReceived(I2NPMessage message, RouterIdentity fromRouter, Hash fromRouterHash) {
        block4: {
            if (this._log.shouldLog(10)) {
                this._log.debug("I2NPMessage received: " + message.getClass().getName(), (Throwable)new Exception("Where did I come from again?"));
            }
            try {
                this._context.inNetMessagePool().add(message, fromRouter, fromRouterHash);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Added to in pool");
                }
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block4;
                this._log.warn("Error receiving message", (Throwable)iae);
            }
        }
    }

    @Override
    public void transportAddressChanged() {
        if (this._upnpManager != null) {
            this._upnpManager.update(this.getPorts());
        }
    }

    public List getMostRecentErrorMessages() {
        ArrayList rv = new ArrayList(16);
        for (Transport t : this._transports.values()) {
            rv.addAll(t.getMostRecentErrorMessages());
        }
        return rv;
    }

    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        TreeMap<String, Transport> transports = new TreeMap<String, Transport>();
        for (Transport t : this._transports.values()) {
            transports.put(t.getStyle(), t);
        }
        for (Transport t : transports.values()) {
            t.renderStatusHTML(out, urlBase, sortFlags);
        }
        if (!this._transports.isEmpty()) {
            out.write(this.getTransportsLegend());
        }
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<h3>").append(this._("Router Transport Addresses")).append("</h3><pre>\n");
        for (Transport t : this._transports.values()) {
            if (t.getCurrentAddress() != null) {
                buf.append(t.getCurrentAddress());
            } else {
                buf.append(this._("{0} is used for outbound connections only", t.getStyle()));
            }
            buf.append("\n\n");
        }
        buf.append("</pre>\n");
        out.write(buf.toString());
        if (this._upnpManager != null) {
            out.write(this._upnpManager.renderStatusHTML());
        }
        buf.append("</p>\n");
        out.flush();
    }

    private final String getTransportsLegend() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h3 id=\"help\">").append(this._("Help")).append("</h3><div class=\"configure\"><p>").append(this._("Your transport connection limits are automatically set based on your configured bandwidth.")).append('\n').append(this._("To override these limits, add the settings i2np.ntcp.maxConnections=nnn and i2np.udp.maxConnections=nnn on the advanced configuration page.")).append("</p></div>\n");
        buf.append("<h3>").append(this._("Definitions")).append("</h3><div class=\"configure\"><p><b id=\"def.peer\">").append(this._("Peer")).append("</b>: ").append(this._("The remote peer, identified by router hash")).append("<br>\n<b id=\"def.dir\">").append(this._("Dir")).append("</b>: <img alt=\"Inbound\" src=\"/themes/console/images/inbound.png\"> ").append(this._("Inbound connection")).append("<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img alt=\"Outbound\" src=\"/themes/console/images/outbound.png\"> ").append(this._("Outbound connection")).append("<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src=\"/themes/console/images/inbound.png\" alt=\"V\" height=\"8\" width=\"12\"> ").append(this._("They offered to introduce us (help other peers traverse our firewall)")).append("<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src=\"/themes/console/images/outbound.png\" alt=\"^\" height=\"8\" width=\"12\"> ").append(this._("We offered to introduce them (help other peers traverse their firewall)")).append("<br>\n<b id=\"def.idle\">").append(this._("Idle")).append("</b>: ").append(this._("How long since a packet has been received / sent")).append("<br>\n<b id=\"def.rate\">").append(this._("In/Out")).append("</b>: ").append(this._("The smoothed inbound / outbound transfer rate (KBytes per second)")).append("<br>\n<b id=\"def.up\">").append(this._("Up")).append("</b>: ").append(this._("How long ago this connection was established")).append("<br>\n<b id=\"def.skew\">").append(this._("Skew")).append("</b>: ").append(this._("The difference between the peer's clock and your own")).append("<br>\n<b id=\"def.cwnd\">CWND</b>: ").append(this._("The congestion window, which is how many bytes can be sent without an acknowledgement")).append(" / <br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ").append(this._("The number of sent messages awaiting acknowledgement")).append(" /<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ").append(this._("The maximum number of concurrent messages to send")).append(" /<br>\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ").append(this._("The number of pending sends which exceed congestion window")).append("<br>\n<b id=\"def.ssthresh\">SST</b>: ").append(this._("The slow start threshold")).append("<br>\n<b id=\"def.rtt\">RTT</b>: ").append(this._("The round trip time in milliseconds")).append("<br>\n<b id=\"def.rto\">RTO</b>: ").append(this._("The retransmit timeout in milliseconds")).append("<br>\n<b id=\"def.mtu\">MTU</b>: ").append(this._("Current maximum send packet size / estimated maximum receive packet size (bytes)")).append("<br>\n<b id=\"def.send\">").append(this._("TX")).append("</b>: ").append(this._("The total number of packets sent to the peer")).append("<br>\n<b id=\"def.recv\">").append(this._("RX")).append("</b>: ").append(this._("The total number of packets received from the peer")).append("<br>\n<b id=\"def.resent\">").append(this._("Dup TX")).append("</b>: ").append(this._("The total number of packets retransmitted to the peer")).append("<br>\n<b id=\"def.dupRecv\">").append(this._("Dup RX")).append("</b>: ").append(this._("The total number of duplicate packets received from the peer")).append("</p></div>\n");
        return buf.toString();
    }

    private static final String _x(String s) {
        return s;
    }

    private final String _(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private final String _(String s, Object o) {
        return Translate.getString((String)s, (Object)o, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }
}

