/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.io.File;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.i2p.util.ShellCommand;
import net.i2p.util.SystemVersion;

abstract class ThreadDump {
    ThreadDump() {
    }

    public static boolean dump(I2PAppContext context, int secondsToWait) {
        if (SystemVersion.isWindows() || !context.hasWrapper()) {
            return false;
        }
        ShellCommand sc = new ShellCommand();
        File i2pr = new File(context.getBaseDir(), "i2prouter");
        String[] args = new String[]{i2pr.getAbsolutePath(), "dump"};
        boolean success = sc.executeSilentAndWaitTimed(args, secondsToWait);
        if (secondsToWait <= 0) {
            success = true;
        }
        if (success) {
            Log log = context.logManager().getLog(ThreadDump.class);
            log.log(50, "Threads dumped to wrapper log");
        }
        return success;
    }
}

