/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.util.Properties;
import net.i2p.data.Hash;
import net.i2p.router.ProfileManager;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.Log;

public class ProfileManagerImpl
implements ProfileManager {
    private final Log _log;
    private final RouterContext _context;

    public ProfileManagerImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(ProfileManagerImpl.class);
    }

    public void messageSent(Hash peer, String transport, long msToSend, long bytesSent) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastSendSuccessful(this._context.clock().now());
    }

    public void messageFailed(Hash peer, String transport) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastSendFailed(this._context.clock().now());
    }

    public void messageFailed(Hash peer) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastSendFailed(this._context.clock().now());
    }

    public void commErrorOccurred(Hash peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Comm error occurred for peer " + peer.toBase64(), (Throwable)new Exception("Comm error"));
        }
        PeerProfile data = this.getProfile(peer);
        data.setLastSendFailed(this._context.clock().now());
    }

    public void tunnelJoined(Hash peer, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        data.getTunnelCreateResponseTime().addData(responseTimeMs, responseTimeMs);
        data.setLastHeardFrom(this._context.clock().now());
        data.getTunnelHistory().incrementAgreedTo();
    }

    public void tunnelRejected(Hash peer, long responseTimeMs, int severity) {
        PeerProfile data = this.getProfile(peer);
        data.setLastHeardFrom(this._context.clock().now());
        data.getTunnelHistory().incrementRejected(severity);
    }

    public void tunnelTimedOut(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        data.getTunnelHistory().incrementRejected(30);
    }

    public void tunnelTestSucceeded(Hash peer, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        data.updateTunnelTestTimeAverage(responseTimeMs);
        data.getTunnelTestResponseTime().addData(responseTimeMs, responseTimeMs);
    }

    public void tunnelDataPushed(Hash peer, long rtt, int size) {
        if (this._context.routerHash().equals((Object)peer)) {
            return;
        }
        PeerProfile data = this.getProfile(peer);
        data.dataPushed(size);
    }

    public void tunnelDataPushed1m(Hash peer, int size) {
        if (this._context.routerHash().equals((Object)peer)) {
            return;
        }
        PeerProfile data = this.getProfile(peer);
        data.dataPushed1m(size);
    }

    public void tunnelLifetimePushed(Hash peer, long lifetime, long size) {
        if (this._context.routerHash().equals((Object)peer)) {
            return;
        }
        PeerProfile data = this.getProfile(peer);
        data.tunnelDataTransferred(size);
    }

    public void tunnelFailed(Hash peer, int pct) {
        PeerProfile data = this.getProfile(peer);
        data.setLastHeardFrom(this._context.clock().now());
        data.getTunnelHistory().incrementFailed(pct);
    }

    public void dbLookupSuccessful(Hash peer, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        data.getDbResponseTime().addData(responseTimeMs, responseTimeMs);
        DBHistory hist = data.getDBHistory();
        hist.lookupSuccessful();
    }

    public void dbLookupFailed(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        DBHistory hist = data.getDBHistory();
        hist.lookupFailed();
    }

    public void dbLookupReply(Hash peer, int newPeers, int oldPeers, int invalid, int duplicate, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            return;
        }
        data.getDbResponseTime().addData(responseTimeMs, responseTimeMs);
        data.getDbIntroduction().addData((long)newPeers, responseTimeMs);
        DBHistory hist = data.getDBHistory();
        hist.lookupReply(newPeers, oldPeers, invalid, duplicate);
    }

    public void dbLookupReceived(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            return;
        }
        DBHistory hist = data.getDBHistory();
        hist.lookupReceived();
    }

    public void dbStoreReceived(Hash peer, boolean wasNewKey) {
        PeerProfile data = this.getProfile(peer);
        data.setLastHeardFrom(this._context.clock().now());
        if (!data.getIsExpandedDB()) {
            return;
        }
        DBHistory hist = data.getDBHistory();
        hist.unpromptedStoreReceived(wasNewKey);
    }

    public void dbStoreSent(Hash peer, long responseTimeMs) {
        PeerProfile data = this.getProfile(peer);
        long now = this._context.clock().now();
        data.setLastHeardFrom(now);
        data.setLastSendSuccessful(now);
    }

    public void dbStoreSuccessful(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        long now = this._context.clock().now();
        data.setLastHeardFrom(now);
        data.setLastSendSuccessful(now);
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        DBHistory hist = data.getDBHistory();
        hist.storeSuccessful();
    }

    public void dbStoreFailed(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        if (!data.getIsExpandedDB()) {
            data.expandDBProfile();
        }
        DBHistory hist = data.getDBHistory();
        hist.storeFailed();
    }

    public void heardAbout(Hash peer) {
        PeerProfile data = this.getProfile(peer);
        data.setLastHeardAbout(this._context.clock().now());
    }

    public void heardAbout(Hash peer, long when) {
        PeerProfile data = this.getProfile(peer);
        if (when > data.getLastHeardAbout()) {
            data.setLastHeardAbout(when);
        }
    }

    public void messageReceived(Hash peer, String style, long msToReceive, int bytesRead) {
        PeerProfile data = this.getProfileNonblocking(peer);
        if (data == null) {
            return;
        }
        data.setLastHeardFrom(this._context.clock().now());
    }

    private PeerProfile getProfile(Hash peer) {
        PeerProfile prof = this._context.profileOrganizer().getProfile(peer);
        if (prof == null) {
            prof = new PeerProfile(this._context, peer);
            prof.setFirstHeardAbout(this._context.clock().now());
            this._context.profileOrganizer().addProfile(prof);
        }
        return prof;
    }

    private PeerProfile getProfileNonblocking(Hash peer) {
        return this._context.profileOrganizer().getProfileNonblocking(peer);
    }

    public Properties summarizePeers(int numPeers) {
        Properties props = new Properties();
        return props;
    }
}

