/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TagSetHandle;
import net.i2p.data.Certificate;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.message.GarlicConfig;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.router.message.PayloadGarlicConfig;

class MessageWrapper {
    private static final int NETDB_TAGS_TO_DELIVER = 6;
    private static final int NETDB_LOW_THRESHOLD = 3;

    MessageWrapper() {
    }

    static WrappedMessage wrap(RouterContext ctx, I2NPMessage m, Hash from, RouterInfo to) {
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(0);
        PayloadGarlicConfig payload = new PayloadGarlicConfig();
        payload.setCertificate(Certificate.NULL_CERT);
        payload.setId(ctx.random().nextLong(0xFFFFFFFFL));
        payload.setPayload(m);
        payload.setRecipient(to);
        payload.setDeliveryInstructions(instructions);
        payload.setExpiration(m.getMessageExpiration());
        SessionKeyManager skm = from != null ? ctx.clientManager().getClientSessionKeyManager(from) : ctx.sessionKeyManager();
        if (skm == null) {
            return null;
        }
        SessionKey sentKey = new SessionKey();
        HashSet<SessionTag> sentTags = new HashSet<SessionTag>();
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(ctx, (GarlicConfig)payload, sentKey, sentTags, 6, 3, skm);
        if (msg == null) {
            return null;
        }
        TagSetHandle tsh = null;
        PublicKey sentTo = to.getIdentity().getPublicKey();
        if (!sentTags.isEmpty()) {
            tsh = skm.tagsDelivered(sentTo, sentKey, sentTags);
        }
        return new WrappedMessage(msg, skm, sentTo, sentKey, tsh);
    }

    static GarlicMessage wrap(RouterContext ctx, I2NPMessage m, RouterInfo to) {
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(0);
        PayloadGarlicConfig payload = new PayloadGarlicConfig();
        payload.setCertificate(Certificate.NULL_CERT);
        payload.setId(ctx.random().nextLong(0xFFFFFFFFL));
        payload.setPayload(m);
        payload.setRecipient(to);
        payload.setDeliveryInstructions(instructions);
        payload.setExpiration(m.getMessageExpiration());
        SessionKey sentKey = ctx.keyGenerator().generateSessionKey();
        PublicKey key = to.getIdentity().getPublicKey();
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(ctx, (GarlicConfig)payload, null, null, key, sentKey, null);
        return msg;
    }

    static class WrappedMessage {
        private GarlicMessage msg;
        private SessionKeyManager skm;
        private PublicKey sentTo;
        private SessionKey sessionKey;
        private TagSetHandle tsh;

        WrappedMessage(GarlicMessage msg, SessionKeyManager skm, PublicKey sentTo, SessionKey sentKey, TagSetHandle tsh) {
            this.msg = msg;
            this.skm = skm;
            this.sentTo = sentTo;
            this.sessionKey = sentKey;
            this.tsh = tsh;
        }

        GarlicMessage getMessage() {
            return this.msg;
        }

        void acked() {
            if (this.tsh != null) {
                this.skm.tagsAcked(this.sentTo, this.sessionKey, this.tsh);
            }
        }

        void fail() {
            if (this.tsh != null) {
                this.skm.failTags(this.sentTo, this.sessionKey, this.tsh);
            }
        }
    }
}

