/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.Date;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.RequestLeaseSetMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.LeaseRequestState;
import net.i2p.util.Log;

class RequestLeaseSetJob
extends JobImpl {
    private final Log _log;
    private final ClientConnectionRunner _runner;
    private final LeaseRequestState _requestState;

    public RequestLeaseSetJob(RouterContext ctx, ClientConnectionRunner runner, LeaseRequestState state) {
        super(ctx);
        this._log = ctx.logManager().getLog(RequestLeaseSetJob.class);
        this._runner = runner;
        this._requestState = state;
    }

    public String getName() {
        return "Request Lease Set";
    }

    public void runJob() {
        if (this._runner.isDead()) {
            return;
        }
        RequestLeaseSetMessage msg = new RequestLeaseSetMessage();
        long endTime = this._requestState.getRequested().getEarliestLeaseDate();
        long fudge = 300L - (endTime - this.getContext().clock().now()) / 2000L;
        Date end = new Date(endTime += fudge);
        msg.setEndDate(end);
        msg.setSessionId(this._runner.getSessionId());
        for (int i = 0; i < this._requestState.getRequested().getLeaseCount(); ++i) {
            msg.addEndpoint(this._requestState.getRequested().getLease(i).getGateway(), this._requestState.getRequested().getLease(i).getTunnelId());
        }
        try {
            this._runner.doSend((I2CPMessage)msg);
            this.getContext().jobQueue().addJob(new CheckLeaseRequestStatus());
        }
        catch (I2CPMessageException ime) {
            this.getContext().statManager().addRateData("client.requestLeaseSetDropped", 1L, 0L);
            this._log.error("Error sending I2CP message requesting the lease set", (Throwable)ime);
            this._requestState.setIsSuccessful(false);
            if (this._requestState.getOnFailed() != null) {
                this.getContext().jobQueue().addJob(this._requestState.getOnFailed());
            }
            this._runner.failLeaseRequest(this._requestState);
        }
    }

    private class CheckLeaseRequestStatus
    extends JobImpl {
        private final long _start;

        public CheckLeaseRequestStatus() {
            super(RequestLeaseSetJob.this.getContext());
            this._start = System.currentTimeMillis();
            this.getTiming().setStartAfter(RequestLeaseSetJob.this._requestState.getExpiration());
        }

        public void runJob() {
            if (RequestLeaseSetJob.this._runner.isDead()) {
                if (RequestLeaseSetJob.this._log.shouldLog(10)) {
                    RequestLeaseSetJob.this._log.debug("Already dead, dont try to expire the leaseSet lookup");
                }
                return;
            }
            if (RequestLeaseSetJob.this._requestState.getIsSuccessful()) {
                this.getContext().statManager().addRateData("client.requestLeaseSetSuccess", 1L);
                return;
            }
            this.getContext().statManager().addRateData("client.requestLeaseSetTimeout", 1L);
            if (RequestLeaseSetJob.this._log.shouldLog(40)) {
                long waited = System.currentTimeMillis() - this._start;
                RequestLeaseSetJob.this._log.error("Failed to receive a leaseSet in the time allotted (" + waited + "): " + RequestLeaseSetJob.this._requestState + " for " + RequestLeaseSetJob.this._runner.getConfig().getDestination().calculateHash().toBase64());
            }
            if (RequestLeaseSetJob.this._requestState.getOnFailed() != null) {
                RequestLeaseSetJob.this.getContext().jobQueue().addJob(RequestLeaseSetJob.this._requestState.getOnFailed());
            }
            RequestLeaseSetJob.this._runner.failLeaseRequest(RequestLeaseSetJob.this._requestState);
        }

        public String getName() {
            return "Check LeaseRequest Status";
        }
    }
}

