/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.HashMap;
import net.i2p.router.web.ConsolePasswordManager;
import net.i2p.router.web.FormHandler;

public class ConfigUIHandler
extends FormHandler {
    private boolean _shouldSave;
    private boolean _universalTheming;
    private boolean _forceMobileConsole;
    private String _config;

    protected void processForm() {
        if (this._shouldSave) {
            this.saveChanges();
        } else if (this._action.equals(this._("Delete selected"))) {
            this.delUser();
        } else if (this._action.equals(this._("Add user"))) {
            this.addUser();
        }
    }

    public void setShouldsave(String moo) {
        this._shouldSave = true;
    }

    public void setUniversalTheming(String baa) {
        this._universalTheming = true;
    }

    public void setForceMobileConsole(String baa) {
        this._forceMobileConsole = true;
    }

    public void setTheme(String val) {
        this._config = val;
    }

    private void saveChanges() {
        if (this._config == null) {
            return;
        }
        HashMap<String, String> changes = new HashMap<String, String>();
        ArrayList<String> removes = new ArrayList<String>();
        String oldTheme = this._context.getProperty("routerconsole.theme", "light");
        boolean oldForceMobileConsole = this._context.getBooleanProperty("routerconsole.forceMobileConsole");
        if (this._config.equals("default")) {
            removes.add("routerconsole.theme");
        } else {
            changes.put("routerconsole.theme", this._config);
        }
        if (this._universalTheming) {
            changes.put("routerconsole.universal.theme", "true");
        } else {
            removes.add("routerconsole.universal.theme");
        }
        if (this._forceMobileConsole) {
            changes.put("routerconsole.forceMobileConsole", "true");
        } else {
            removes.add("routerconsole.forceMobileConsole");
        }
        boolean ok = this._context.router().saveConfig(changes, removes);
        if (ok) {
            if (!oldTheme.equals(this._config)) {
                this.addFormNotice(this._("Theme change saved.") + " <a href=\"configui\">" + this._("Refresh the page to view.") + "</a>");
            }
            if (oldForceMobileConsole != this._forceMobileConsole) {
                this.addFormNotice(this._("Mobile console option saved.") + " <a href=\"configui\">" + this._("Refresh the page to view.") + "</a>");
            }
        } else {
            this.addFormError(this._("Error saving the configuration (applied but not saved) - please see the error logs."));
        }
    }

    private void addUser() {
        String name = this.getJettyString("name");
        if (name == null || name.length() <= 0) {
            this.addFormError(this._("No user name entered"));
            return;
        }
        String pw = this.getJettyString("pw");
        if (pw == null || pw.length() <= 0) {
            this.addFormError(this._("No password entered"));
            return;
        }
        ConsolePasswordManager mgr = new ConsolePasswordManager(this._context);
        if (mgr.saveMD5("routerconsole.auth.i2prouter", "i2prouter", name, pw)) {
            if (!this._context.getBooleanProperty("routerconsole.auth.enable")) {
                this._context.router().saveConfig("routerconsole.auth.enable", "true");
            }
            this.addFormNotice(this._("Added user {0}", name));
            this.addFormNotice(this._("Restart required to take effect"));
        } else {
            this.addFormError(this._("Error saving the configuration (applied but not saved) - please see the error logs."));
        }
    }

    private void delUser() {
        ConsolePasswordManager mgr = new ConsolePasswordManager(this._context);
        boolean success = false;
        for (Object o : this._settings.keySet()) {
            String k;
            if (!(o instanceof String) || !(k = (String)o).startsWith("delete_")) continue;
            if (mgr.remove("routerconsole.auth.i2prouter", k = k.substring(7))) {
                this.addFormNotice(this._("Removed user {0}", k));
                success = true;
                continue;
            }
            this.addFormError(this._("Error saving the configuration (applied but not saved) - please see the error logs."));
        }
        if (success) {
            this.addFormNotice(this._("Restart required to take effect"));
        }
    }
}

