/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.util.Queue;
import net.i2p.data.DataHelper;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCoordinator;

class PeerMonitorTask
implements Runnable {
    static final long MONITOR_PERIOD = 10000L;
    private static final long KILOPERSECOND = 10240L;
    private final PeerCoordinator coordinator;
    private long lastDownloaded = 0L;
    private long lastUploaded = 0L;

    PeerMonitorTask(PeerCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int peers = 0;
        int uploaders = 0;
        int downloaders = 0;
        int interested = 0;
        int interesting = 0;
        int choking = 0;
        int choked = 0;
        Queue<Peer> queue = this.coordinator.peers;
        synchronized (queue) {
            for (Peer peer : this.coordinator.peers) {
                if (!peer.isConnected()) continue;
                ++peers;
                if (!peer.isChoking()) {
                    ++uploaders;
                }
                if (!peer.isChoked() && peer.isInteresting()) {
                    ++downloaders;
                }
                if (peer.isInterested()) {
                    ++interested;
                }
                if (peer.isInteresting()) {
                    ++interesting;
                }
                if (peer.isChoking()) {
                    ++choking;
                }
                if (!peer.isChoked()) continue;
                ++choked;
            }
        }
        long downloaded = this.coordinator.getDownloaded();
        String totalDown = DataHelper.formatSize(downloaded) + "B";
        long uploaded = this.coordinator.getUploaded();
        String totalUp = DataHelper.formatSize(uploaded) + "B";
        int needP = this.coordinator.storage.needed();
        long needMB = needP * this.coordinator.metainfo.getPieceLength(0) / 0x100000;
        int totalP = this.coordinator.metainfo.getPieces();
        long totalMB = this.coordinator.metainfo.getTotalLength() / 0x100000L;
        System.out.println();
        System.out.println("Down: " + (downloaded - this.lastDownloaded) / 10240L + "KB/s" + " (" + totalDown + ")" + " Up: " + (uploaded - this.lastUploaded) / 10240L + "KB/s" + " (" + totalUp + ")" + " Need " + needP + " (" + needMB + "MB)" + " of " + totalP + " (" + totalMB + "MB)" + " pieces");
        System.out.println(peers + ": Download #" + downloaders + " Upload #" + uploaders + " Interested #" + interested + " Interesting #" + interesting + " Choking #" + choking + " Choked #" + choked);
        System.out.println();
        this.lastDownloaded = downloaded;
        this.lastUploaded = uploaded;
    }
}

