/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.Hash;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.PeerAcceptor;
import org.klomp.snark.PeerCoordinatorSet;

class ConnectionAcceptor
implements Runnable {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(ConnectionAcceptor.class);
    private I2PServerSocket serverSocket;
    private PeerAcceptor peeracceptor;
    private Thread thread;
    private final I2PSnarkUtil _util;
    private final ObjectCounter<Hash> _badCounter = new ObjectCounter();
    private boolean stop;
    private boolean socketChanged;
    private static final int MAX_BAD = 2;
    private static final long BAD_CLEAN_INTERVAL = 1800000L;

    public ConnectionAcceptor(I2PSnarkUtil util) {
        this._util = util;
    }

    public synchronized void startAccepting(PeerCoordinatorSet set, I2PServerSocket socket) {
        if (this.serverSocket != socket) {
            if (this.peeracceptor == null || this.peeracceptor.coordinators != set) {
                this.peeracceptor = new PeerAcceptor(set);
            }
            this.serverSocket = socket;
            this.stop = false;
            this.socketChanged = true;
            if (this.thread == null) {
                this.thread = new I2PAppThread(this, "I2PSnark acceptor");
                this.thread.setDaemon(true);
                this.thread.start();
                this._util.getContext().simpleScheduler().addPeriodicEvent(new Cleaner(), 1800000L);
            }
        }
    }

    public ConnectionAcceptor(I2PSnarkUtil util, I2PServerSocket serverSocket, PeerAcceptor peeracceptor) {
        this.serverSocket = serverSocket;
        this.peeracceptor = peeracceptor;
        this._util = util;
        this.thread = new I2PAppThread(this, "I2PSnark acceptor");
        this.thread.setDaemon(true);
        this.thread.start();
        this._util.getContext().simpleScheduler().addPeriodicEvent(new Cleaner(), 1800000L);
    }

    public void halt() {
        Thread t;
        if (this.stop) {
            return;
        }
        this.stop = true;
        I2PServerSocket ss = this.serverSocket;
        if (ss != null) {
            try {
                ss.close();
            }
            catch (I2PException ioe) {
                // empty catch block
            }
        }
        if ((t = this.thread) != null) {
            t.interrupt();
        }
    }

    public void restart() {
        this.serverSocket = this._util.getServerSocket();
        this.socketChanged = true;
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
        }
    }

    public int getPort() {
        return 6881;
    }

    public void run() {
        while (!this.stop) {
            if (this.socketChanged) {
                this.socketChanged = false;
            }
            while (this.serverSocket == null && !this.stop) {
                this.serverSocket = this._util.getServerSocket();
                if (this.serverSocket != null) continue;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ie) {}
            }
            if (this.stop) break;
            try {
                I2PSocket socket = this.serverSocket.accept();
                if (socket == null) {
                    I2PServerSocket ss;
                    if (this.socketChanged || (ss = this._util.getServerSocket()) == this.serverSocket) continue;
                    this.serverSocket = ss;
                    this.socketChanged = true;
                    continue;
                }
                if (socket.getPeerDestination().equals(this._util.getMyDestination())) {
                    this._log.error("Incoming connection from myself");
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {}
                    continue;
                }
                if (this._badCounter.count(socket.getPeerDestination().calculateHash()) >= 2) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Rejecting connection from " + socket.getPeerDestination().calculateHash() + " after " + 2 + " failures");
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {}
                    continue;
                }
                I2PAppThread t = new I2PAppThread(new Handler(socket), "I2PSnark incoming connection");
                t.start();
            }
            catch (I2PException ioe) {
                if (this.socketChanged) continue;
                this._log.error("Error while accepting", ioe);
                this.stop = true;
            }
            catch (IOException ioe) {
                this._log.error("Error while accepting", ioe);
                this.stop = true;
            }
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (I2PException i2PException) {
            // empty catch block
        }
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        public void timeReached() {
            ConnectionAcceptor.this._badCounter.clear();
        }
    }

    private class Handler
    implements Runnable {
        private final I2PSocket _socket;

        public Handler(I2PSocket socket) {
            this._socket = socket;
        }

        public void run() {
            try {
                InputStream in = this._socket.getInputStream();
                OutputStream out = this._socket.getOutputStream();
                in = new BufferedInputStream(in);
                if (ConnectionAcceptor.this._log.shouldLog(10)) {
                    ConnectionAcceptor.this._log.debug("Handling socket from " + this._socket.getPeerDestination().calculateHash());
                }
                ConnectionAcceptor.this.peeracceptor.connection(this._socket, in, out);
            }
            catch (PeerAcceptor.ProtocolException ihe) {
                ConnectionAcceptor.this._badCounter.increment(this._socket.getPeerDestination().calculateHash());
                if (ConnectionAcceptor.this._log.shouldLog(20)) {
                    ConnectionAcceptor.this._log.info("Protocol error from " + this._socket.getPeerDestination().calculateHash(), ihe);
                }
                try {
                    this._socket.close();
                }
                catch (IOException ignored) {}
            }
            catch (IOException ioe) {
                if (ConnectionAcceptor.this._log.shouldLog(10)) {
                    ConnectionAcceptor.this._log.debug("Error handling connection from " + this._socket.getPeerDestination().calculateHash(), ioe);
                }
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

