/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.naming.NamingService;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.sam.SAMException;
import net.i2p.util.Log;

public class SAMUtils {
    private static final Log _log = new Log(SAMUtils.class);

    public static void genRandomKey(OutputStream priv, OutputStream pub) {
        _log.debug("Generating random keys...");
        try {
            I2PClient c = I2PClientFactory.createClient();
            Destination d = c.createDestination(priv);
            priv.flush();
            if (pub != null) {
                d.writeBytes(pub);
                pub.flush();
            }
        }
        catch (I2PException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkDestination(String dest) {
        try {
            Destination d = new Destination();
            d.fromBase64(dest);
            return true;
        }
        catch (DataFormatException e) {
            return false;
        }
    }

    public static void checkPrivateDestination(String dest) throws InvalidDestination {
        ByteArrayInputStream destKeyStream = new ByteArrayInputStream(Base64.decode(dest));
        try {
            new Destination().readBytes(destKeyStream);
            new PrivateKey().readBytes(destKeyStream);
            new SigningPrivateKey().readBytes(destKeyStream);
        }
        catch (Exception e) {
            throw new InvalidDestination();
        }
    }

    public static Destination lookupHost(String name, OutputStream pubKey) {
        NamingService ns = I2PAppContext.getGlobalContext().namingService();
        Destination dest = ns.lookup(name);
        if (pubKey != null && dest != null) {
            try {
                dest.writeBytes(pubKey);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (DataFormatException e) {
                e.printStackTrace();
                return null;
            }
        }
        return dest;
    }

    public static Destination getDest(String s) throws DataFormatException {
        Destination d;
        block2: {
            d = new Destination();
            try {
                d.fromBase64(s);
            }
            catch (DataFormatException e) {
                d = SAMUtils.lookupHost(s, null);
                if (d != null) break block2;
                throw e;
            }
        }
        return d;
    }

    public static Properties parseParams(StringTokenizer tok) throws SAMException {
        int ntoks = tok.countTokens();
        Properties props = new Properties();
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < ntoks; ++i) {
            String token = tok.nextToken();
            int pos = token.indexOf("=");
            if (pos == -1) {
                _log.debug("Error in params format");
                throw new SAMException("Bad formatting for param [" + token + "]");
            }
            String param = token.substring(0, pos);
            value.append(token.substring(pos + 1));
            if (value.length() == 0) {
                throw new SAMException("Empty value for param " + param);
            }
            if (value.charAt(0) == '\"') {
                while (i < ntoks && value.lastIndexOf("\"") <= 0) {
                    value.append(' ').append(tok.nextToken());
                    ++i;
                }
            }
            props.setProperty(param, value.toString());
            value.setLength(0);
        }
        if (_log.shouldLog(10)) {
            _log.debug("Parsed properties: " + SAMUtils.dumpProperties(props));
        }
        return props;
    }

    private static String dumpProperties(Properties props) {
        Enumeration<?> names = props.propertyNames();
        String msg = "";
        boolean firstIter = true;
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            String val = props.getProperty(key);
            if (!firstIter) {
                msg = msg + ";";
            } else {
                firstIter = false;
            }
            msg = msg + " \"" + key + "\" -> \"" + val + "\"";
        }
        return msg;
    }

    public static class InvalidDestination
    extends Exception {
        static final long serialVersionUID = 1L;
    }
}

