/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.data.DataHelper;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMHandler;
import net.i2p.sam.SAMUtils;
import net.i2p.sam.SAMv1Handler;
import net.i2p.sam.SAMv2Handler;
import net.i2p.sam.SAMv3Handler;
import net.i2p.util.Log;

public class SAMHandlerFactory {
    private static final Log _log = new Log(SAMHandlerFactory.class);

    public static SAMHandler createSAMHandler(SocketChannel s, Properties i2cpProps) throws SAMException {
        SAMv1Handler handler;
        StringTokenizer tok;
        try {
            String line = DataHelper.readLine(s.socket().getInputStream());
            if (line == null) {
                _log.debug("Connection closed by client");
                return null;
            }
            tok = new StringTokenizer(line.trim(), " ");
        }
        catch (IOException e) {
            throw new SAMException("Error reading from socket: " + e.getMessage());
        }
        catch (Exception e) {
            throw new SAMException("Unexpected error: " + e.getMessage());
        }
        if (tok.countTokens() != 4) {
            throw new SAMException("Bad format in HELLO message");
        }
        if (!tok.nextToken().equals("HELLO")) {
            throw new SAMException("Bad domain in HELLO message");
        }
        String opcode = tok.nextToken();
        if (!opcode.equals("VERSION")) {
            throw new SAMException("Unrecognized HELLO message opcode: '" + opcode + "'");
        }
        Properties props = SAMUtils.parseParams(tok);
        if (props == null) {
            throw new SAMException("No parameters in HELLO VERSION message");
        }
        String minVer = props.getProperty("MIN");
        if (minVer == null) {
            throw new SAMException("Missing MIN parameter in HELLO VERSION message");
        }
        String maxVer = props.getProperty("MAX");
        if (maxVer == null) {
            throw new SAMException("Missing MAX parameter in HELLO VERSION message");
        }
        String ver = SAMHandlerFactory.chooseBestVersion(minVer, maxVer);
        try {
            if (ver == null) {
                s.write(ByteBuffer.wrap("HELLO REPLY RESULT=NOVERSION\n".getBytes("ISO-8859-1")));
                return null;
            }
            s.write(ByteBuffer.wrap(("HELLO REPLY RESULT=OK VERSION=" + ver + "\n").getBytes("ISO-8859-1")));
        }
        catch (UnsupportedEncodingException e) {
            _log.error("Caught UnsupportedEncodingException (" + e.getMessage() + ")");
            throw new SAMException("Character encoding error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new SAMException("Error writing to socket: " + e.getMessage());
        }
        int verMajor = SAMHandlerFactory.getMajor(ver);
        int verMinor = SAMHandlerFactory.getMinor(ver);
        try {
            switch (verMajor) {
                case 1: {
                    handler = new SAMv1Handler(s, verMajor, verMinor, i2cpProps);
                    break;
                }
                case 2: {
                    handler = new SAMv2Handler(s, verMajor, verMinor, i2cpProps);
                    break;
                }
                case 3: {
                    handler = new SAMv3Handler(s, verMajor, verMinor, i2cpProps);
                    break;
                }
                default: {
                    _log.error("BUG! Trying to initialize the wrong SAM version!");
                    throw new SAMException("BUG! (in handler instantiation)");
                }
            }
        }
        catch (IOException e) {
            _log.error("Error creating the handler for version " + verMajor, e);
            throw new SAMException("IOException caught during SAM handler instantiation");
        }
        return handler;
    }

    private static String chooseBestVersion(String minVer, String maxVer) {
        int minMajor = SAMHandlerFactory.getMajor(minVer);
        int minMinor = SAMHandlerFactory.getMinor(minVer);
        int maxMajor = SAMHandlerFactory.getMajor(maxVer);
        int maxMinor = SAMHandlerFactory.getMinor(maxVer);
        if (minMajor == -1 || minMinor == -1 || maxMajor == -1 || maxMinor == -1) {
            return null;
        }
        if (minMinor >= 10 || maxMinor >= 10) {
            return null;
        }
        float fminVer = (float)minMajor + (float)minMinor / 10.0f;
        float fmaxVer = (float)maxMajor + (float)maxMinor / 10.0f;
        if ((double)fminVer <= 3.0 && (double)fmaxVer >= 3.0) {
            return "3.0";
        }
        if ((double)fminVer <= 2.0 && (double)fmaxVer >= 2.0) {
            return "2.0";
        }
        if ((double)fminVer <= 1.0 && (double)fmaxVer >= 1.0) {
            return "1.0";
        }
        return null;
    }

    private static int getMajor(String ver) {
        if (ver == null || ver.indexOf(46) < 0) {
            return -1;
        }
        try {
            String major = ver.substring(0, ver.indexOf("."));
            return Integer.parseInt(major);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    private static int getMinor(String ver) {
        if (ver == null || ver.indexOf(46) < 0) {
            return -1;
        }
        try {
            String major = ver.substring(ver.indexOf(".") + 1);
            return Integer.parseInt(major);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }
}

