/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.apps.systray;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.util.ShellCommand;
import net.i2p.util.SystemVersion;

public class UrlLauncher {
    ShellCommand _shellCommand = new ShellCommand();
    private static final int WAIT_TIME = 5000;
    private static final int MAX_WAIT_TIME = 300000;
    private static final int MAX_TRIES = 99;
    private static final String[] BROWSERS = new String[]{"sensible-browser", "xdg-open", "x-www-browser", "defaultbrowser", "opera -newpage", "firefox", "mozilla", "netscape", "konqueror", "galeon", "www-browser", "links", "lynx"};

    public boolean waitForServer(String urlString) {
        InetSocketAddress sa;
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return false;
        }
        String host = url.getHost();
        int port = url.getPort();
        if (port <= 0 && (port = url.getDefaultPort()) <= 0) {
            return false;
        }
        try {
            sa = new InetSocketAddress(host, port);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        long done = System.currentTimeMillis() + 300000L;
        for (int i = 0; i < 99; ++i) {
            try {
                Socket test = new Socket();
                test.connect(sa, 5000);
                try {
                    test.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                return true;
            }
            catch (Exception e) {
                if (System.currentTimeMillis() > done) break;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openUrl(String url) throws Exception {
        String osName = System.getProperty("os.name");
        this.waitForServer(url);
        if (this.validateUrlFormat(url)) {
            if (osName.toLowerCase(Locale.US).indexOf("mac") > -1) {
                if (osName.toLowerCase(Locale.US).startsWith("mac os x")) {
                    if (this._shellCommand.executeSilentAndWaitTimed("open " + url, 5)) {
                        return true;
                    }
                } else {
                    return false;
                }
                if (this._shellCommand.executeSilentAndWaitTimed("iexplore " + url, 5)) {
                    return true;
                }
            } else if (SystemVersion.isWindows()) {
                String browserString = "\"C:\\Program Files\\Internet Explorer\\iexplore.exe\" -nohome";
                BufferedReader bufferedReader = null;
                File foo = new File(I2PAppContext.getGlobalContext().getTempDir(), "browser.reg");
                this._shellCommand.executeSilentAndWait("regedit /E \"" + foo.getAbsolutePath() + "\" \"HKEY_CLASSES_ROOT\\http\\shell\\open\\command\"");
                try {
                    String line;
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(foo), "UTF-16"));
                    while ((line = bufferedReader.readLine()) != null) {
                        if (!line.startsWith("@=")) continue;
                        browserString = line.substring(3, line.toLowerCase(Locale.US).indexOf(".exe") + 4);
                        if (browserString.startsWith("\\\"")) {
                            browserString = browserString.substring(2);
                        }
                        browserString = "\"" + browserString + "\"";
                    }
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    foo.delete();
                }
                catch (Exception e) {
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
                if (this._shellCommand.executeSilentAndWaitTimed(browserString + ' ' + url, 5)) {
                    return true;
                }
            }
            for (int i = 0; i < BROWSERS.length; ++i) {
                if (!this._shellCommand.executeSilentAndWaitTimed(BROWSERS[i] + ' ' + url, 5)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean openUrl(String url, String browser) throws Exception {
        this.waitForServer(url);
        return this.validateUrlFormat(url) && this._shellCommand.executeSilentAndWaitTimed(browser + " " + url, 5);
    }

    private boolean validateUrlFormat(String urlString) {
        try {
            new URL(urlString);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        UrlLauncher launcher = new UrlLauncher();
        try {
            if (args.length > 0) {
                launcher.openUrl(args[0]);
            } else {
                launcher.openUrl("http://127.0.0.1:7657/index.jsp");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

