/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;

public class UDPSource
implements Source,
Runnable {
    public static final int MAX_SIZE = 15360;
    protected DatagramSocket sock;
    protected Sink sink = null;
    protected Thread thread;

    public UDPSource(int port) {
        try {
            this.sock = new DatagramSocket(port);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to listen...", e);
        }
        this.thread = new Thread(this);
    }

    public UDPSource(DatagramSocket sock) {
        this.sock = sock;
        this.thread = new Thread(this);
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public void start() {
        this.thread.start();
    }

    public void run() {
        byte[] buf = new byte[15360];
        DatagramPacket pack = new DatagramPacket(buf, buf.length);
        try {
            while (true) {
                this.sock.receive(pack);
                byte[] nbuf = new byte[pack.getLength()];
                System.arraycopy(pack.getData(), 0, nbuf, 0, nbuf.length);
                this.sink.send(null, nbuf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void stop() {
        this.sock.close();
    }
}

