/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import net.i2p.i2ptunnel.socks.SOCKS4aServer;
import net.i2p.i2ptunnel.socks.SOCKS5Server;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.util.Log;

public class SOCKSServerFactory {
    private static final Log _log = new Log(SOCKSServerFactory.class);
    private static final String ERR_REQUEST_DENIED = "HTTP/1.1 403 Access Denied - This is a SOCKS proxy, not a HTTP proxy\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\n\r\n<html><body><H1>I2P SOCKS PROXY ERROR: REQUEST DENIED</H1>Your browser is misconfigured. This is a SOCKS proxy, not a HTTP proxy</body></html>";

    public static SOCKSServer createSOCKSServer(Socket s, Properties props) throws SOCKSException {
        SOCKSServer serv;
        try {
            DataInputStream in = new DataInputStream(s.getInputStream());
            byte socksVer = in.readByte();
            switch (socksVer) {
                case 4: {
                    if (Boolean.parseBoolean(props.getProperty("proxyAuth")) && props.containsKey("proxyUsername") && props.containsKey("proxyPassword")) {
                        throw new SOCKSException("SOCKS 4/4a not supported when authorization is required");
                    }
                    serv = new SOCKS4aServer(s, props);
                    break;
                }
                case 5: {
                    serv = new SOCKS5Server(s, props);
                    break;
                }
                case 67: 
                case 71: 
                case 72: 
                case 80: {
                    DataOutputStream out = new DataOutputStream(s.getOutputStream());
                    out.write(ERR_REQUEST_DENIED.getBytes());
                    throw new SOCKSException("HTTP request to socks");
                }
                default: {
                    throw new SOCKSException("SOCKS protocol version not supported (" + Integer.toHexString(socksVer) + ")");
                }
            }
        }
        catch (IOException e) {
            _log.debug("error reading SOCKS protocol version");
            throw new SOCKSException("Connection error (" + e.getMessage() + ")");
        }
        return serv;
    }
}

