/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.net.Socket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.irc.IrcInboundFilter;
import net.i2p.i2ptunnel.irc.IrcOutboundFilter;
import net.i2p.i2ptunnel.socks.I2PSOCKSTunnel;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.i2ptunnel.socks.SOCKSServerFactory;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PAppThread;

public class I2PSOCKSIRCTunnel
extends I2PSOCKSTunnel {
    private static int __clientId = 0;

    public I2PSOCKSIRCTunnel(int localPort, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel, String pkf) {
        super(localPort, l, ownDest, notifyThis, tunnel, pkf);
        this.setName("SOCKS IRC Proxy on " + tunnel.listenHost + ':' + localPort);
    }

    protected void clientConnectionRun(Socket s) {
        try {
            SOCKSServer serv = SOCKSServerFactory.createSOCKSServer(s, this.getTunnel().getClientOptions());
            Socket clientSock = serv.getClientSocket();
            I2PSocket destSock = serv.getDestinationI2PSocket(this);
            StringBuffer expectedPong = new StringBuffer();
            I2PAppThread in = new I2PAppThread(new IrcInboundFilter(clientSock, destSock, expectedPong, this._log), "SOCKS IRC Client " + ++__clientId + " in", true);
            in.start();
            I2PAppThread out = new I2PAppThread(new IrcOutboundFilter(clientSock, destSock, expectedPong, this._log), "SOCKS IRC Client " + __clientId + " out", true);
            out.start();
        }
        catch (SOCKSException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error from SOCKS connection", e);
            }
            I2PSOCKSIRCTunnel.closeSocket(s);
        }
    }
}

