/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.TunnelController;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SystemVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TunnelControllerGroup
implements ClientApp {
    private final Log _log;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;
    private final I2PAppContext _context;
    private final ClientAppManager _mgr;
    private static volatile TunnelControllerGroup _instance;
    static final String DEFAULT_CONFIG_FILE = "i2ptunnel.config";
    private final List<TunnelController> _controllers;
    private final String _configFile;
    private static final String REGISTERED_NAME = "i2ptunnel";
    private final Map<I2PSession, Set<TunnelController>> _sessions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TunnelControllerGroup getInstance() {
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance == null) {
                I2PAppContext ctx = I2PAppContext.getGlobalContext();
                if (SystemVersion.isAndroid() || !ctx.isRouterContext()) {
                    _instance = new TunnelControllerGroup(ctx, null, null);
                    _instance.startup();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunnelControllerGroup(I2PAppContext context, ClientAppManager mgr, String[] args) {
        this._context = context;
        this._mgr = mgr;
        this._log = this._context.logManager().getLog(TunnelControllerGroup.class);
        this._controllers = new ArrayList<TunnelController>();
        if (args == null || args.length <= 0) {
            this._configFile = DEFAULT_CONFIG_FILE;
        } else if (args.length == 1) {
            this._configFile = args[0];
        } else {
            throw new IllegalArgumentException("Usage: TunnelControllerGroup [filename]");
        }
        this._sessions = new HashMap<I2PSession, Set<TunnelController>>(4);
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance == null) {
                _instance = this;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (_instance != this) {
                this._log.logAlways(30, "New TunnelControllerGroup, now you have two");
                if (this._log.shouldLog(30)) {
                    this._log.warn("I did it", new Exception());
                }
            }
            this._state = ClientAppState.INITIALIZED;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            _instance = new TunnelControllerGroup(I2PAppContext.getGlobalContext(), null, args);
            _instance.startup();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void startup() {
        this.loadControllers(this._configFile);
        if (this._mgr != null) {
            this._mgr.register(this);
        } else {
            this._context.addShutdownTask(new Shutdown());
        }
    }

    @Override
    public ClientAppState getState() {
        return this._state;
    }

    @Override
    public String getName() {
        return REGISTERED_NAME;
    }

    @Override
    public String getDisplayName() {
        return REGISTERED_NAME;
    }

    private void changeState(ClientAppState state) {
        this.changeState(state, null);
    }

    private synchronized void changeState(ClientAppState state, Exception e) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify(this, state, null, e);
        }
    }

    @Override
    public void shutdown(String[] args) {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this._state != ClientAppState.STARTING && this._state != ClientAppState.RUNNING) {
            return;
        }
        this.changeState(ClientAppState.STOPPING);
        if (this._mgr != null) {
            this._mgr.unregister(this);
        }
        this.unloadControllers();
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance == this) {
                _instance = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            I2PTunnelClientBase.killClientExecutor();
            this.changeState(ClientAppState.STOPPED);
            return;
        }
    }

    public synchronized void loadControllers(String configFile) {
        String type;
        this.changeState(ClientAppState.STARTING);
        Properties cfg = this.loadConfig(configFile);
        int i = 0;
        while ((type = cfg.getProperty("tunnel." + i + ".type")) != null) {
            TunnelController controller = new TunnelController(cfg, "tunnel." + i + ".");
            this._controllers.add(controller);
            ++i;
        }
        I2PAppThread startupThread = new I2PAppThread(new StartControllers(), "Startup tunnels");
        startupThread.start();
        if (this._log.shouldLog(20)) {
            this._log.info(i + " controllers loaded from " + configFile);
        }
        this.changeState(ClientAppState.RUNNING);
    }

    public synchronized void reloadControllers() {
        this.unloadControllers();
        this.loadControllers(this._configFile);
    }

    public synchronized void unloadControllers() {
        this.stopAllControllers();
        this._controllers.clear();
        if (this._log.shouldLog(20)) {
            this._log.info("All controllers stopped and unloaded");
        }
    }

    public synchronized void addController(TunnelController controller) {
        this._controllers.add(controller);
    }

    public synchronized List<String> removeController(TunnelController controller) {
        if (controller == null) {
            return new ArrayList<String>();
        }
        controller.stopTunnel();
        List<String> msgs = controller.clearMessages();
        this._controllers.remove(controller);
        msgs.add("Tunnel " + controller.getName() + " removed");
        return msgs;
    }

    public synchronized List<String> stopAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        for (int i = 0; i < this._controllers.size(); ++i) {
            TunnelController controller = this._controllers.get(i);
            controller.stopTunnel();
            msgs.addAll(controller.clearMessages());
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this._controllers.size() + " controllers stopped");
        }
        return msgs;
    }

    public synchronized List<String> startAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        for (int i = 0; i < this._controllers.size(); ++i) {
            TunnelController controller = this._controllers.get(i);
            controller.startTunnelBackground();
            msgs.addAll(controller.clearMessages());
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this._controllers.size() + " controllers started");
        }
        return msgs;
    }

    public synchronized List<String> restartAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        for (int i = 0; i < this._controllers.size(); ++i) {
            TunnelController controller = this._controllers.get(i);
            controller.restartTunnel();
            msgs.addAll(controller.clearMessages());
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this._controllers.size() + " controllers restarted");
        }
        return msgs;
    }

    public synchronized List<String> clearAllMessages() {
        ArrayList<String> msgs = new ArrayList<String>();
        for (int i = 0; i < this._controllers.size(); ++i) {
            TunnelController controller = this._controllers.get(i);
            msgs.addAll(controller.clearMessages());
        }
        return msgs;
    }

    public void saveConfig() throws IOException {
        this.saveConfig(this._configFile);
    }

    public synchronized void saveConfig(String configFile) throws IOException {
        File parent;
        File cfgFile = new File(configFile);
        if (!cfgFile.isAbsolute()) {
            cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), configFile);
        }
        if ((parent = cfgFile.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
        OrderedProperties map = new OrderedProperties();
        for (int i = 0; i < this._controllers.size(); ++i) {
            TunnelController controller = this._controllers.get(i);
            Properties cur = controller.getConfig("tunnel." + i + ".");
            map.putAll((Map<?, ?>)cur);
        }
        DataHelper.storeProps(map, cfgFile);
    }

    private synchronized Properties loadConfig(String configFile) {
        File cfgFile = new File(configFile);
        if (!cfgFile.isAbsolute()) {
            cfgFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), configFile);
        }
        if (!cfgFile.exists()) {
            if (this._log.shouldLog(40)) {
                this._log.error("Unable to load the controllers from " + cfgFile.getAbsolutePath());
            }
            throw new IllegalArgumentException("Unable to load the controllers from " + cfgFile.getAbsolutePath());
        }
        Properties props = new Properties();
        try {
            DataHelper.loadProps(props, cfgFile);
            return props;
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the controllers from " + cfgFile.getAbsolutePath(), ioe);
            }
            throw new IllegalArgumentException("Error reading the controllers from " + cfgFile.getAbsolutePath(), ioe);
        }
    }

    public synchronized List<TunnelController> getControllers() {
        return new ArrayList<TunnelController>(this._controllers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquire(TunnelController controller, I2PSession session) {
        Map<I2PSession, Set<TunnelController>> map = this._sessions;
        synchronized (map) {
            Set<TunnelController> owners = this._sessions.get(session);
            if (owners == null) {
                owners = new HashSet<TunnelController>(2);
                this._sessions.put(session, owners);
            }
            owners.add(controller);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Acquiring session " + session + " for " + controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(TunnelController controller, I2PSession session) {
        boolean shouldClose = false;
        Map<I2PSession, Set<TunnelController>> map = this._sessions;
        synchronized (map) {
            Set<TunnelController> owners = this._sessions.get(session);
            if (owners != null) {
                owners.remove(controller);
                if (owners.isEmpty()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("After releasing session " + session + " by " + controller + ", no more owners remain");
                    }
                    shouldClose = true;
                    this._sessions.remove(session);
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info("After releasing session " + session + " by " + controller + ", " + owners.size() + " owners remain");
                    }
                    shouldClose = false;
                }
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("After releasing session " + session + " by " + controller + ", no owners were even known?!");
                }
                shouldClose = true;
            }
        }
        if (shouldClose) {
            try {
                session.destroySession();
                if (this._log.shouldLog(20)) {
                    this._log.info("Session destroyed: " + session);
                }
            }
            catch (I2PSessionException ise) {
                this._log.error("Error closing the client session", ise);
            }
        }
    }

    private class StartControllers
    implements Runnable {
        private StartControllers() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TunnelControllerGroup tunnelControllerGroup = TunnelControllerGroup.this;
            synchronized (tunnelControllerGroup) {
                for (int i = 0; i < TunnelControllerGroup.this._controllers.size(); ++i) {
                    TunnelController controller = (TunnelController)TunnelControllerGroup.this._controllers.get(i);
                    if (!controller.getStartOnLoad()) continue;
                    controller.startTunnel();
                }
            }
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        public void run() {
            TunnelControllerGroup.this.shutdown();
        }
    }
}

