/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.data.Base32;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.TunnelControllerGroup;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TunnelController
implements Logging {
    private final Log _log;
    private Properties _config;
    private final I2PTunnel _tunnel = new I2PTunnel();
    private final List<String> _messages;
    private List<I2PSession> _sessions;
    private boolean _running;
    private boolean _starting;
    public static final String KEY_BACKUP_DIR = "i2ptunnel-keyBackup";

    public TunnelController(Properties config, String prefix) {
        this(config, prefix, true);
    }

    public TunnelController(Properties config, String prefix, boolean createKey) {
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(TunnelController.class);
        this.setConfig(config, prefix);
        this._messages = new ArrayList<String>(4);
        this._running = false;
        boolean keyOK = true;
        if (createKey && (this.getType().endsWith("server") || this.getPersistentClientKey())) {
            keyOK = this.createPrivateKey();
        }
        this._starting = keyOK && this.getStartOnLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean createPrivateKey() {
        SecureFileOutputStream fos;
        File keyFile;
        block17: {
            String name;
            File backup;
            I2PClient client = I2PClientFactory.createClient();
            String filename = this.getPrivKeyFile();
            if (filename == null || filename.trim().length() <= 0) {
                this.log("No filename specified for the private key");
                return false;
            }
            keyFile = new File(this.getPrivKeyFile());
            if (!keyFile.isAbsolute()) {
                keyFile = new File(I2PAppContext.getGlobalContext().getConfigDir(), this.getPrivKeyFile());
            }
            if (keyFile.exists()) {
                return true;
            }
            File parent = keyFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            fos = null;
            fos = new SecureFileOutputStream(keyFile);
            Destination dest = client.createDestination(fos);
            String destStr = dest.toBase64();
            this.log("Private key created and saved in " + keyFile.getAbsolutePath());
            this.log("You should backup this file in a secure place.");
            this.log("New destination: " + destStr);
            String b32 = Base32.encode(dest.calculateHash().getData()) + ".b32.i2p";
            this.log("Base32: " + b32);
            SecureFile backupDir = new SecureFile(I2PAppContext.getGlobalContext().getConfigDir(), KEY_BACKUP_DIR);
            if (!backupDir.isDirectory() && !((File)backupDir).mkdir() || !FileUtil.copy(keyFile, backup = new File(backupDir, name = b32 + '-' + I2PAppContext.getGlobalContext().clock().now() + ".dat"), false, true)) break block17;
            this.log("Private key backup saved to " + backup.getAbsolutePath());
        }
        Object var12_15 = null;
        if (fos == null) return true;
        try {
            fos.close();
            return true;
        }
        catch (IOException ioe2) {}
        return true;
        {
            catch (I2PException ie) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Error creating new destination", ie);
                }
                this.log("Error creating new destination: " + ie.getMessage());
                boolean bl = false;
                Object var12_16 = null;
                if (fos == null) return bl;
                try {
                    fos.close();
                    return bl;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return bl;
            }
            catch (IOException ioe) {
                boolean bl;
                try {
                    if (this._log.shouldLog(40)) {
                        this._log.error("Error creating writing the destination to " + keyFile.getAbsolutePath(), ioe);
                    }
                    this.log("Error writing the keys to " + keyFile.getAbsolutePath());
                    bl = false;
                    Object var12_17 = null;
                    if (fos == null) return bl;
                }
                catch (Throwable throwable) {
                    Object var12_18 = null;
                    if (fos == null) throw throwable;
                    try {
                        fos.close();
                        throw throwable;
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    fos.close();
                    return bl;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return bl;
            }
        }
    }

    public void startTunnelBackground() {
        if (this._running) {
            return;
        }
        this._starting = true;
        new I2PAppThread(new Runnable(){

            public void run() {
                TunnelController.this.startTunnel();
            }
        }).start();
    }

    public void startTunnel() {
        this._starting = true;
        try {
            this.doStartTunnel();
        }
        catch (Exception e) {
            this._log.error("Error starting the tunnel " + this.getName(), e);
            this.log("Error starting the tunnel " + this.getName() + ": " + e.getMessage());
            this.acquire();
            this.stopTunnel();
        }
        this._starting = false;
    }

    private void doStartTunnel() {
        boolean ok;
        if (this._running) {
            if (this._log.shouldLog(20)) {
                this._log.info("Already running");
            }
            this.log("Tunnel " + this.getName() + " is already running");
            return;
        }
        String type = this.getType();
        if (type == null || type.length() <= 0) {
            if (this._log.shouldLog(40)) {
                this._log.error("Cannot start the tunnel - no type specified");
            }
            return;
        }
        if ((type.endsWith("server") || this.getPersistentClientKey()) && !(ok = this.createPrivateKey())) {
            this.log("Failed to start tunnel " + this.getName() + " as the private key file could not be created");
            return;
        }
        this.setI2CPOptions();
        this.setSessionOptions();
        if ("httpclient".equals(type)) {
            this.startHttpClient();
        } else if ("ircclient".equals(type)) {
            this.startIrcClient();
        } else if ("sockstunnel".equals(type)) {
            this.startSocksClient();
        } else if ("socksirctunnel".equals(type)) {
            this.startSocksIRCClient();
        } else if ("connectclient".equals(type)) {
            this.startConnectClient();
        } else if ("client".equals(type)) {
            this.startClient();
        } else if ("streamrclient".equals(type)) {
            this.startStreamrClient();
        } else if ("server".equals(type)) {
            this.startServer();
        } else if ("httpserver".equals(type)) {
            this.startHttpServer();
        } else if ("httpbidirserver".equals(type)) {
            this.startHttpBidirServer();
        } else if ("ircserver".equals(type)) {
            this.startIrcServer();
        } else if ("streamrserver".equals(type)) {
            this.startStreamrServer();
        } else {
            if (this._log.shouldLog(40)) {
                this._log.error("Cannot start tunnel - unknown type [" + type + "]");
            }
            return;
        }
        this.acquire();
        this._running = true;
    }

    private void startHttpClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String proxyList = this.getProxyList();
        String sharedClient = this.getSharedClient();
        if (proxyList == null) {
            this._tunnel.runHttpClient(new String[]{listenPort, sharedClient}, this);
        } else {
            this._tunnel.runHttpClient(new String[]{listenPort, sharedClient, proxyList}, this);
        }
    }

    private void startConnectClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String proxyList = this.getProxyList();
        String sharedClient = this.getSharedClient();
        if (proxyList == null) {
            this._tunnel.runConnectClient(new String[]{listenPort, sharedClient}, this);
        } else {
            this._tunnel.runConnectClient(new String[]{listenPort, sharedClient, proxyList}, this);
        }
    }

    private void startIrcClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String dest = this.getTargetDestination();
        String sharedClient = this.getSharedClient();
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runIrcClient(new String[]{listenPort, dest, sharedClient, privKeyFile}, this);
        } else {
            this._tunnel.runIrcClient(new String[]{listenPort, dest, sharedClient}, this);
        }
    }

    private void startSocksClient() {
        Properties props;
        this.setListenOn();
        String listenPort = this.getListenPort();
        String sharedClient = this.getSharedClient();
        String proxyList = this.getProxyList();
        if (proxyList != null && !(props = this._tunnel.getClientOptions()).containsKey("i2ptunnel.socks.proxy.default")) {
            props.setProperty("i2ptunnel.socks.proxy.default", proxyList);
        }
        this._tunnel.runSOCKSTunnel(new String[]{listenPort, sharedClient}, this);
    }

    private void startSocksIRCClient() {
        Properties props;
        this.setListenOn();
        String listenPort = this.getListenPort();
        String sharedClient = this.getSharedClient();
        String proxyList = this.getProxyList();
        if (proxyList != null && !(props = this._tunnel.getClientOptions()).containsKey("i2ptunnel.socks.proxy.default")) {
            props.setProperty("i2ptunnel.socks.proxy.default", proxyList);
        }
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runSOCKSIRCTunnel(new String[]{listenPort, "false", privKeyFile}, this);
        } else {
            this._tunnel.runSOCKSIRCTunnel(new String[]{listenPort, sharedClient}, this);
        }
    }

    private void startStreamrClient() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getListenPort();
        String dest = this.getTargetDestination();
        this._tunnel.runStreamrClient(new String[]{targetHost, targetPort, dest}, this);
    }

    private void startStreamrServer() {
        String listenOn = this.getListenOnInterface();
        if (listenOn != null && listenOn.length() > 0) {
            this._tunnel.runListenOn(new String[]{listenOn}, this);
        }
        String listenPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runStreamrServer(new String[]{listenPort, privKeyFile}, this);
    }

    private void acquire() {
        List<I2PSession> sessions = this._tunnel.getSessions();
        if (!sessions.isEmpty()) {
            for (int i = 0; i < sessions.size(); ++i) {
                TunnelControllerGroup group;
                I2PSession session = sessions.get(i);
                if (this._log.shouldLog(20)) {
                    this._log.info("Acquiring session " + session);
                }
                if ((group = TunnelControllerGroup.getInstance()) == null) continue;
                group.acquire(this, session);
            }
            this._sessions = sessions;
        } else if (this._log.shouldLog(30)) {
            this._log.warn("No sessions to acquire? for " + this.getName());
        }
    }

    private void release() {
        if (this._sessions != null && !this._sessions.isEmpty()) {
            for (int i = 0; i < this._sessions.size(); ++i) {
                TunnelControllerGroup group;
                I2PSession s = this._sessions.get(i);
                if (this._log.shouldLog(20)) {
                    this._log.info("Releasing session " + s);
                }
                if ((group = TunnelControllerGroup.getInstance()) == null) continue;
                group.release(this, s);
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("No sessions to release? for " + this.getName());
        }
    }

    private void startClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String dest = this.getTargetDestination();
        String sharedClient = this.getSharedClient();
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runClient(new String[]{listenPort, dest, sharedClient, privKeyFile}, this);
        } else {
            this._tunnel.runClient(new String[]{listenPort, dest, sharedClient}, this);
        }
    }

    private void startServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runServer(new String[]{targetHost, targetPort, privKeyFile}, this);
    }

    private void startHttpServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String spoofedHost = this.getSpoofedHost();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runHttpServer(new String[]{targetHost, targetPort, spoofedHost, privKeyFile}, this);
    }

    private void startHttpBidirServer() {
        this.setListenOn();
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String listenPort = this.getListenPort();
        String spoofedHost = this.getSpoofedHost();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runHttpBidirServer(new String[]{targetHost, targetPort, listenPort, spoofedHost, privKeyFile}, this);
    }

    private void startIrcServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runIrcServer(new String[]{targetHost, targetPort, privKeyFile}, this);
    }

    private void setListenOn() {
        String listenOn = this.getListenOnInterface();
        if (listenOn != null && listenOn.length() > 0) {
            this._tunnel.runListenOn(new String[]{listenOn}, this);
        }
    }

    public Properties getClientOptionProps() {
        Properties opts = new Properties();
        for (Map.Entry<Object, Object> e : this._config.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith("option.")) continue;
            key = key.substring("option.".length());
            String val = (String)e.getValue();
            opts.setProperty(key, val);
        }
        return opts;
    }

    private void setSessionOptions() {
        this._tunnel.setClientOptions(this.getClientOptionProps());
    }

    private void setI2CPOptions() {
        String port;
        String host = this.getI2CPHost();
        if (host != null && host.length() > 0) {
            this._tunnel.host = host;
        }
        if ("localhost".equals(this._tunnel.host)) {
            this._tunnel.host = "127.0.0.1";
        }
        if ((port = this.getI2CPPort()) != null && port.length() > 0) {
            try {
                int portNum = Integer.parseInt(port);
                this._tunnel.port = String.valueOf(portNum);
            }
            catch (NumberFormatException nfe) {
                this._tunnel.port = "7654";
            }
        } else {
            this._tunnel.port = "7654";
        }
    }

    public void stopTunnel() {
        this._tunnel.runClose(new String[]{"forced", "all"}, this);
        this.release();
        this._running = false;
    }

    public void restartTunnel() {
        this.stopTunnel();
        this.startTunnel();
    }

    public void setConfig(Properties config, String prefix) {
        Properties props = new Properties();
        for (Map.Entry<Object, Object> e : config.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith(prefix)) continue;
            key = key.substring(prefix.length());
            String val = (String)e.getValue();
            props.setProperty(key, val);
        }
        this._config = props;
        String type = this.getType();
        if (type != null) {
            if (type.equals("httpserver") || type.equals("streamrserver")) {
                if (!this._config.containsKey("option.shouldBundleReplyInfo")) {
                    this._config.setProperty("option.shouldBundleReplyInfo", "false");
                }
            } else if (type.contains("irc") || type.equals("streamrclient")) {
                if (!this._config.containsKey("option.crypto.tagsToSend")) {
                    this._config.setProperty("option.crypto.tagsToSend", "20");
                }
                if (!this._config.containsKey("option.crypto.lowTagThreshold")) {
                    this._config.setProperty("option.crypto.lowTagThreshold", "14");
                }
            }
        }
        this.setSessionOptions();
        if (this._running && this._sessions != null) {
            for (I2PSession s : this._sessions) {
                if (s.isClosed()) continue;
                s.updateOptions(this._tunnel.getClientOptions());
            }
        }
    }

    public Properties getConfig(String prefix) {
        Properties rv = new Properties();
        for (Map.Entry<Object, Object> e : this._config.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            rv.setProperty(prefix + key, val);
        }
        return rv;
    }

    public String getType() {
        return this._config.getProperty("type");
    }

    public String getName() {
        return this._config.getProperty("name");
    }

    public String getDescription() {
        return this._config.getProperty("description");
    }

    public String getI2CPHost() {
        return this._config.getProperty("i2cpHost");
    }

    public String getI2CPPort() {
        return this._config.getProperty("i2cpPort");
    }

    public String getClientOptions() {
        StringBuilder opts = new StringBuilder(64);
        for (Map.Entry<Object, Object> e : this._config.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith("option.")) continue;
            key = key.substring("option.".length());
            String val = (String)e.getValue();
            if (opts.length() > 0) {
                opts.append(' ');
            }
            opts.append(key).append('=').append(val);
        }
        return opts.toString();
    }

    public String getListenOnInterface() {
        return this._config.getProperty("interface");
    }

    public String getTargetHost() {
        return this._config.getProperty("targetHost");
    }

    public String getTargetPort() {
        return this._config.getProperty("targetPort");
    }

    public String getSpoofedHost() {
        return this._config.getProperty("spoofedHost");
    }

    public String getPrivKeyFile() {
        return this._config.getProperty("privKeyFile");
    }

    public String getListenPort() {
        return this._config.getProperty("listenPort");
    }

    public String getTargetDestination() {
        return this._config.getProperty("targetDestination");
    }

    public String getProxyList() {
        return this._config.getProperty("proxyList");
    }

    public String getSharedClient() {
        return this._config.getProperty("sharedClient", "true");
    }

    public boolean getStartOnLoad() {
        return Boolean.parseBoolean(this._config.getProperty("startOnLoad", "true"));
    }

    public boolean getPersistentClientKey() {
        return Boolean.parseBoolean(this._config.getProperty("option.persistentClientKey"));
    }

    public String getMyDestination() {
        if (this._tunnel != null) {
            List<I2PSession> sessions = this._tunnel.getSessions();
            for (int i = 0; i < sessions.size(); ++i) {
                I2PSession session = sessions.get(i);
                Destination dest = session.getMyDestination();
                if (dest == null) continue;
                return dest.toBase64();
            }
        }
        return null;
    }

    public String getMyDestHashBase32() {
        if (this._tunnel != null) {
            List<I2PSession> sessions = this._tunnel.getSessions();
            for (int i = 0; i < sessions.size(); ++i) {
                I2PSession session = sessions.get(i);
                Destination dest = session.getMyDestination();
                if (dest == null) continue;
                return Base32.encode(dest.calculateHash().getData());
            }
        }
        return null;
    }

    public boolean getIsRunning() {
        return this._running;
    }

    public boolean getIsStarting() {
        return this._starting;
    }

    public boolean getIsStandby() {
        if (!this._running) {
            return false;
        }
        for (I2PSession sess : this._tunnel.getSessions()) {
            if (sess.isClosed()) continue;
            return false;
        }
        return true;
    }

    public void getSummary(StringBuilder buf) {
        String type = this.getType();
        buf.append(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String s) {
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            this._messages.add(s);
            while (this._messages.size() > 10) {
                this._messages.remove(0);
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> clearMessages() {
        ArrayList<String> rv = null;
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            rv = new ArrayList<String>(this._messages);
            this._messages.clear();
        }
        return rv;
    }
}

