/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EventDispatcher;

public class I2PTunnelClient
extends I2PTunnelClientBase {
    protected List<Destination> dests;
    private static final long DEFAULT_READ_TIMEOUT = 300000L;
    protected long readTimeout = 300000L;

    public I2PTunnelClient(int localPort, String destinations, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel, String pkf) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "Standard client on " + tunnel.listenHost + ':' + localPort, tunnel, pkf);
        if (this.waitEventValue("openBaseClientResult").equals("error")) {
            this.notifyEvent("openClientResult", "error");
            return;
        }
        StringTokenizer tok = new StringTokenizer(destinations, ", ");
        this.dests = new ArrayList<Destination>(1);
        while (tok.hasMoreTokens()) {
            String destination = tok.nextToken();
            Destination destN = this._context.namingService().lookup(destination);
            if (destN == null) {
                l.log("Could not resolve " + destination);
                continue;
            }
            this.dests.add(destN);
        }
        if (this.dests.isEmpty()) {
            l.log("No valid target destinations found");
            this.notifyEvent("openClientResult", "error");
            throw new IllegalArgumentException("No valid target destinations found");
        }
        this.setName(this.getLocalPort() + " -> " + destinations);
        this.startRunning();
        this.notifyEvent("openClientResult", "ok");
    }

    public void setReadTimeout(long ms) {
        this.readTimeout = ms;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clientConnectionRun(Socket s) {
        block6: {
            Destination destN = this.pickDestination();
            I2PSocket i2ps = null;
            try {
                i2ps = this.createI2PSocket(destN);
                i2ps.setReadTimeout(this.readTimeout);
                new I2PTunnelRunner(s, i2ps, this.sockLock, null, this.mySockets);
            }
            catch (Exception ex) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Error connecting", ex);
                }
                I2PTunnelClient.closeSocket(s);
                if (i2ps == null) break block6;
                Object object = this.sockLock;
                synchronized (object) {
                    this.mySockets.remove(this.sockLock);
                }
            }
        }
    }

    private final Destination pickDestination() {
        int size = this.dests.size();
        if (size <= 0) {
            if (this._log.shouldLog(40)) {
                this._log.error("No client targets?!");
            }
            return null;
        }
        if (size == 1) {
            return this.dests.get(0);
        }
        int index = this._context.random().nextInt(size);
        return this.dests.get(index);
    }
}

