/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemovableSingletonSet<E>
extends AbstractSet<E> {
    private E _elem;

    public RemovableSingletonSet(E element) {
        if (element == null) {
            throw new NullPointerException();
        }
        this._elem = element;
    }

    @Override
    public void clear() {
        this._elem = null;
    }

    @Override
    public boolean contains(Object o) {
        return o != null && o.equals(this._elem);
    }

    @Override
    public boolean isEmpty() {
        return this._elem == null;
    }

    @Override
    public boolean remove(Object o) {
        boolean rv = o.equals(this._elem);
        if (rv) {
            this._elem = null;
        }
        return rv;
    }

    @Override
    public int size() {
        return this._elem != null ? 1 : 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new RSSIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RSSIterator
    implements Iterator<E> {
        boolean done;

        private RSSIterator() {
        }

        @Override
        public boolean hasNext() {
            return RemovableSingletonSet.this._elem != null && !this.done;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.done = true;
            return RemovableSingletonSet.this._elem;
        }

        @Override
        public void remove() {
            if (RemovableSingletonSet.this._elem == null || !this.done) {
                throw new IllegalStateException();
            }
            RemovableSingletonSet.this._elem = null;
        }
    }
}

