/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.util.CDPQEntry;
import net.i2p.router.util.PriBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoDelPriorityBlockingQueue<E extends CDPQEntry>
extends PriBlockingQueue<E> {
    private long _first_above_time;
    private long _drop_next;
    private int _count;
    private boolean _dropping;
    private long _now;
    private int _lastDroppedPriority;
    static final AtomicLong __id = new AtomicLong();
    private final long _id;
    private static final long TARGET = 15L;
    private static final long INTERVAL = 300L;
    private final String STAT_DROP;
    private final String STAT_DELAY;
    public static final int MIN_PRIORITY = 100;
    private static final int[] PRIORITIES = new int[]{100, 200, 300, 400, 500};
    public static final int DONT_DROP_PRIORITY = 1000;
    private static final long BACKLOG_TIME = 2000L;

    public CoDelPriorityBlockingQueue(I2PAppContext ctx, String name, int initialCapacity) {
        super(ctx, name, initialCapacity);
        this.STAT_DROP = ("codel." + name + ".drop.").intern();
        this.STAT_DELAY = ("codel." + name + ".delay").intern();
        for (int i = 0; i < PRIORITIES.length; ++i) {
            ctx.statManager().createRateStat(this.STAT_DROP + PRIORITIES[i], "queue delay of dropped items by priority", "Router", RATES);
        }
        ctx.statManager().createRateStat(this.STAT_DELAY, "average queue delay", "Router", RATES);
        this._id = __id.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        CoDelPriorityBlockingQueue coDelPriorityBlockingQueue = this;
        synchronized (coDelPriorityBlockingQueue) {
            this._first_above_time = 0L;
            this._drop_next = 0L;
            this._count = 0;
            this._dropping = false;
        }
    }

    @Override
    public E take() throws InterruptedException {
        E rv;
        while ((rv = this.deque()) == null) {
        }
        return rv;
    }

    @Override
    public E poll() {
        CDPQEntry rv = (CDPQEntry)super.poll();
        return (E)this.codel(rv);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        Object e;
        int rv = 0;
        while ((e = this.poll()) != null) {
            c.add(e);
            ++rv;
        }
        return rv;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        Object e;
        int rv = 0;
        while ((e = this.poll()) != null && rv++ < maxElements) {
            c.add(e);
        }
        return rv;
    }

    public int drainAllTo(Collection<? super E> c) {
        return super.drainTo(c);
    }

    @Override
    public boolean isBacklogged() {
        CDPQEntry e = (CDPQEntry)this.peek();
        if (e == null) {
            return false;
        }
        return this._dropping || this._context.clock().now() - e.getEnqueueTime() >= 2000L || this.size() >= 256;
    }

    @Override
    protected void timestamp(E o) {
        super.timestamp(o);
        o.setEnqueueTime(this._context.clock().now());
        if (o.getPriority() < 100 && this._log.shouldLog(30)) {
            this._log.warn(this._name + " added item with low priority " + o.getPriority() + ": " + o);
        }
    }

    private boolean updateVars(E entry) {
        if (entry == null) {
            this._first_above_time = 0L;
            return false;
        }
        this._now = this._context.clock().now();
        boolean ok_to_drop = false;
        long sojurn = this._now - entry.getEnqueueTime();
        this._context.statManager().addRateData(this.STAT_DELAY, sojurn);
        if (sojurn < 15L || this.isEmpty()) {
            this._first_above_time = 0L;
        } else if (this._first_above_time == 0L) {
            this._first_above_time = this._now + 300L;
        } else if (this._now >= this._first_above_time) {
            ok_to_drop = true;
        }
        return ok_to_drop;
    }

    private E deque() throws InterruptedException {
        CDPQEntry rv = (CDPQEntry)super.take();
        return (E)this.codel(rv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E codel(E rv) {
        CoDelPriorityBlockingQueue coDelPriorityBlockingQueue = this;
        synchronized (coDelPriorityBlockingQueue) {
            boolean ok_to_drop = this.updateVars(rv);
            if (this._dropping) {
                if (!ok_to_drop) {
                    this._dropping = false;
                } else if (this._now >= this._drop_next) {
                    while (this._now >= this._drop_next && this._dropping && rv.getPriority() <= this._lastDroppedPriority) {
                        this.drop(rv);
                        ++this._count;
                        rv = (CDPQEntry)super.poll();
                        ok_to_drop = this.updateVars(rv);
                        if (!ok_to_drop) {
                            this._dropping = false;
                            continue;
                        }
                        this.control_law(this._drop_next);
                    }
                }
            } else if (ok_to_drop && rv.getPriority() < 1000 && (this._now - this._drop_next < 300L || this._now - this._first_above_time >= 300L)) {
                this.drop(rv);
                this._lastDroppedPriority = rv.getPriority();
                rv = (CDPQEntry)super.poll();
                this.updateVars(rv);
                this._dropping = true;
                this._count = this._now - this._drop_next < 300L ? (this._count > 2 ? this._count - 2 : 1) : 1;
                this.control_law(this._now);
            }
        }
        return rv;
    }

    private void drop(E entry) {
        long delay = this._context.clock().now() - entry.getEnqueueTime();
        int priority = entry.getPriority() / 100 * 100;
        this._context.statManager().addRateData(this.STAT_DROP + priority, delay);
        if (this._log.shouldLog(30)) {
            this._log.warn("CDPQ #" + this._id + ' ' + this._name + " dropped item with delay " + delay + ", priority " + entry.getPriority() + ", seq " + entry.getSeqNum() + ", " + DataHelper.formatDuration((long)(this._context.clock().now() - this._first_above_time)) + " since first above, " + DataHelper.formatDuration((long)(this._context.clock().now() - this._drop_next)) + " since drop next, " + (this._count + 1) + " dropped in this phase, " + this.size() + " remaining in queue: " + entry);
        }
        entry.drop();
    }

    private void control_law(long t) {
        this._drop_next = t + (long)(300.0 / Math.sqrt(this._count));
    }
}

