/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExploratoryPeerSelector
extends TunnelPeerSelector {
    private static final int MIN_NONFAILING_PCT = 15;
    private static final int MIN_ACTIVE_PEERS_STARTUP = 6;
    private static final int MIN_ACTIVE_PEERS = 12;

    public ExploratoryPeerSelector(RouterContext context) {
        super(context);
    }

    @Override
    public List<Hash> selectPeers(TunnelPoolSettings settings) {
        Log l = this.ctx.logManager().getLog(this.getClass());
        int length = this.getLength(settings);
        if (length < 0) {
            if (l.shouldLog(10)) {
                l.debug("Length requested is zero: " + settings);
            }
            return null;
        }
        Set<Hash> exclude = this.getExclude(settings.isInbound(), true);
        exclude.add(this.ctx.routerHash());
        HashSet<Hash> matches = new HashSet<Hash>(length);
        boolean exploreHighCap = this.shouldPickHighCap();
        if (settings.isInbound() && this.ctx.router().isHidden()) {
            this.ctx.profileOrganizer().selectFastPeers(length, exclude, matches);
        } else if (exploreHighCap) {
            this.ctx.profileOrganizer().selectHighCapacityPeers(length, exclude, matches);
        } else if (this.ctx.commSystem().haveHighOutboundCapacity()) {
            this.ctx.profileOrganizer().selectNotFailingPeers(length, exclude, matches, false);
        } else {
            this.ctx.profileOrganizer().selectActiveNotFailingPeers(length, exclude, matches);
        }
        if (l.shouldLog(10)) {
            l.debug("profileOrganizer.selectNotFailing(" + length + ") found " + matches);
        }
        matches.remove(this.ctx.routerHash());
        ArrayList<Hash> rv = new ArrayList<Hash>(matches);
        if (rv.size() > 1) {
            this.orderPeers(rv, settings.getRandomKey());
        }
        if (settings.isInbound()) {
            rv.add(0, this.ctx.routerHash());
        } else {
            rv.add(this.ctx.routerHash());
        }
        return rv;
    }

    private boolean shouldPickHighCap() {
        int failPct;
        if (this.ctx.getBooleanProperty("router.exploreHighCapacity")) {
            return true;
        }
        int active = this.ctx.commSystem().countActivePeers();
        if (active < 6) {
            return false;
        }
        if (this.ctx.router().getUptime() <= 300000L) {
            return true;
        }
        if (this.ctx.router().gracefulShutdownInProgress()) {
            return true;
        }
        if (active < 12) {
            return false;
        }
        if (this.ctx.router().getUptime() <= 660000L) {
            failPct = 85;
        } else {
            failPct = this.getExploratoryFailPercentage();
            if (failPct > 85) {
                failPct = 85;
            }
        }
        return failPct >= this.ctx.random().nextInt(100);
    }

    private int getExploratoryFailPercentage() {
        int c = this.getFailPercentage("Client");
        int e = this.getFailPercentage("Exploratory");
        if (e <= c || e <= 25) {
            return 0;
        }
        if (c >= 70 || e >= 75) {
            return 85;
        }
        return 100 * (e - c) / (100 - c);
    }

    private int getFailPercentage(String t) {
        String pfx = "tunnel.build" + t;
        int timeout = this.getEvents(pfx + "Expire", 600000L);
        int reject = this.getEvents(pfx + "Reject", 600000L);
        int accept = this.getEvents(pfx + "Success", 600000L);
        if (accept + reject + timeout <= 0) {
            return 0;
        }
        double pct = (double)(reject + timeout) / (double)(accept + reject + timeout);
        return (int)(100.0 * pct);
    }

    private int getEvents(String stat, long period) {
        RateStat rs = this.ctx.statManager().getRate(stat);
        if (rs == null) {
            return 0;
        }
        Rate r = rs.getRate(period);
        if (r == null) {
            return 0;
        }
        return (int)r.computeAverages().getTotalEventCount();
    }
}

