/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

class OutboundGatewayProcessor {
    private final I2PAppContext _context;
    private final Log _log;
    private final TunnelCreatorConfig _config;
    static final boolean USE_ENCRYPTION = true;

    public OutboundGatewayProcessor(I2PAppContext ctx, TunnelCreatorConfig cfg) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundGatewayProcessor.class);
        this._config = cfg;
    }

    public void process(byte[] orig, int offset, int length) {
        byte[] iv = SimpleByteCache.acquire((int)16);
        System.arraycopy(orig, offset, iv, 0, 16);
        if (this._log.shouldLog(10)) {
            this._log.debug("Orig random IV: " + Base64.encode((byte[])iv));
        }
        this.decrypt(this._context, this._config, iv, orig, offset, length);
        if (this._log.shouldLog(10)) {
            this._log.debug("finished processing the preprocessed data");
        }
        SimpleByteCache.release((byte[])iv);
    }

    private void decrypt(I2PAppContext ctx, TunnelCreatorConfig cfg, byte[] iv, byte[] orig, int offset, int length) {
        Log log = ctx.logManager().getLog(OutboundGatewayProcessor.class);
        byte[] cur = SimpleByteCache.acquire((int)16);
        for (int i = cfg.getLength() - 1; i >= 1; --i) {
            OutboundGatewayProcessor.decrypt(ctx, iv, orig, offset, length, cur, cfg.getConfig(i));
            if (!log.shouldLog(10)) continue;
            log.debug("IV at hop " + i + ": " + Base64.encode((byte[])orig, (int)offset, (int)16));
        }
        SimpleByteCache.release((byte[])cur);
    }

    static void decrypt(I2PAppContext ctx, byte[] iv, byte[] orig, int offset, int length, byte[] cur, HopConfig config) {
        ctx.aes().decryptBlock(orig, offset, config.getIVKey(), orig, offset);
        int numBlocks = (length - 16) / 16;
        byte[] prev = iv;
        System.arraycopy(orig, offset, prev, 0, 16);
        for (int i = 0; i < numBlocks; ++i) {
            int off = (i + 1) * 16 + offset;
            System.arraycopy(orig, off, cur, 0, 16);
            ctx.aes().decryptBlock(orig, off, config.getLayerKey(), orig, off);
            for (int j = 0; j < 16; ++j) {
                int n = off + j;
                orig[n] = (byte)(orig[n] ^ prev[j]);
            }
            byte[] xf = prev;
            prev = cur;
            cur = xf;
        }
        ctx.aes().decryptBlock(orig, offset, config.getIVKey(), orig, offset);
    }
}

