/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.udp.DummyThrottle;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundMessageFragments;
import net.i2p.router.transport.udp.IntroductionManager;
import net.i2p.router.transport.udp.MTU;
import net.i2p.router.transport.udp.MessageQueue;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.OutboundRefiller;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PacketHandler;
import net.i2p.router.transport.udp.PacketPusher;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerTestManager;
import net.i2p.router.transport.udp.PeerTestState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.TimedWeightedPriorityMessageQueue;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPEndpoint;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.util.RandomIterator;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.Translate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPTransport
extends TransportImpl
implements TimedWeightedPriorityMessageQueue.FailedListener {
    private final Log _log;
    private final List<UDPEndpoint> _endpoints;
    private final Object _addDropLock = new Object();
    private final Map<Hash, PeerState> _peersByIdent;
    private final Map<RemoteHostId, PeerState> _peersByRemoteHost;
    private PacketHandler _handler;
    private EstablishmentManager _establisher;
    private final MessageQueue _outboundMessages;
    private final OutboundMessageFragments _fragments;
    private final OutboundMessageFragments.ActiveThrottle _activeThrottle;
    private OutboundRefiller _refiller;
    private PacketPusher _pusher;
    private final InboundMessageFragments _inboundFragments;
    private PeerTestManager _testManager;
    private final IntroductionManager _introManager;
    private final ExpirePeerEvent _expireEvent;
    private final PeerTestEvent _testEvent;
    private final PacketBuilder _destroyBuilder;
    private short _reachabilityStatus;
    private long _reachabilityStatusLastUpdated;
    private long _introducersSelectedOn;
    private long _lastInboundReceivedOn;
    private final DHSessionKeyBuilder.Factory _dhFactory;
    private int _mtu;
    private int _mtu_ipv6;
    private boolean _haveIPv6Address;
    private boolean _needsRebuild;
    private SessionKey _introKey;
    private final Set<RemoteHostId> _dropList;
    private int _expireTimeout;
    private Hash _lastFrom;
    private byte[] _lastOurIP;
    private int _lastOurPort;
    private static final int DROPLIST_PERIOD = 600000;
    public static final String STYLE = "SSU";
    public static final String PROP_INTERNAL_PORT = "i2np.udp.internalPort";
    public static final int DEFAULT_INTERNAL_PORT = 8887;
    static final int MIN_PEER_PORT = 1024;
    private static final int MIN_EXTERNAL_PORT = 1024;
    private static final int MAX_EXTERNAL_PORT = 65535;
    public static final String PROP_EXTERNAL_HOST = "i2np.udp.host";
    public static final String PROP_EXTERNAL_PORT = "i2np.udp.port";
    public static final String PROP_PREFER_UDP = "i2np.udp.preferred";
    private static final String DEFAULT_PREFER_UDP = "false";
    private static final String PROP_FIXED_PORT = "i2np.udp.fixedPort";
    public static final String PROP_SOURCES = "i2np.udp.addressSources";
    public static final String DEFAULT_SOURCES = Transport.AddressSource.SOURCE_INTERFACE.toConfigString() + ',' + Transport.AddressSource.SOURCE_UPNP.toConfigString() + ',' + Transport.AddressSource.SOURCE_SSU.toConfigString();
    public static final String PROP_IP = "i2np.lastIP";
    public static final String PROP_IP_CHANGE = "i2np.lastIPChange";
    public static final String PROP_LAPTOP_MODE = "i2np.laptopMode";
    public static final String PROP_FORCE_INTRODUCERS = "i2np.udp.forceIntroducers";
    public static final String PROP_ALLOW_DIRECT = "i2np.udp.allowDirect";
    public static final String PROP_BIND_INTERFACE = "i2np.udp.bindInterface";
    private static final String PROP_DEFAULT_MTU = "i2np.udp.mtu";
    public static final int PUBLIC_RELAY_COUNT = 3;
    private static final boolean USE_PRIORITY = false;
    private static final int[] PRIORITY_LIMITS = new int[]{100, 200, 300, 400, 500, 1000};
    private static final int[] PRIORITY_WEIGHT = new int[]{1, 1, 1, 1, 1, 2};
    private static final int MAX_CONSECUTIVE_FAILED = 5;
    public static final int DEFAULT_COST = 5;
    private static final int TEST_FREQUENCY = 780000;
    static final long[] RATES = new long[]{600000L};
    private static final int[] BID_VALUES = new int[]{15, 20, 50, 65, 80, 95, 100, 115, 999999};
    private static final int FAST_PREFERRED_BID = 0;
    private static final int SLOW_PREFERRED_BID = 1;
    private static final int FAST_BID = 2;
    private static final int SLOW_BID = 3;
    private static final int SLOWEST_BID = 4;
    private static final int SLOWEST_COST_BID = 5;
    private static final int NEAR_CAPACITY_BID = 6;
    private static final int NEAR_CAPACITY_COST_BID = 7;
    private static final int TRANSIENT_FAIL_BID = 8;
    private final TransportBid[] _cachedBid;
    private static final String THINSP = " / ";
    private static final int ALLOW_IP_CHANGE_INTERVAL = 120000;
    private boolean gotIPv4Addr = false;
    private boolean gotIPv6Addr = false;
    private static final int MIN_PEERS = 3;
    private static final int MIN_INTRODUCER_POOL = 5;
    public static final int EXPIRE_TIMEOUT = 1200000;
    private static final int MAX_IDLE_TIME = 1200000;
    public static final int MIN_EXPIRE_TIMEOUT = 270000;
    private static final int FLAG_ALPHA = 0;
    private static final int FLAG_IDLE_IN = 1;
    private static final int FLAG_IDLE_OUT = 2;
    private static final int FLAG_RATE_IN = 3;
    private static final int FLAG_RATE_OUT = 4;
    private static final int FLAG_SKEW = 5;
    private static final int FLAG_CWND = 6;
    private static final int FLAG_SSTHRESH = 7;
    private static final int FLAG_RTT = 8;
    private static final int FLAG_RTO = 10;
    private static final int FLAG_MTU = 11;
    private static final int FLAG_SEND = 12;
    private static final int FLAG_RECV = 13;
    private static final int FLAG_RESEND = 14;
    private static final int FLAG_DUP = 15;
    private static final int FLAG_UPTIME = 16;
    private static final int FLAG_DEBUG = 99;
    private static final DecimalFormat _fmt = new DecimalFormat("#,##0.00");
    private static final DecimalFormat _pctFmt = new DecimalFormat("#0.0%");
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";
    private static final String PROP_REACHABILITY_STATUS_OVERRIDE = "i2np.udp.status";

    public UDPTransport(RouterContext ctx, DHSessionKeyBuilder.Factory dh) {
        super(ctx);
        this._dhFactory = dh;
        this._log = ctx.logManager().getLog(UDPTransport.class);
        this._peersByIdent = new ConcurrentHashMap<Hash, PeerState>(128);
        this._peersByRemoteHost = new ConcurrentHashMap<RemoteHostId, PeerState>(128);
        this._dropList = new ConcurrentHashSet(2);
        this._endpoints = new CopyOnWriteArrayList<UDPEndpoint>();
        DummyThrottle mq = new DummyThrottle();
        this._outboundMessages = null;
        this._activeThrottle = mq;
        this._cachedBid = new SharedBid[BID_VALUES.length];
        for (int i = 0; i < BID_VALUES.length; ++i) {
            this._cachedBid[i] = new SharedBid(BID_VALUES[i]);
        }
        this._destroyBuilder = new PacketBuilder(this._context, this);
        this._fragments = new OutboundMessageFragments(this._context, this, this._activeThrottle);
        this._inboundFragments = new InboundMessageFragments(this._context, this._fragments, this);
        this._expireTimeout = 1200000;
        this._expireEvent = new ExpirePeerEvent();
        this._testEvent = new PeerTestEvent();
        this._reachabilityStatus = (short)5;
        this._introManager = new IntroductionManager(this._context, this);
        this._introducersSelectedOn = -1L;
        this._lastInboundReceivedOn = -1L;
        this._mtu = 1484;
        this._mtu_ipv6 = 1280;
        this.setupPort();
        this._needsRebuild = true;
        this._context.statManager().createRateStat("udp.alreadyConnected", "What is the lifetime of a reestablished session", "udp", RATES);
        this._context.statManager().createRateStat("udp.droppedPeer", "How long ago did we receive from a dropped peer (duration == session lifetime", "udp", RATES);
        this._context.statManager().createRateStat("udp.droppedPeerInactive", "How long ago did we receive from a dropped peer (duration == session lifetime)", "udp", RATES);
        this._context.statManager().createRateStat("udp.statusOK", "How many times the peer test returned OK", "udp", RATES);
        this._context.statManager().createRateStat("udp.statusDifferent", "How many times the peer test returned different IP/ports", "udp", RATES);
        this._context.statManager().createRateStat("udp.statusReject", "How many times the peer test returned reject unsolicited", "udp", RATES);
        this._context.statManager().createRateStat("udp.statusUnknown", "How many times the peer test returned an unknown result", "udp", RATES);
        this._context.statManager().createRateStat("udp.addressTestInsteadOfUpdate", "How many times we fire off a peer test of ourselves instead of adjusting our own reachable address?", "udp", RATES);
        this._context.statManager().createRateStat("udp.addressUpdated", "How many times we adjust our own reachable IP address", "udp", RATES);
        this._context.statManager().createRateStat("udp.proactiveReestablish", "How long a session was idle for when we proactively reestablished it", "udp", RATES);
        this._context.statManager().createRateStat("udp.dropPeerDroplist", "How many peers currently have their packets dropped outright when a new peer is added to the list?", "udp", RATES);
        this._context.statManager().createRateStat("udp.dropPeerConsecutiveFailures", "How many consecutive failed sends to a peer did we attempt before giving up and reestablishing a new session (lifetime is inactivity perood)", "udp", RATES);
        this._context.statManager().createRateStat("udp.packetAuthTime", "How long it takes to encrypt and MAC a packet for sending", "udp", RATES);
        this._context.statManager().createRateStat("udp.packetAuthTimeSlow", "How long it takes to encrypt and MAC a packet for sending (when its slow)", "udp", RATES);
        this._context.simpleScheduler().addPeriodicEvent((SimpleTimer.TimedEvent)new PingIntroducers(), 202500L);
    }

    private void setupPort() {
        int port = this.getRequestedPort();
        if (port < 0) {
            port = UDPEndpoint.selectRandomPort(this._context);
            HashMap<String, String> changes = new HashMap<String, String>();
            changes.put(PROP_INTERNAL_PORT, Integer.toString(port));
            changes.put(PROP_EXTERNAL_PORT, Integer.toString(port));
            this._context.router().saveConfig(changes, null);
            this._log.logAlways(20, "UDP selected random port " + port);
        }
    }

    private synchronized void startup() {
        String fixedHost;
        this._fragments.shutdown();
        if (this._pusher != null) {
            this._pusher.shutdown();
        }
        if (this._handler != null) {
            this._handler.shutdown();
        }
        for (UDPEndpoint endpoint : this._endpoints) {
            endpoint.shutdown();
            this._endpoints.remove(endpoint);
        }
        if (this._establisher != null) {
            this._establisher.shutdown();
        }
        if (this._refiller != null) {
            this._refiller.shutdown();
        }
        this._inboundFragments.shutdown();
        this._introManager.reset();
        UDPPacket.clearCache();
        if (this._log.shouldLog(30)) {
            this._log.warn("Starting SSU transport listening");
        }
        this._introKey = new SessionKey(new byte[32]);
        System.arraycopy(this._context.routerHash().getData(), 0, this._introKey.getData(), 0, 32);
        String bindTo = this._context.getProperty(PROP_BIND_INTERFACE);
        if (bindTo == null && (fixedHost = this._context.getProperty(PROP_EXTERNAL_HOST)) != null && fixedHost.length() > 0) {
            try {
                String testAddr = InetAddress.getByName(fixedHost).getHostAddress();
                if (Addresses.getAddresses().contains(testAddr)) {
                    bindTo = testAddr;
                }
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
        }
        InetAddress bindToAddr = null;
        if (bindTo != null) {
            try {
                bindToAddr = InetAddress.getByName(bindTo);
            }
            catch (UnknownHostException uhe) {
                this._log.error("Invalid SSU bind interface specified [" + bindTo + "]", (Throwable)uhe);
            }
        }
        int oldIPort = this._context.getProperty(PROP_INTERNAL_PORT, -1);
        int oldBindPort = this.getListenPort(false);
        int oldEPort = this._context.getProperty(PROP_EXTERNAL_PORT, -1);
        int port = oldIPort > 0 ? oldIPort : (oldBindPort > 0 ? oldBindPort : oldEPort);
        if (bindToAddr != null && this._log.shouldLog(30)) {
            this._log.warn("Binding only to " + bindToAddr);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Binding to the port: " + port);
        }
        if (this._endpoints.isEmpty()) {
            UDPEndpoint endpoint = new UDPEndpoint(this._context, this, port, bindToAddr);
            this._endpoints.add(endpoint);
        } else {
            for (UDPEndpoint endpoint : this._endpoints) {
                if (!endpoint.isIPv4()) continue;
                endpoint.setListenPort(port);
                break;
            }
        }
        this.setMTU(bindToAddr);
        if (this._establisher == null) {
            this._establisher = new EstablishmentManager(this._context, this);
        }
        if (this._testManager == null) {
            this._testManager = new PeerTestManager(this._context, this);
        }
        if (this._handler == null) {
            this._handler = new PacketHandler(this._context, this, this._establisher, this._inboundFragments, this._testManager, this._introManager);
        }
        int newPort = -1;
        for (UDPEndpoint endpoint : this._endpoints) {
            try {
                endpoint.startup();
                if (newPort >= 0 || !endpoint.isIPv4()) continue;
                newPort = endpoint.getListenPort();
            }
            catch (SocketException se) {
                this._endpoints.remove(endpoint);
            }
        }
        if (this._endpoints.isEmpty()) {
            this._log.log(50, "Unable to open UDP port");
            this.setReachabilityStatus((short)4);
            return;
        }
        if (newPort > 0 && (newPort != port || newPort != oldIPort || newPort != oldEPort)) {
            HashMap<String, String> changes = new HashMap<String, String>();
            changes.put(PROP_INTERNAL_PORT, Integer.toString(newPort));
            changes.put(PROP_EXTERNAL_PORT, Integer.toString(newPort));
            this._context.router().saveConfig(changes, null);
        }
        this._establisher.startup();
        this._handler.startup();
        this._fragments.startup();
        this._inboundFragments.startup();
        this._pusher = new PacketPusher(this._context, this._fragments, this._endpoints);
        this._pusher.startup();
        this._expireEvent.setIsAlive(true);
        this._testEvent.setIsAlive(true);
        this._testEvent.reschedule(10000L);
        if (newPort > 0 && bindToAddr == null) {
            for (InetAddress ia : this.getSavedLocalAddresses()) {
                this.rebuildExternalAddress(ia.getHostAddress(), newPort, false);
            }
        }
        this.rebuildExternalAddress(false);
    }

    public synchronized void shutdown() {
        this.destroyAll();
        for (UDPEndpoint endpoint : this._endpoints) {
            endpoint.shutdown();
            this._endpoints.remove(endpoint);
        }
        if (this._refiller != null) {
            this._refiller.shutdown();
        }
        if (this._handler != null) {
            this._handler.shutdown();
        }
        if (this._pusher != null) {
            this._pusher.shutdown();
        }
        this._fragments.shutdown();
        if (this._establisher != null) {
            this._establisher.shutdown();
        }
        this._inboundFragments.shutdown();
        this._expireEvent.setIsAlive(false);
        this._testEvent.setIsAlive(false);
        this._peersByRemoteHost.clear();
        this._peersByIdent.clear();
        this._dropList.clear();
        this._introManager.reset();
        UDPPacket.clearCache();
        UDPAddress.clearCache();
    }

    private boolean isAlive() {
        return this._inboundFragments.isAlive();
    }

    SessionKey getIntroKey() {
        return this._introKey;
    }

    int getExternalPort(boolean ipv6) {
        int rv;
        RouterAddress addr = this.getCurrentAddress(ipv6);
        if (addr != null && (rv = addr.getPort()) > 0) {
            return rv;
        }
        return this.getRequestedPort(ipv6);
    }

    byte[] getExternalIP() {
        RouterAddress addr = this.getCurrentAddress(false);
        if (addr != null) {
            return addr.getIP();
        }
        return null;
    }

    boolean isTooClose(byte[] ip) {
        if (this.allowLocal()) {
            return false;
        }
        for (RouterAddress addr : this.getCurrentAddresses()) {
            byte[] myip = addr.getIP();
            if (myip == null || ip.length != myip.length || !(ip.length == 4 ? DataHelper.eq((byte[])ip, (int)0, (byte[])myip, (int)0, (int)2) : ip.length == 16 && DataHelper.eq((byte[])ip, (int)0, (byte[])myip, (int)0, (int)8))) continue;
            return true;
        }
        return false;
    }

    private int getListenPort(boolean ipv6) {
        for (UDPEndpoint endpoint : this._endpoints) {
            if ((ipv6 || !endpoint.isIPv4()) && (!ipv6 || !endpoint.isIPv6())) continue;
            return endpoint.getListenPort();
        }
        return -1;
    }

    @Override
    public int getRequestedPort() {
        return this.getRequestedPort(false);
    }

    private int getRequestedPort(boolean ipv6) {
        int rv = this.getListenPort(ipv6);
        if (rv > 0) {
            return rv;
        }
        rv = this._context.getProperty(PROP_INTERNAL_PORT, -1);
        if (rv > 0) {
            return rv;
        }
        return this._context.getProperty(PROP_EXTERNAL_PORT, -1);
    }

    private int setMTU(InetAddress addr) {
        String p = this._context.getProperty(PROP_DEFAULT_MTU);
        if (p != null) {
            try {
                int pmtu = Integer.parseInt(p);
                this._mtu = MTU.rectify(false, pmtu);
                this._mtu_ipv6 = MTU.rectify(true, pmtu);
                return this._mtu;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        int mtu = MTU.getMTU(addr);
        if (addr != null && addr.getAddress().length == 16) {
            if (mtu <= 0) {
                mtu = 1280;
            }
            this._mtu_ipv6 = mtu;
        } else {
            if (mtu <= 0) {
                mtu = 1484;
            }
            this._mtu = mtu;
        }
        return mtu;
    }

    int getMTU(boolean ipv6) {
        return ipv6 ? this._mtu_ipv6 : this._mtu;
    }

    void inboundConnectionReceived() {
        this._lastInboundReceivedOn = System.currentTimeMillis();
    }

    @Override
    public void externalAddressReceived(Transport.AddressSource source, byte[] ip, int port) {
        boolean changed;
        if (this._log.shouldLog(30)) {
            this._log.warn("Received address: " + Addresses.toString((byte[])ip, (int)port) + " from: " + (Object)((Object)source));
        }
        if (ip == null) {
            return;
        }
        if (source == Transport.AddressSource.SOURCE_INTERFACE && ip.length == 16) {
            this._haveIPv6Address = true;
        }
        if (this.explicitAddressSpecified()) {
            return;
        }
        String sources = this._context.getProperty(PROP_SOURCES, DEFAULT_SOURCES);
        if (!sources.contains(source.toConfigString())) {
            return;
        }
        if (!this.isValid(ip)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid address: " + Addresses.toString((byte[])ip, (int)port) + " from: " + (Object)((Object)source));
            }
            return;
        }
        if (!this.isAlive()) {
            if (source == Transport.AddressSource.SOURCE_INTERFACE || source == Transport.AddressSource.SOURCE_UPNP) {
                try {
                    InetAddress ia = InetAddress.getByAddress(ip);
                    this.saveLocalAddress(ia);
                }
                catch (UnknownHostException uhe) {
                    // empty catch block
                }
            }
            return;
        }
        if (source == Transport.AddressSource.SOURCE_INTERFACE) {
            if (ip.length == 4) {
                if (this.gotIPv4Addr) {
                    return;
                }
                this.gotIPv4Addr = true;
            } else if (ip.length == 16) {
                if (this.gotIPv6Addr) {
                    return;
                }
                this.gotIPv6Addr = true;
            }
        }
        if ((changed = this.changeAddress(ip, port)) && ip.length == 4 && source == Transport.AddressSource.SOURCE_INTERFACE) {
            this.setReachabilityStatus((short)0);
        }
    }

    @Override
    public void forwardPortStatus(byte[] ip, int port, int externalPort, boolean success, String reason) {
        if (this._log.shouldLog(30)) {
            if (success) {
                this._log.warn("UPnP has opened the SSU port: " + port + " via " + Addresses.toString((byte[])ip, (int)externalPort));
            } else {
                this._log.warn("UPnP has failed to open the SSU port: " + port + " reason: " + reason);
            }
        }
        if (success && ip != null && this.getExternalIP() != null) {
            this.setReachabilityStatus((short)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void externalAddressReceived(Hash from, byte[] ourIP, int ourPort) {
        boolean inboundRecent;
        if (ourIP.length != 4) {
            return;
        }
        boolean isValid = this.isValid(ourIP) && ourPort >= 1024 && ourPort <= 65535;
        boolean explicitSpecified = this.explicitAddressSpecified();
        boolean bl = inboundRecent = this._lastInboundReceivedOn + 120000L > System.currentTimeMillis();
        if (this._log.shouldLog(20)) {
            this._log.info("External address received: " + Addresses.toString((byte[])ourIP, (int)ourPort) + " from " + from + ", isValid? " + isValid + ", explicitSpecified? " + explicitSpecified + ", receivedInboundRecent? " + inboundRecent + " status " + this._reachabilityStatus);
        }
        if (explicitSpecified) {
            return;
        }
        String sources = this._context.getProperty(PROP_SOURCES, DEFAULT_SOURCES);
        if (!sources.contains("ssu")) {
            return;
        }
        if (!isValid) {
            if (this._log.shouldLog(40)) {
                this._log.error("The router " + from + " told us we have an invalid IP - " + Addresses.toString((byte[])ourIP, (int)ourPort) + ".  Lets throw tomatoes at them");
            }
            this.markUnreachable(from);
            return;
        }
        RouterAddress addr = this.getCurrentAddress(false);
        if (inboundRecent && addr != null && addr.getPort() > 0 && addr.getHost() != null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring IP address suggestion, since we have received an inbound con recently");
            }
        } else {
            boolean changeIt = false;
            UDPTransport uDPTransport = this;
            synchronized (uDPTransport) {
                if (from.equals((Object)this._lastFrom) || !UDPTransport.eq(this._lastOurIP, this._lastOurPort, ourIP, ourPort)) {
                    this._lastFrom = from;
                    this._lastOurIP = ourIP;
                    this._lastOurPort = ourPort;
                    if (this._log.shouldLog(20)) {
                        this._log.info("The router " + from + " told us we have a new IP - " + Addresses.toString((byte[])ourIP, (int)ourPort) + ".  Wait until somebody else tells us the same thing.");
                    }
                } else {
                    this._lastFrom = from;
                    this._lastOurIP = ourIP;
                    this._lastOurPort = ourPort;
                    changeIt = true;
                }
            }
            if (changeIt) {
                if (this._log.shouldLog(20)) {
                    this._log.info(from + " and " + this._lastFrom + " agree we have a new IP - " + Addresses.toString((byte[])ourIP, (int)ourPort) + ".  Changing address.");
                }
                this.changeAddress(ourIP, ourPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeAddress(byte[] ourIP, int ourPort) {
        int externalListenPort;
        boolean fixedPort = this.getIsPortFixed();
        boolean updated = false;
        boolean fireTest = false;
        boolean isIPv6 = ourIP.length == 16;
        RouterAddress current = this.getCurrentAddress(isIPv6);
        byte[] externalListenHost = current != null ? current.getIP() : null;
        int n = externalListenPort = current != null ? current.getPort() : this.getRequestedPort(isIPv6);
        if (this._log.shouldLog(20)) {
            this._log.info("Change address? status = " + this._reachabilityStatus + " diff = " + (this._context.clock().now() - this._reachabilityStatusLastUpdated) + " old = " + Addresses.toString((byte[])externalListenHost, (int)externalListenPort) + " new = " + Addresses.toString((byte[])ourIP, (int)ourPort));
        }
        if (fixedPort && externalListenPort > 0 || ourPort <= 0) {
            ourPort = externalListenPort;
        }
        UDPTransport uDPTransport = this;
        synchronized (uDPTransport) {
            if (ourPort > 0 && !UDPTransport.eq(externalListenHost, externalListenPort, ourIP, ourPort)) {
                RouterAddress newAddr;
                if (this._log.shouldLog(30)) {
                    this._log.warn("Trying to change our external address to " + Addresses.toString((byte[])ourIP, (int)ourPort));
                }
                updated = (newAddr = this.rebuildExternalAddress(ourIP, ourPort, true)) != null;
            } else if (this._log.shouldLog(20)) {
                this._log.info("Same address as the current one");
            }
        }
        if (fireTest) {
            this._context.statManager().addRateData("udp.addressTestInsteadOfUpdate", 1L);
        } else if (updated) {
            this._context.statManager().addRateData("udp.addressUpdated", 1L);
            HashMap<String, String> changes = new HashMap<String, String>();
            if (ourIP.length == 4 && !fixedPort) {
                changes.put(PROP_EXTERNAL_PORT, Integer.toString(ourPort));
            }
            if (ourIP.length == 4) {
                this._context.commSystem().queueLookup(ourIP);
            }
            String oldIP = this._context.getProperty(PROP_IP);
            String newIP = Addresses.toString((byte[])ourIP);
            if (ourIP.length == 4 && !newIP.equals(oldIP)) {
                long lastChanged = 0L;
                long now = this._context.clock().now();
                String lcs = this._context.getProperty(PROP_IP_CHANGE);
                if (lcs != null) {
                    try {
                        lastChanged = Long.parseLong(lcs);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                changes.put(PROP_IP, newIP);
                changes.put(PROP_IP_CHANGE, Long.toString(now));
                this._context.router().saveConfig(changes, null);
                if (oldIP != null && System.getProperty("wrapper.version") != null && this._context.getBooleanProperty(PROP_LAPTOP_MODE) && now - lastChanged > 600000L && this._context.router().getUptime() < 600000L) {
                    this._log.log(50, "IP changed, restarting with a new identity and port");
                    this._context.router().killKeys();
                    this._context.router().shutdown(4);
                }
            } else if (ourIP.length == 4 && !fixedPort) {
                this._context.router().saveConfig(changes, null);
            }
            this._context.router().rebuildRouterInfo();
        }
        this._testEvent.forceRun();
        this._testEvent.reschedule(5000L);
        return updated;
    }

    private static final boolean eq(byte[] laddr, int lport, byte[] raddr, int rport) {
        return rport == lport && DataHelper.eq((byte[])laddr, (byte[])raddr);
    }

    public final boolean isValid(byte[] addr) {
        if (addr == null) {
            return false;
        }
        if (this.isPubliclyRoutable(addr) && (addr.length != 16 || this._haveIPv6Address)) {
            return true;
        }
        return this.allowLocal();
    }

    boolean allowLocal() {
        return this._context.getBooleanProperty("i2np.udp.allowLocal");
    }

    private boolean getIsPortFixed() {
        String prop = this._context.getProperty(PROP_FIXED_PORT);
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        short status = this.getReachabilityStatus();
        return status != 2;
    }

    PeerState getPeerState(RemoteHostId hostInfo) {
        return this._peersByRemoteHost.get(hostInfo);
    }

    List<PeerState> getPeerStatesByIP(RemoteHostId hostInfo) {
        ArrayList<PeerState> rv = new ArrayList<PeerState>(4);
        byte[] ip = hostInfo.getIP();
        if (ip != null && ip.length == 4) {
            for (PeerState ps : this._peersByIdent.values()) {
                if (!DataHelper.eq((byte[])ip, (byte[])ps.getRemoteIP())) continue;
                rv.add(ps);
            }
        }
        return rv;
    }

    PeerState getPeerState(Hash remotePeer) {
        return this._peersByIdent.get(remotePeer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changePeerPort(PeerState peer, int newPort) {
        int oldPort;
        Object object = this._addDropLock;
        synchronized (object) {
            oldPort = peer.getRemotePort();
            if (oldPort != newPort) {
                this._peersByRemoteHost.remove(peer.getRemoteHostId());
                peer.changePort(newPort);
                this._peersByRemoteHost.put(peer.getRemoteHostId(), peer);
            }
        }
        if (this._log.shouldLog(30) && oldPort != newPort) {
            this._log.warn("Changed port from " + oldPort + " to " + newPort + " for " + peer);
        }
    }

    EstablishmentManager getEstablisher() {
        return this._establisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addRemotePeerState(PeerState peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Add remote peer state: " + peer);
        }
        Object object = this._addDropLock;
        synchronized (object) {
            return this.locked_addRemotePeerState(peer);
        }
    }

    private boolean locked_addRemotePeerState(PeerState peer) {
        PeerState oldPeer2;
        Hash remotePeer = peer.getRemotePeer();
        long oldEstablishedOn = -1L;
        PeerState oldPeer = null;
        if (remotePeer != null && (oldPeer = this._peersByIdent.put(remotePeer, peer)) != null && oldPeer != peer) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer already connected (PBID): old=" + oldPeer + " new=" + peer);
            }
            peer.loadFrom(oldPeer);
            oldEstablishedOn = oldPeer.getKeyEstablishedTime();
        }
        RemoteHostId remoteId = peer.getRemoteHostId();
        if (oldPeer != null) {
            oldPeer.dropOutbound();
            this._introManager.remove(oldPeer);
            this._expireEvent.remove(oldPeer);
            RemoteHostId oldID = oldPeer.getRemoteHostId();
            if (!remoteId.equals(oldID)) {
                PeerState oldPeer22;
                if (this._log.shouldLog(30)) {
                    this._log.warn(remotePeer + " changed address FROM " + oldID + " TO " + remoteId);
                }
                if ((oldPeer22 = this._peersByRemoteHost.remove(oldID)) != oldPeer && oldPeer22 != null) {
                    oldPeer22.dropOutbound();
                    this._introManager.remove(oldPeer22);
                    this._expireEvent.remove(oldPeer22);
                }
            }
        }
        if (remoteId.getIP() == null && this._log.shouldLog(30)) {
            this._log.warn("Add indirect: " + peer);
        }
        if ((oldPeer2 = this._peersByRemoteHost.put(remoteId, peer)) != null && oldPeer2 != peer && oldPeer2 != oldPeer) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer already connected (PBRH): old=" + oldPeer2 + " new=" + peer);
            }
            peer.loadFrom(oldPeer2);
            oldEstablishedOn = oldPeer2.getKeyEstablishedTime();
            oldPeer2.dropOutbound();
            this._introManager.remove(oldPeer2);
            this._expireEvent.remove(oldPeer2);
        }
        if (this._log.shouldLog(30) && this._peersByIdent.size() != this._peersByRemoteHost.size()) {
            this._log.warn("Size Mismatch after add: " + peer + " byIDsz = " + this._peersByIdent.size() + " byHostsz = " + this._peersByRemoteHost.size());
        }
        this._activeThrottle.unchoke(peer.getRemotePeer());
        this.markReachable(peer.getRemotePeer(), peer.isInbound());
        this._expireEvent.add(peer);
        this._introManager.add(peer);
        if (oldEstablishedOn > 0L) {
            this._context.statManager().addRateData("udp.alreadyConnected", oldEstablishedOn, 0L);
        }
        if (this.needsRebuild()) {
            this.rebuildExternalAddress();
        }
        if (this.getReachabilityStatus() != 0) {
            this._testEvent.forceRun();
            this._testEvent.reschedule(0L);
        }
        return true;
    }

    @Override
    public void messageReceived(I2NPMessage inMsg, RouterIdentity remoteIdent, Hash remoteIdentHash, long msToReceive, int bytesReceived) {
        if (inMsg.getType() == 1) {
            DatabaseStoreMessage dsm = (DatabaseStoreMessage)inMsg;
            DatabaseEntry entry = dsm.getEntry();
            if (entry == null) {
                return;
            }
            if (entry.getType() == 0 && ((RouterInfo)entry).getNetworkId() != 2) {
                Hash peerHash = entry.getHash();
                PeerState peer = this.getPeerState(peerHash);
                if (peer != null) {
                    RemoteHostId remote = peer.getRemoteHostId();
                    this._dropList.add(remote);
                    this._context.statManager().addRateData("udp.dropPeerDroplist", 1L);
                    this._context.simpleScheduler().addEvent((SimpleTimer.TimedEvent)new RemoveDropList(remote), 600000L);
                }
                this.markUnreachable(peerHash);
                this._context.banlist().banlistRouter(peerHash, "Part of the wrong network, version = " + ((RouterInfo)entry).getOption("router.version"));
                this.dropPeer(peerHash, false, "wrong network");
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping the peer " + peerHash + " because they are in the wrong net: " + entry);
                }
                return;
            }
            if (entry.getType() == 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Received an RI from the same net");
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("Received a leaseSet: " + dsm);
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Received another message: " + inMsg.getClass().getName());
        }
        PeerState peer = this.getPeerState(remoteIdentHash);
        super.messageReceived(inMsg, remoteIdent, remoteIdentHash, msToReceive, bytesReceived);
        if (peer != null) {
            peer.expireInboundMessages();
        }
    }

    boolean isInDropList(RemoteHostId peer) {
        return this._dropList.contains(peer);
    }

    void dropPeer(Hash peer, boolean shouldBanlist, String why) {
        PeerState state = this.getPeerState(peer);
        if (state != null) {
            this.dropPeer(state, shouldBanlist, why);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropPeer(PeerState peer, boolean shouldBanlist, String why) {
        if (this._log.shouldLog(20)) {
            long now = this._context.clock().now();
            StringBuilder buf = new StringBuilder(4096);
            long timeSinceSend = now - peer.getLastSendTime();
            long timeSinceRecv = now - peer.getLastReceiveTime();
            long timeSinceAck = now - peer.getLastACKSend();
            long timeSinceSendOK = now - peer.getLastSendFullyTime();
            int consec = peer.getConsecutiveFailedSends();
            buf.append("Dropping remote peer: ").append(peer.toString()).append(" banlist? ").append(shouldBanlist);
            buf.append(" lifetime: ").append(now - peer.getKeyEstablishedTime());
            buf.append(" time since send/fully/recv/ack: ").append(timeSinceSend).append(THINSP);
            buf.append(timeSinceSendOK).append(THINSP);
            buf.append(timeSinceRecv).append(THINSP).append(timeSinceAck);
            buf.append(" consec failures: ").append(consec);
            if (why != null) {
                buf.append(" cause: ").append(why);
            }
            this._log.info(buf.toString(), (Throwable)new Exception("Dropped by"));
        }
        Object object = this._addDropLock;
        synchronized (object) {
            this.locked_dropPeer(peer, shouldBanlist, why);
        }
        if (this.needsRebuild()) {
            this.rebuildExternalAddress();
        }
    }

    private void locked_dropPeer(PeerState peer, boolean shouldBanlist, String why) {
        RemoteHostId remoteId;
        PeerState altByHost;
        peer.dropOutbound();
        peer.expireInboundMessages();
        this._introManager.remove(peer);
        this._fragments.dropPeer(peer);
        PeerState altByIdent = null;
        if (peer.getRemotePeer() != null) {
            this.dropPeerCapacities(peer);
            if (shouldBanlist) {
                this.markUnreachable(peer.getRemotePeer());
            }
            long now = this._context.clock().now();
            this._context.statManager().addRateData("udp.droppedPeer", now - peer.getLastReceiveTime(), now - peer.getKeyEstablishedTime());
            altByIdent = this._peersByIdent.remove(peer.getRemotePeer());
        }
        if (altByIdent != (altByHost = this._peersByRemoteHost.remove(remoteId = peer.getRemoteHostId())) && this._log.shouldLog(30)) {
            this._log.warn("Mismatch on remove, RHID = " + remoteId + " byID = " + altByIdent + " byHost = " + altByHost + " byIDsz = " + this._peersByIdent.size() + " byHostsz = " + this._peersByRemoteHost.size());
        }
        this._activeThrottle.unchoke(peer.getRemotePeer());
        this._expireEvent.remove(peer);
        if (altByIdent != null && peer != altByIdent) {
            this.locked_dropPeer(altByIdent, shouldBanlist, "recurse");
        }
        if (altByHost != null && peer != altByHost) {
            this.locked_dropPeer(altByHost, shouldBanlist, "recurse");
        }
    }

    private boolean needsRebuild() {
        boolean rv;
        if (this._needsRebuild) {
            return true;
        }
        if (this._context.router().isHidden()) {
            return false;
        }
        RouterAddress addr = this.getCurrentAddress(false);
        if (this.introducersRequired()) {
            UDPAddress ua = new UDPAddress(addr);
            int valid = 0;
            for (int i = 0; i < ua.getIntroducerCount(); ++i) {
                PeerState peer = this.getPeerState(Hash.create((byte[])ua.getIntroducerKey(i)));
                if (peer == null) continue;
                ++valid;
            }
            if (valid >= 3) {
                if (this._introducersSelectedOn < this._context.clock().now() - 600000L) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Our introducers are valid, but havent changed in a while, so lets rechoose");
                    }
                    return true;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Our introducers are valid and haven't changed in a while");
                }
                return false;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Need more introducers (have " + valid + " need " + 3 + ')');
            }
            return true;
        }
        byte[] externalListenHost = addr != null ? addr.getIP() : null;
        int externalListenPort = addr != null ? addr.getPort() : -1;
        boolean bl = rv = externalListenHost == null || externalListenPort <= 0;
        if (!rv && addr.getOption("ihost0") != null) {
            rv = true;
        }
        if (rv) {
            if (this._log.shouldLog(20)) {
                this._log.info("Need to initialize our direct SSU info (" + Addresses.toString((byte[])externalListenHost, (int)externalListenPort) + ')');
            }
        } else if (addr.getPort() <= 0 || addr.getHost() == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Our direct SSU info is initialized, but not used in our address yet");
            }
            rv = true;
        }
        return rv;
    }

    private void dropPeerCapacities(PeerState peer) {
    }

    void send(UDPPacket packet) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending packet " + packet);
        }
        this._pusher.send(packet);
    }

    private void sendDestroy(PeerState peer) {
        if (peer.getCurrentCipherKey() == null) {
            return;
        }
        UDPPacket pkt = this._destroyBuilder.buildSessionDestroyPacket(peer);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending destroy to : " + peer);
        }
        this.send(pkt);
    }

    private void destroyAll() {
        for (UDPEndpoint endpoint : this._endpoints) {
            endpoint.clearOutbound();
        }
        int howMany = this._peersByIdent.size();
        int burst = 8;
        int pps = Math.max(48, this._context.bandwidthLimiter().getOutboundKBytesPerSecond() * 1000 / 4 / 48);
        int burstps = pps / 8;
        int toSleep = Math.max(8, 1000 / burstps);
        int count = 0;
        if (this._log.shouldLog(30)) {
            this._log.warn("Sending destroy to : " + howMany + " peers");
        }
        for (PeerState peer : this._peersByIdent.values()) {
            this.sendDestroy(peer);
            if (++count % 8 != 0) continue;
            try {
                Thread.sleep(toSleep);
            }
            catch (InterruptedException ie) {}
        }
        toSleep = Math.min(howMany / 3, 750);
        if (toSleep > 0) {
            try {
                Thread.sleep(toSleep);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    @Override
    public TransportBid bid(RouterInfo toAddress, long dataSize) {
        if (dataSize > 32768L) {
            return null;
        }
        Hash to = toAddress.getIdentity().calculateHash();
        PeerState peer = this.getPeerState(to);
        if (peer != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("bidding on a message to an established peer: " + peer);
            }
            if (this.preferUDP()) {
                return this._cachedBid[0];
            }
            return this._cachedBid[2];
        }
        if (this._reachabilityStatus == 4) {
            this.markUnreachable(to);
            return null;
        }
        RouterAddress addr = this.getTargetAddress(toAddress);
        if (addr == null) {
            this.markUnreachable(to);
            return null;
        }
        if (!this.allowConnection()) {
            return this._cachedBid[8];
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("bidding on a message to an unestablished peer: " + to);
        }
        int count = this._peersByIdent.size();
        if (this.alwaysPreferUDP() || count < 3 || this.introducersRequired() && this._introManager.introducerCount() < 5) {
            return this._cachedBid[1];
        }
        if (this.preferUDP()) {
            return this._cachedBid[3];
        }
        if (this.haveCapacity()) {
            if (addr.getCost() > 5) {
                return this._cachedBid[5];
            }
            return this._cachedBid[4];
        }
        if (addr.getCost() > 5) {
            return this._cachedBid[7];
        }
        return this._cachedBid[6];
    }

    RouterAddress getTargetAddress(RouterInfo target) {
        List<RouterAddress> addrs = this.getTargetAddresses(target);
        for (int i = 0; i < addrs.size(); ++i) {
            RouterAddress addr = addrs.get(i);
            if (addr.getOption("ihost0") == null) {
                byte[] ip = addr.getIP();
                int port = addr.getPort();
                if (ip == null || port < 1024 || !this.isValid(ip) || Arrays.equals(ip, this.getExternalIP()) && !this.allowLocal()) continue;
            }
            return addr;
        }
        return null;
    }

    private boolean preferUDP() {
        String pref = this._context.getProperty(PROP_PREFER_UDP, DEFAULT_PREFER_UDP);
        return pref != null && !DEFAULT_PREFER_UDP.equals(pref);
    }

    private boolean alwaysPreferUDP() {
        String pref = this._context.getProperty(PROP_PREFER_UDP, DEFAULT_PREFER_UDP);
        return pref != null && "always".equals(pref);
    }

    @Override
    public String getStyle() {
        return STYLE;
    }

    @Override
    public void send(OutNetMessage msg) {
        if (msg == null) {
            return;
        }
        if (msg.getTarget() == null) {
            return;
        }
        if (msg.getTarget().getIdentity() == null) {
            return;
        }
        if (this._establisher == null) {
            this.failed(msg, "UDP not up yet");
            return;
        }
        msg.timestamp("sending on UDP transport");
        Hash to = msg.getTarget().getIdentity().calculateHash();
        PeerState peer = this.getPeerState(to);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending to " + (to != null ? to.toString() : ""));
        }
        if (peer != null) {
            long lastSend = peer.getLastSendFullyTime();
            long lastRecv = peer.getLastReceiveTime();
            long now = this._context.clock().now();
            int inboundActive = peer.expireInboundMessages();
            if (lastSend > 0L && lastRecv > 0L && now - lastSend > 1200000L && now - lastRecv > 1200000L && peer.getConsecutiveFailedSends() > 0 && inboundActive <= 0) {
                this.dropPeer(peer, false, "proactive reconnection");
                msg.timestamp("peer is really idle, dropping con and reestablishing");
                if (this._log.shouldLog(10)) {
                    this._log.debug("Proactive reestablish to " + to);
                }
                this._establisher.establish(msg);
                this._context.statManager().addRateData("udp.proactiveReestablish", now - lastSend, now - peer.getKeyEstablishedTime());
                return;
            }
            msg.timestamp("enqueueing for an already established peer");
            if (this._log.shouldLog(10)) {
                this._log.debug("Add to fragments for " + to);
            }
            this._fragments.add(msg);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Establish new connection to " + to);
            }
            msg.timestamp("establishing a new connection");
            this._establisher.establish(msg);
        }
    }

    void sendIfEstablished(OutNetMessage msg) {
        this._fragments.add(msg);
    }

    void send(I2NPMessage msg, PeerState peer) {
        block3: {
            try {
                OutboundMessageState state = new OutboundMessageState((I2PAppContext)this._context, msg, peer);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Injecting a data message to a new peer: " + peer);
                }
                this._fragments.add(state);
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block3;
                this._log.warn("Shouldnt happen", (Throwable)new Exception("I did it"));
            }
        }
    }

    @Override
    protected void outboundMessageReady() {
        throw new UnsupportedOperationException("Not used for UDP");
    }

    @Override
    public void startListening() {
        this.startup();
    }

    @Override
    public void stopListening() {
        this.shutdown();
        this.replaceAddress(null);
    }

    private boolean explicitAddressSpecified() {
        String h = this._context.getProperty(PROP_EXTERNAL_HOST);
        return h != null && h.length() > 0;
    }

    @Override
    public List<RouterAddress> updateAddress() {
        this.rebuildExternalAddress(false);
        return this.getCurrentAddresses();
    }

    private RouterAddress rebuildExternalAddress() {
        if (this._log.shouldLog(10)) {
            this._log.debug("REA1");
        }
        return this.rebuildExternalAddress(true);
    }

    private RouterAddress rebuildExternalAddress(boolean allowRebuildRouterInfo) {
        if (this._log.shouldLog(10)) {
            this._log.debug("REA2 " + allowRebuildRouterInfo);
        }
        int port = this._context.getProperty(PROP_EXTERNAL_PORT, -1);
        Object ip = null;
        String host = null;
        if (this.explicitAddressSpecified()) {
            host = this._context.getProperty(PROP_EXTERNAL_HOST);
        } else {
            RouterAddress cur = this.getCurrentAddress(false);
            if (cur != null) {
                host = cur.getHost();
            }
        }
        return this.rebuildExternalAddress(host, port, allowRebuildRouterInfo);
    }

    private RouterAddress rebuildExternalAddress(byte[] ip, int port, boolean allowRebuildRouterInfo) {
        if (this._log.shouldLog(10)) {
            this._log.debug("REA3 " + Addresses.toString((byte[])ip, (int)port));
        }
        if (ip == null) {
            return this.rebuildExternalAddress((String)null, port, allowRebuildRouterInfo);
        }
        if (this.isValid(ip)) {
            return this.rebuildExternalAddress(Addresses.toString((byte[])ip), port, allowRebuildRouterInfo);
        }
        return null;
    }

    private RouterAddress rebuildExternalAddress(String host, int port, boolean allowRebuildRouterInfo) {
        int mtu;
        boolean isIPv6;
        if (this._log.shouldLog(10)) {
            this._log.debug("REA4 " + host + ':' + port);
        }
        if (this._context.router().isHidden()) {
            return null;
        }
        OrderedProperties options = new OrderedProperties();
        boolean directIncluded = false;
        boolean bl = isIPv6 = host != null && host.contains(":");
        if (this.allowDirectUDP() && port > 0 && host != null) {
            options.setProperty("port", String.valueOf(port));
            options.setProperty("host", host);
            directIncluded = true;
        }
        boolean introducersRequired = !isIPv6 && this.introducersRequired();
        boolean introducersIncluded = false;
        if (introducersRequired || !directIncluded) {
            int found = this._introManager.pickInbound((Properties)options, 3);
            if (found > 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Direct? " + directIncluded + " reqd? " + introducersRequired + " picked introducers: " + found);
                }
                this._introducersSelectedOn = this._context.clock().now();
                introducersIncluded = true;
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Direct? " + directIncluded + " reqd? " + introducersRequired + " no introducers");
            }
        }
        if (introducersRequired) {
            options.setProperty("caps", "B");
        } else {
            options.setProperty("caps", "BC");
        }
        if (host == null) {
            mtu = this._mtu;
        } else {
            try {
                InetAddress ia = InetAddress.getByName(host);
                mtu = this.setMTU(ia);
            }
            catch (UnknownHostException uhe) {
                mtu = this._mtu;
            }
        }
        if (mtu < 1484) {
            options.setProperty("mtu", Integer.toString(mtu));
        }
        if (directIncluded || introducersIncluded) {
            RouterAddress current;
            RouterAddress addr;
            boolean wantsRebuild;
            if (this._introKey != null) {
                options.setProperty("key", this._introKey.toBase64());
            }
            int cost = 5;
            if (!this.haveCapacity(91)) {
                ++cost;
            }
            if (introducersIncluded) {
                cost += 2;
            }
            if (isIPv6) {
                TransportUtil.IPv6Config config = this.getIPv6Config();
                if (config == TransportUtil.IPv6Config.IPV6_PREFERRED) {
                    --cost;
                } else if (config == TransportUtil.IPv6Config.IPV6_NOT_PREFERRED) {
                    ++cost;
                }
            }
            boolean bl2 = wantsRebuild = !(addr = new RouterAddress(STYLE, options, cost)).deepEquals(current = this.getCurrentAddress(isIPv6));
            if (wantsRebuild) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Address rebuilt: " + addr);
                }
                this.replaceAddress(addr);
                if (allowRebuildRouterInfo) {
                    this._context.router().rebuildRouterInfo();
                }
            } else {
                addr = null;
            }
            if (!isIPv6) {
                this._needsRebuild = false;
            }
            return addr;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Wanted to rebuild my SSU address, but couldn't specify either the direct or indirect info (needs introducers? " + introducersRequired + ")", (Throwable)new Exception("source"));
        }
        this._needsRebuild = true;
        return null;
    }

    @Override
    protected void replaceAddress(RouterAddress address) {
        super.replaceAddress(address);
        this._context.commSystem().notifyReplaceAddress(address);
    }

    public boolean introducersRequired() {
        short status = this.getReachabilityStatus();
        switch (status) {
            case 1: 
            case 2: {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Require introducers, because our status is " + status);
                }
                return true;
            }
        }
        if (!this.allowDirectUDP()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Require introducers, because we do not allow direct UDP connections");
            }
            return true;
        }
        return false;
    }

    boolean canIntroduce() {
        return !this._context.router().isHidden() && !this.introducersRequired() && this.haveCapacity() && !this._context.netDb().floodfillEnabled() && this._introManager.introducedCount() < 100 && this._introManager.introducedCount() < this.getMaxConnections() / 4;
    }

    private boolean allowDirectUDP() {
        return this._context.getBooleanPropertyDefaultTrue(PROP_ALLOW_DIRECT);
    }

    String getPacketHandlerStatus() {
        PacketHandler handler = this._handler;
        if (handler != null) {
            return handler.getHandlerStatus();
        }
        return "";
    }

    PacketHandler getPacketHandler() {
        return this._handler;
    }

    public void failed(OutboundMessageState msg) {
        this.failed(msg, true);
    }

    void failed(OutboundMessageState msg, boolean allowPeerFailure) {
        if (msg == null) {
            return;
        }
        int consecutive = 0;
        OutNetMessage m = msg.getMessage();
        if (allowPeerFailure && msg.getPeer() != null && (msg.getMaxSends() >= 10 || msg.isExpired())) {
            consecutive = msg.getPeer().incrementConsecutiveFailedSends();
            if (this._log.shouldLog(20)) {
                this._log.info("Consecutive failure #" + consecutive + " on " + msg.toString() + " to " + msg.getPeer());
            }
            if (this._context.clock().now() - msg.getPeer().getLastSendFullyTime() > 60000L && consecutive >= 5) {
                this._context.statManager().addRateData("udp.dropPeerConsecutiveFailures", (long)consecutive, msg.getPeer().getInactivityTime());
                this.dropPeer(msg.getPeer(), false, "too many failures");
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Failed sending " + msg + " to " + msg.getPeer());
        }
        this.noteSend(msg, false);
        if (m != null) {
            super.afterSend(m, false);
        }
    }

    private void noteSend(OutboundMessageState msg, boolean successful) {
        if (!this._context.messageHistory().getDoLog()) {
            return;
        }
        int pushCount = msg.getPushCount();
        int sends = msg.getMaxSends();
        boolean expired = msg.isExpired();
        OutNetMessage m = msg.getMessage();
        PeerState p = msg.getPeer();
        StringBuilder buf = new StringBuilder(64);
        buf.append(" lifetime: ").append(msg.getLifetime());
        buf.append(" sends: ").append(sends);
        buf.append(" pushes: ").append(pushCount);
        buf.append(" expired? ").append(expired);
        buf.append(" unacked: ").append(msg.getUnackedSize());
        if (p != null && !successful) {
            buf.append(" consec_failed: ").append(p.getConsecutiveFailedSends());
            long timeSinceSend = this._context.clock().now() - p.getLastSendFullyTime();
            buf.append(" lastFullSend: ").append(timeSinceSend);
            long timeSinceRecv = this._context.clock().now() - p.getLastReceiveTime();
            buf.append(" lastRecv: ").append(timeSinceRecv);
            buf.append(" xfer: ").append(p.getSendBps()).append("/").append(p.getReceiveBps());
            buf.append(" mtu: ").append(p.getMTU());
            buf.append(" rto: ").append(p.getRTO());
            buf.append(" sent: ").append(p.getMessagesSent()).append("/").append(p.getPacketsTransmitted());
            buf.append(" recv: ").append(p.getMessagesReceived()).append("/").append(p.getPacketsReceived());
            buf.append(" uptime: ").append(this._context.clock().now() - p.getKeyEstablishedTime());
        }
        if (m != null && p != null) {
            this._context.messageHistory().sendMessage(m.getMessageType(), msg.getMessageId(), m.getExpiration(), p.getRemotePeer(), successful, buf.toString());
        } else {
            this._context.messageHistory().sendMessage("establish", msg.getMessageId(), -1L, p != null ? p.getRemotePeer() : null, successful, buf.toString());
        }
    }

    @Override
    public void failed(OutNetMessage msg, String reason) {
        if (msg == null) {
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Sending message failed: " + msg, (Throwable)new Exception("failed from"));
        }
        if (this._context.messageHistory().getDoLog()) {
            this._context.messageHistory().sendMessage(msg.getMessageType(), msg.getMessageId(), msg.getExpiration(), msg.getTarget().getIdentity().calculateHash(), false, reason);
        }
        super.afterSend(msg, false);
    }

    public void succeeded(OutboundMessageState msg) {
        if (msg == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending message succeeded: " + msg);
        }
        this.noteSend(msg, true);
        OutNetMessage m = msg.getMessage();
        if (m != null) {
            super.afterSend(m, true);
        }
    }

    @Override
    public int countPeers() {
        return this._peersByIdent.size();
    }

    @Override
    public int countActivePeers() {
        long now = this._context.clock().now();
        int active = 0;
        for (PeerState peer : this._peersByIdent.values()) {
            if (now - peer.getLastReceiveTime() > 300000L) continue;
            ++active;
        }
        return active;
    }

    @Override
    public int countActiveSendPeers() {
        long now = this._context.clock().now();
        int active = 0;
        for (PeerState peer : this._peersByIdent.values()) {
            if (now - peer.getLastSendFullyTime() > 60000L) continue;
            ++active;
        }
        return active;
    }

    @Override
    public boolean isEstablished(Hash dest) {
        return this.getPeerState(dest) != null;
    }

    @Override
    public boolean isBacklogged(Hash dest) {
        PeerState peer = this._peersByIdent.get(dest);
        return peer != null && peer.isBacklogged();
    }

    public boolean allowConnection() {
        return this._peersByIdent.size() < this.getMaxConnections();
    }

    @Override
    public Vector<Long> getClockSkews() {
        Vector<Long> skews = new Vector<Long>();
        boolean includeEverybody = this._context.router().getUptime() < 600000L || this._peersByIdent.size() < 10;
        long now = this._context.clock().now();
        for (PeerState peer : this._peersByIdent.values()) {
            if (!includeEverybody && now - peer.getLastReceiveTime() > 300000L || peer.getRTT() > 1250) continue;
            skews.addElement(peer.getClockSkew() / 1000L);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("UDP transport returning " + skews.size() + " peer clock skews.");
        }
        return skews;
    }

    DHSessionKeyBuilder getDHBuilder() {
        return this._dhFactory.getBuilder();
    }

    DHSessionKeyBuilder.Factory getDHFactory() {
        return this._dhFactory;
    }

    private static Comparator getComparator(int sortFlags) {
        Comparator<PeerState> rv = null;
        switch (Math.abs(sortFlags)) {
            case 1: {
                rv = IdleInComparator.instance();
                break;
            }
            case 2: {
                rv = IdleOutComparator.instance();
                break;
            }
            case 3: {
                rv = RateInComparator.instance();
                break;
            }
            case 4: {
                rv = RateOutComparator.instance();
                break;
            }
            case 16: {
                rv = UptimeComparator.instance();
                break;
            }
            case 5: {
                rv = SkewComparator.instance();
                break;
            }
            case 6: {
                rv = CwndComparator.instance();
                break;
            }
            case 7: {
                rv = SsthreshComparator.instance();
                break;
            }
            case 8: {
                rv = RTTComparator.instance();
                break;
            }
            case 10: {
                rv = RTOComparator.instance();
                break;
            }
            case 11: {
                rv = MTUComparator.instance();
                break;
            }
            case 12: {
                rv = SendCountComparator.instance();
                break;
            }
            case 13: {
                rv = RecvCountComparator.instance();
                break;
            }
            case 14: {
                rv = ResendComparator.instance();
                break;
            }
            case 15: {
                rv = DupComparator.instance();
                break;
            }
            default: {
                rv = AlphaComparator.instance();
            }
        }
        if (sortFlags < 0) {
            rv = Collections.reverseOrder(rv);
        }
        return rv;
    }

    private static void appendSortLinks(StringBuilder buf, String urlBase, int sortFlags, String descr, int ascending) {
        if (ascending == 0) {
            buf.append(" <a href=\"").append(urlBase).append("?sort=0#udpcon\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></a>");
        } else if (sortFlags == ascending) {
            buf.append(" <a href=\"").append(urlBase).append("?sort=").append(0 - ascending);
            buf.append("#udpcon\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></a><b><img src=\"/themes/console/images/outbound.png\" alt=\"^\"></b>");
        } else if (sortFlags == 0 - ascending) {
            buf.append(" <b><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></b><a href=\"").append(urlBase).append("?sort=").append(ascending);
            buf.append("#udpcon\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/outbound.png\" alt=\"^\"></a>");
        } else {
            buf.append(" <a href=\"").append(urlBase).append("?sort=").append(0 - ascending);
            buf.append("#udpcon\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></a><a href=\"").append(urlBase).append("?sort=").append(ascending);
            buf.append("#udpcon\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/outbound.png\" alt=\"^\"></a>");
        }
    }

    @Override
    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet<PeerState> peers = new TreeSet<PeerState>(UDPTransport.getComparator(sortFlags));
        peers.addAll(this._peersByIdent.values());
        long offsetTotal = 0L;
        int bpsIn = 0;
        int bpsOut = 0;
        long uptimeMsTotal = 0L;
        long cwinTotal = 0L;
        long rttTotal = 0L;
        long rtoTotal = 0L;
        long sendTotal = 0L;
        long recvTotal = 0L;
        long resentTotal = 0L;
        long dupRecvTotal = 0L;
        int numPeers = 0;
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3 id=\"udpcon\">").append(this._("UDP connections")).append(": ").append(peers.size());
        buf.append(". ").append(this._("Limit")).append(": ").append(this.getMaxConnections());
        buf.append(". ").append(this._("Timeout")).append(": ").append(DataHelper.formatDuration2((long)this._expireTimeout));
        buf.append(".</h3>\n");
        buf.append("<table>\n");
        buf.append("<tr><th class=\"smallhead\" nowrap><a href=\"#def.peer\">").append(this._("Peer")).append("</a><br>");
        if (sortFlags != 0) {
            UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by peer hash"), 0);
        }
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.dir\" title=\"").append(this._("Direction/Introduction")).append("\">").append(this._("Dir")).append("</a></th><th class=\"smallhead\" nowrap><a href=\"#def.ipv6\">").append(this._("IPv6")).append("</a></th><th class=\"smallhead\" nowrap><a href=\"#def.idle\">").append(this._("Idle")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by idle inbound"), 1);
        buf.append(THINSP);
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by idle outbound"), 2);
        buf.append("</th>");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.rate\">").append(this._("In/Out")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by inbound rate"), 3);
        buf.append(THINSP);
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by outbound rate"), 4);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.up\">").append(this._("Up")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by connection uptime"), 16);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.skew\">").append(this._("Skew")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by clock skew"), 5);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.cwnd\">CWND</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by congestion window"), 6);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.ssthresh\">SST</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by slow start threshold"), 7);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.rtt\">RTT</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by round trip time"), 8);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.rto\">RTO</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by retransmission timeout"), 10);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.mtu\">MTU</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by outbound maximum transmit unit"), 11);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.send\">").append(this._("TX")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by packets sent"), 12);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.recv\">").append(this._("RX")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by packets received"), 13);
        buf.append("</th>\n");
        buf.append("<th class=\"smallhead\" nowrap><a href=\"#def.resent\">").append(this._("Dup TX")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by packets retransmitted"), 14);
        buf.append("</th><th class=\"smallhead\" nowrap><a href=\"#def.dupRecv\">").append(this._("Dup RX")).append("</a><br>");
        UDPTransport.appendSortLinks(buf, urlBase, sortFlags, this._("Sort by packets received more than once"), 15);
        buf.append("</th></tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        long now = this._context.clock().now();
        for (PeerState peer : peers) {
            int cfs;
            if (now - peer.getLastReceiveTime() > 3600000L) continue;
            buf.append("<tr><td class=\"cells\" align=\"left\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(peer.getRemotePeer()));
            buf.append("</td><td class=\"cells\" nowrap align=\"left\">");
            if (peer.isInbound()) {
                buf.append("<img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"").append(this._("Inbound")).append("\">");
            } else {
                buf.append("<img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"").append(this._("Outbound")).append("\">");
            }
            if (peer.getWeRelayToThemAs() > 0L) {
                buf.append("&nbsp;&nbsp;<img src=\"/themes/console/images/outbound.png\" height=\"8\" width=\"12\" alt=\"^\" title=\"").append(this._("We offered to introduce them")).append("\">");
            }
            if (peer.getTheyRelayToUsAs() > 0L) {
                buf.append("&nbsp;&nbsp;<img src=\"/themes/console/images/inbound.png\" height=\"8\" width=\"12\" alt=\"V\" title=\"").append(this._("They offered to introduce us")).append("\">");
            }
            boolean appended = false;
            if (this._activeThrottle.isChoked(peer.getRemotePeer())) {
                buf.append("<br><i>").append(this._("Choked")).append("</i>");
                appended = true;
            }
            if ((cfs = peer.getConsecutiveFailedSends()) > 0) {
                if (!appended) {
                    buf.append("<br>");
                }
                buf.append(" <i>");
                if (cfs == 1) {
                    buf.append(this._("1 fail"));
                } else {
                    buf.append(this._("{0} fails", cfs));
                }
                buf.append("</i>");
                appended = true;
            }
            if (this._context.banlist().isBanlisted(peer.getRemotePeer(), STYLE)) {
                if (!appended) {
                    buf.append("<br>");
                }
                buf.append(" <i>").append(this._("Banned")).append("</i>");
                appended = true;
            }
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"center\">");
            if (peer.isIPv6()) {
                buf.append("&#x2713;");
            } else {
                buf.append("&nbsp;");
            }
            buf.append("</td>");
            long idleIn = Math.max(now - peer.getLastReceiveTime(), 0L);
            long idleOut = Math.max(now - peer.getLastSendTime(), 0L);
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2((long)idleIn));
            buf.append(THINSP);
            buf.append(DataHelper.formatDuration2((long)idleOut));
            buf.append("</td>");
            int recvBps = idleIn > 15000L ? 0 : peer.getReceiveBps();
            int sendBps = idleOut > 15000L ? 0 : peer.getSendBps();
            buf.append("<td class=\"cells\" align=\"right\" nowrap>");
            buf.append(UDPTransport.formatKBps(recvBps));
            buf.append(THINSP);
            buf.append(UDPTransport.formatKBps(sendBps));
            buf.append("</td>");
            long uptime = now - peer.getKeyEstablishedTime();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2((long)uptime));
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            long skew = peer.getClockSkew();
            buf.append(DataHelper.formatDuration2((long)skew));
            buf.append("</td>");
            offsetTotal += skew;
            long sendWindow = peer.getSendWindowBytes();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(sendWindow / 1024L);
            buf.append("K");
            buf.append(THINSP).append(peer.getConcurrentSends());
            buf.append(THINSP).append(peer.getConcurrentSendWindow());
            buf.append(THINSP).append(peer.getConsecutiveSendRejections());
            if (peer.isBacklogged()) {
                buf.append(' ').append(this._("backlogged"));
            }
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(peer.getSlowStartThreshold() / 1024);
            buf.append("K</td>");
            int rtt = peer.getRTT();
            int rto = peer.getRTO();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2((long)rtt));
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2((long)rto));
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(peer.getMTU()).append(THINSP).append(peer.getReceiveMTU());
            buf.append("</td>");
            long sent = peer.getPacketsTransmitted();
            long recv = peer.getPacketsReceived();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(sent);
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(recv);
            buf.append("</td>");
            long resent = peer.getPacketsRetransmitted();
            long dupRecv = peer.getPacketsReceivedDuplicate();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(resent);
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(dupRecv);
            buf.append("</td>");
            buf.append("</tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
            bpsIn += recvBps;
            bpsOut += sendBps;
            uptimeMsTotal += uptime;
            cwinTotal += sendWindow;
            rttTotal += (long)rtt;
            rtoTotal += (long)rto;
            sendTotal += sent;
            recvTotal += recv;
            resentTotal += resent;
            dupRecvTotal += dupRecv;
            ++numPeers;
        }
        if (numPeers > 0) {
            buf.append("<tr class=\"tablefooter\"><td colspan=\"4\" align=\"left\"><b>").append(this._("SUMMARY")).append("</b></td><td align=\"center\" nowrap><b>");
            buf.append(UDPTransport.formatKBps(bpsIn)).append(THINSP).append(UDPTransport.formatKBps(bpsOut));
            long x = uptimeMsTotal / (long)numPeers;
            buf.append("</b></td><td align=\"center\"><b>").append(DataHelper.formatDuration2((long)x));
            x = offsetTotal / (long)numPeers;
            buf.append("</b></td><td align=\"center\"><b>").append(DataHelper.formatDuration2((long)x)).append("</b></td>\n<td align=\"center\"><b>");
            buf.append(cwinTotal / (long)(numPeers * 1024) + "K");
            buf.append("</b></td><td>&nbsp;</td>\n<td align=\"center\"><b>");
            buf.append(DataHelper.formatDuration2((long)(rttTotal / (long)numPeers)));
            buf.append("</b></td><td align=\"center\"><b>");
            buf.append(DataHelper.formatDuration2((long)(rtoTotal / (long)numPeers)));
            buf.append("</b></td><td align=\"center\"><b>").append(this._mtu).append("</b></td><td align=\"center\"><b>");
            buf.append(sendTotal).append("</b></td><td align=\"center\"><b>").append(recvTotal).append("</b></td>\n<td align=\"center\"><b>").append(resentTotal);
            buf.append("</b></td><td align=\"center\"><b>").append(dupRecvTotal).append("</b></td></tr>\n");
            if (sortFlags == 99) {
                buf.append("<tr><td colspan=\"16\">");
                buf.append("peersByIdent: ").append(this._peersByIdent.size());
                buf.append(" peersByRemoteHost: ").append(this._peersByRemoteHost.size());
                int dir = 0;
                int indir = 0;
                for (RemoteHostId rhi : this._peersByRemoteHost.keySet()) {
                    if (rhi.getIP() != null) {
                        ++dir;
                        continue;
                    }
                    ++indir;
                }
                buf.append(" pBRH direct: ").append(dir).append(" indirect: ").append(indir);
                buf.append("</td></tr>");
            }
        }
        buf.append("</table>\n");
        out.write(buf.toString());
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String formatKBps(int bps) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format((float)bps / 1024.0f);
        }
    }

    private final String _(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private final String _(String s, Object o) {
        return Translate.getString((String)s, (Object)o, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    void setReachabilityStatus(short status) {
        short old = this._reachabilityStatus;
        long now = this._context.clock().now();
        switch (status) {
            case 0: {
                this._context.statManager().addRateData("udp.statusOK", 1L);
                this._reachabilityStatus = status;
                this._reachabilityStatusLastUpdated = now;
                break;
            }
            case 1: {
                this._context.statManager().addRateData("udp.statusDifferent", 1L);
                this._reachabilityStatus = status;
                this._reachabilityStatusLastUpdated = now;
                break;
            }
            case 2: {
                this._context.statManager().addRateData("udp.statusReject", 1L);
            }
            case 3: 
            case 4: {
                this._reachabilityStatus = status;
                this._reachabilityStatusLastUpdated = now;
                break;
            }
            default: {
                this._context.statManager().addRateData("udp.statusUnknown", 1L);
            }
        }
        if (status != old && status != 5) {
            if (this._log.shouldLog(20)) {
                this._log.info("Old status: " + old + " New status: " + status + " from: ", (Throwable)new Exception("traceback"));
            }
            this.rebuildExternalAddress();
        }
    }

    @Override
    public short getReachabilityStatus() {
        String override = this._context.getProperty(PROP_REACHABILITY_STATUS_OVERRIDE);
        if (override == null) {
            return this._reachabilityStatus;
        }
        if ("ok".equals(override)) {
            return 0;
        }
        if ("err-reject".equals(override)) {
            return 2;
        }
        if ("err-different".equals(override)) {
            return 1;
        }
        return this._reachabilityStatus;
    }

    @Override
    public void recheckReachability() {
        this._testEvent.runTest();
    }

    PeerState pickTestPeer(PeerTestState.Role peerRole, RemoteHostId dontInclude) {
        if (peerRole == PeerTestState.Role.ALICE) {
            throw new IllegalArgumentException();
        }
        ArrayList<PeerState> peers = new ArrayList<PeerState>(this._peersByIdent.values());
        RandomIterator<PeerState> iter = new RandomIterator<PeerState>(peers);
        while (iter.hasNext()) {
            RouterAddress addr;
            RouterInfo peerInfo;
            PeerState peer = (PeerState)iter.next();
            if (dontInclude != null && dontInclude.equals(peer.getRemoteHostId())) continue;
            byte[] ip = peer.getRemoteIP();
            if (peerRole == PeerTestState.Role.BOB && ip.length != 4 || (peerInfo = this._context.netDb().lookupRouterInfoLocally(peer.getRemotePeer())) == null) continue;
            ip = null;
            List<RouterAddress> addrs = this.getTargetAddresses(peerInfo);
            Iterator<RouterAddress> i$ = addrs.iterator();
            while (i$.hasNext() && ((ip = (addr = i$.next()).getIP()) == null || ip.length != 4)) {
            }
            if (ip == null || this.isTooClose(ip)) continue;
            return peer;
        }
        return null;
    }

    private boolean shouldTest() {
        return !this._context.router().isHidden();
    }

    private class PingIntroducers
    implements SimpleTimer.TimedEvent {
        private PingIntroducers() {
        }

        public void timeReached() {
            if (UDPTransport.this.introducersRequired()) {
                UDPTransport.this._introManager.pingIntroducers();
            }
        }
    }

    private class PeerTestEvent
    extends SimpleTimer2.TimedEvent {
        private volatile boolean _alive;
        private long _lastTested;
        private boolean _forceRun;

        PeerTestEvent() {
            super(UDPTransport.this._context.simpleTimer2());
        }

        public void timeReached() {
            if (UDPTransport.this.shouldTest()) {
                long now = UDPTransport.this._context.clock().now();
                if (this._forceRun || now - this._lastTested >= 780000L) {
                    this.runTest();
                }
            }
            if (this._alive) {
                long delay = 390000 + UDPTransport.this._context.random().nextInt(780000);
                if (delay <= 0L) {
                    throw new RuntimeException("wtf, delay is " + delay);
                }
                this.schedule(delay);
            }
        }

        private void runTest() {
            PeerState bob = UDPTransport.this.pickTestPeer(PeerTestState.Role.BOB, null);
            if (bob != null) {
                if (UDPTransport.this._log.shouldLog(20)) {
                    UDPTransport.this._log.info("Running periodic test with bob = " + bob);
                }
                UDPTransport.this._testManager.runTest(bob.getRemoteIPAddress(), bob.getRemotePort(), bob.getCurrentCipherKey(), bob.getCurrentMACKey());
                this._lastTested = UDPTransport.this._context.clock().now();
                this._forceRun = false;
                return;
            }
            if (UDPTransport.this._log.shouldLog(30)) {
                UDPTransport.this._log.warn("Unable to run a periodic test, as there are no peers with the capacity required");
            }
            this._forceRun = false;
        }

        void forceRun() {
            this._forceRun = true;
        }

        public void setIsAlive(boolean isAlive) {
            this._alive = isAlive;
            if (isAlive) {
                long delay = UDPTransport.this._context.random().nextInt(1560000);
                this.reschedule(delay);
            } else {
                this.cancel();
            }
        }
    }

    private class ExpirePeerEvent
    extends SimpleTimer2.TimedEvent {
        private final Set<PeerState> _expirePeers;
        private final List<PeerState> _expireBuffer;
        private volatile boolean _alive;
        private int _runCount;
        private static final long PING_FIREWALL_TIME = 30000L;
        private static final long PING_FIREWALL_CUTOFF = 15000L;
        private static final int SLICES = 4;
        private static final long SHORT_LOOP_TIME = 3000L;
        private static final long LONG_LOOP_TIME = 25000L;

        public ExpirePeerEvent() {
            super(UDPTransport.this._context.simpleTimer2());
            this._expirePeers = new ConcurrentHashSet(128);
            this._expireBuffer = new ArrayList<PeerState>();
        }

        public void timeReached() {
            if (UDPTransport.this.haveCapacity()) {
                UDPTransport.this._expireTimeout = Math.min(UDPTransport.this._expireTimeout + 15000, 1200000);
            } else {
                UDPTransport.this._expireTimeout = Math.max(UDPTransport.this._expireTimeout - 45000, 270000);
            }
            long now = UDPTransport.this._context.clock().now();
            long shortInactivityCutoff = now - (long)UDPTransport.this._expireTimeout;
            long longInactivityCutoff = now - 1200000L;
            long pingCutoff = now - 0x6DDD00L;
            long pingFirewallCutoff = now - 15000L;
            boolean shouldPingFirewall = UDPTransport.this._reachabilityStatus != 0;
            int currentListenPort = UDPTransport.this.getListenPort(false);
            boolean pingOneOnly = shouldPingFirewall && UDPTransport.this.getExternalPort(false) == currentListenPort;
            boolean shortLoop = shouldPingFirewall;
            this._expireBuffer.clear();
            ++this._runCount;
            Iterator<PeerState> iter = this._expirePeers.iterator();
            while (iter.hasNext()) {
                PeerState peer = iter.next();
                long inactivityCutoff = peer.getWeRelayToThemAs() > 0L || peer.getIntroducerTime() > pingCutoff ? longInactivityCutoff : shortInactivityCutoff;
                if (peer.getLastReceiveTime() < inactivityCutoff && peer.getLastSendTime() < inactivityCutoff) {
                    this._expireBuffer.add(peer);
                    iter.remove();
                    continue;
                }
                if (!shouldPingFirewall || ((this._runCount ^ peer.hashCode()) & 3) != 0 || peer.getLastSendOrPingTime() >= pingFirewallCutoff || peer.getLastReceiveTime() >= pingFirewallCutoff) continue;
                if (UDPTransport.this._log.shouldLog(10)) {
                    UDPTransport.this._log.debug("Pinging for firewall: " + peer);
                }
                UDPTransport.this.send(UDPTransport.this._destroyBuilder.buildPing(peer));
                peer.setLastPingTime(now);
                if (!pingOneOnly) continue;
                shouldPingFirewall = false;
            }
            for (PeerState peer : this._expireBuffer) {
                UDPTransport.this.sendDestroy(peer);
                UDPTransport.this.dropPeer(peer, false, "idle too long");
            }
            this._expireBuffer.clear();
            if (this._alive) {
                this.schedule(shortLoop ? 3000L : 25000L);
            }
        }

        public void add(PeerState peer) {
            this._expirePeers.add(peer);
        }

        public void remove(PeerState peer) {
            this._expirePeers.remove(peer);
        }

        public void setIsAlive(boolean isAlive) {
            this._alive = isAlive;
            if (isAlive) {
                this.reschedule(25000L);
            } else {
                this.cancel();
                this._expirePeers.clear();
            }
        }
    }

    private class SharedBid
    extends TransportBid {
        public SharedBid(int ms) {
            this.setLatencyMs(ms);
        }

        public Transport getTransport() {
            return UDPTransport.this;
        }

        public String toString() {
            return "UDP bid @ " + this.getLatencyMs();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PeerComparator
    implements Comparator<PeerState> {
        private PeerComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            return DataHelper.compareTo((byte[])l.getRemotePeer().getData(), (byte[])r.getRemotePeer().getData());
        }
    }

    private static class DupComparator
    extends PeerComparator {
        private static final DupComparator _instance = new DupComparator();

        private DupComparator() {
        }

        public static final DupComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsReceivedDuplicate() - r.getPacketsReceivedDuplicate();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class ResendComparator
    extends PeerComparator {
        private static final ResendComparator _instance = new ResendComparator();

        private ResendComparator() {
        }

        public static final ResendComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsRetransmitted() - r.getPacketsRetransmitted();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RecvCountComparator
    extends PeerComparator {
        private static final RecvCountComparator _instance = new RecvCountComparator();

        private RecvCountComparator() {
        }

        public static final RecvCountComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsReceived() - r.getPacketsReceived();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class SendCountComparator
    extends PeerComparator {
        private static final SendCountComparator _instance = new SendCountComparator();

        private SendCountComparator() {
        }

        public static final SendCountComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsTransmitted() - r.getPacketsTransmitted();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class MTUComparator
    extends PeerComparator {
        private static final MTUComparator _instance = new MTUComparator();

        private MTUComparator() {
        }

        public static final MTUComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            int rv = l.getMTU() - r.getMTU();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    private static class RTOComparator
    extends PeerComparator {
        private static final RTOComparator _instance = new RTOComparator();

        private RTOComparator() {
        }

        public static final RTOComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            int rv = l.getRTO() - r.getRTO();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    private static class RTTComparator
    extends PeerComparator {
        private static final RTTComparator _instance = new RTTComparator();

        private RTTComparator() {
        }

        public static final RTTComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            int rv = l.getRTT() - r.getRTT();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    private static class SsthreshComparator
    extends PeerComparator {
        private static final SsthreshComparator _instance = new SsthreshComparator();

        private SsthreshComparator() {
        }

        public static final SsthreshComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            int rv = l.getSlowStartThreshold() - r.getSlowStartThreshold();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    private static class CwndComparator
    extends PeerComparator {
        private static final CwndComparator _instance = new CwndComparator();

        private CwndComparator() {
        }

        public static final CwndComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            int rv = l.getSendWindowBytes() - r.getSendWindowBytes();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    private static class SkewComparator
    extends PeerComparator {
        private static final SkewComparator _instance = new SkewComparator();

        private SkewComparator() {
        }

        public static final SkewComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            long rv = Math.abs(l.getClockSkew()) - Math.abs(r.getClockSkew());
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class UptimeComparator
    extends PeerComparator {
        private static final UptimeComparator _instance = new UptimeComparator();

        private UptimeComparator() {
        }

        public static final UptimeComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            long rv = r.getKeyEstablishedTime() - l.getKeyEstablishedTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class RateOutComparator
    extends PeerComparator {
        private static final RateOutComparator _instance = new RateOutComparator();

        private RateOutComparator() {
        }

        public static final RateOutComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            int rv = l.getSendBps() - r.getSendBps();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    private static class RateInComparator
    extends PeerComparator {
        private static final RateInComparator _instance = new RateInComparator();

        private RateInComparator() {
        }

        public static final RateInComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            int rv = l.getReceiveBps() - r.getReceiveBps();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    private static class IdleOutComparator
    extends PeerComparator {
        private static final IdleOutComparator _instance = new IdleOutComparator();

        private IdleOutComparator() {
        }

        public static final IdleOutComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            long rv = r.getLastSendTime() - l.getLastSendTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class IdleInComparator
    extends PeerComparator {
        private static final IdleInComparator _instance = new IdleInComparator();

        private IdleInComparator() {
        }

        public static final IdleInComparator instance() {
            return _instance;
        }

        public int compare(PeerState l, PeerState r) {
            long rv = r.getLastReceiveTime() - l.getLastReceiveTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    private static class AlphaComparator
    extends PeerComparator {
        private static final AlphaComparator _instance = new AlphaComparator();

        private AlphaComparator() {
        }

        public static final AlphaComparator instance() {
            return _instance;
        }
    }

    private class RemoveDropList
    implements SimpleTimer.TimedEvent {
        private final RemoteHostId _peer;

        public RemoveDropList(RemoteHostId peer) {
            this._peer = peer;
        }

        public void timeReached() {
            UDPTransport.this._dropList.remove(this._peer);
        }
    }
}

