/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import net.i2p.data.Base64;
import net.i2p.data.RouterAddress;
import net.i2p.router.transport.udp.MTU;
import net.i2p.util.LHMCache;

class UDPAddress {
    private final String _host;
    private InetAddress _hostAddress;
    private final int _port;
    private byte[] _introKey;
    private String[] _introHosts;
    private InetAddress[] _introAddresses;
    private int[] _introPorts;
    private byte[][] _introKeys;
    private long[] _introTags;
    private int _mtu;
    public static final String PROP_PORT = "port";
    public static final String PROP_HOST = "host";
    public static final String PROP_INTRO_KEY = "key";
    public static final String PROP_MTU = "mtu";
    public static final String PROP_CAPACITY = "caps";
    public static final char CAPACITY_TESTING = 'B';
    public static final char CAPACITY_INTRODUCER = 'C';
    public static final String PROP_INTRO_HOST_PREFIX = "ihost";
    public static final String PROP_INTRO_PORT_PREFIX = "iport";
    public static final String PROP_INTRO_KEY_PREFIX = "ikey";
    public static final String PROP_INTRO_TAG_PREFIX = "itag";
    static final int MAX_INTRODUCERS = 3;
    private static final String[] PROP_INTRO_HOST = new String[3];
    private static final String[] PROP_INTRO_PORT = new String[3];
    private static final String[] PROP_INTRO_IKEY = new String[3];
    private static final String[] PROP_INTRO_TAG = new String[3];
    private static final Map<String, InetAddress> _inetAddressCache;

    public UDPAddress(RouterAddress addr) {
        byte[] ik;
        if (addr == null) {
            this._host = null;
            this._port = 0;
            return;
        }
        this._host = addr.getOption(PROP_HOST);
        this._port = addr.getPort();
        try {
            String mtu = addr.getOption(PROP_MTU);
            if (mtu != null) {
                boolean isIPv6 = this._host != null && this._host.contains(":");
                this._mtu = MTU.rectify(isIPv6, Integer.parseInt(mtu));
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String key = addr.getOption(PROP_INTRO_KEY);
        if (key != null && (ik = Base64.decode((String)key.trim())) != null && ik.length == 32) {
            this._introKey = ik;
        }
        for (int i = 2; i >= 0; --i) {
            long tag;
            int p;
            String t;
            byte[] ikey;
            String k;
            String port;
            String host = addr.getOption(PROP_INTRO_HOST[i]);
            if (host == null || (port = addr.getOption(PROP_INTRO_PORT[i])) == null || (k = addr.getOption(PROP_INTRO_IKEY[i])) == null || (ikey = Base64.decode((String)k)) == null || ikey.length != 32 || (t = addr.getOption(PROP_INTRO_TAG[i])) == null) continue;
            try {
                p = Integer.parseInt(port);
                if (p < 1024) continue;
                if (p > 65535) {
                }
            }
            catch (NumberFormatException nfe) {}
            continue;
            try {
                tag = Long.parseLong(t);
                if (tag <= 0L) {
                }
            }
            catch (NumberFormatException nfe) {}
            continue;
            if (this._introHosts == null) {
                this._introHosts = new String[i + 1];
                this._introPorts = new int[i + 1];
                this._introAddresses = new InetAddress[i + 1];
                this._introKeys = new byte[i + 1][];
                this._introTags = new long[i + 1];
            }
            this._introHosts[i] = host;
            this._introPorts[i] = p;
            this._introKeys[i] = ikey;
            this._introTags[i] = tag;
        }
        int numOK = 0;
        if (this._introHosts != null) {
            for (int i = 0; i < this._introHosts.length; ++i) {
                if (this._introKeys[i] == null || this._introPorts[i] <= 0 || this._introTags[i] <= 0L || this._introHosts[i] == null) continue;
                ++numOK;
            }
            if (numOK != this._introHosts.length) {
                String[] hosts = new String[numOK];
                int[] ports = new int[numOK];
                long[] tags = new long[numOK];
                byte[][] keys = new byte[numOK][];
                int cur = 0;
                for (int i = 0; i < this._introHosts.length; ++i) {
                    if (this._introKeys[i] == null || this._introPorts[i] <= 0 || this._introTags[i] <= 0L || this._introHosts[i] == null) continue;
                    hosts[cur] = this._introHosts[i];
                    ports[cur] = this._introPorts[i];
                    tags[cur] = this._introTags[i];
                    keys[cur] = this._introKeys[i];
                }
                this._introKeys = keys;
                this._introTags = tags;
                this._introPorts = ports;
                this._introHosts = hosts;
                this._introAddresses = new InetAddress[numOK];
            }
        }
    }

    public String getHost() {
        return this._host;
    }

    InetAddress getHostAddress() {
        if (this._hostAddress == null) {
            this._hostAddress = UDPAddress.getByName(this._host);
        }
        return this._hostAddress;
    }

    public int getPort() {
        return this._port;
    }

    byte[] getIntroKey() {
        return this._introKey;
    }

    int getIntroducerCount() {
        return this._introAddresses == null ? 0 : this._introAddresses.length;
    }

    InetAddress getIntroducerHost(int i) {
        if (this._introAddresses[i] == null) {
            this._introAddresses[i] = UDPAddress.getByName(this._introHosts[i]);
        }
        return this._introAddresses[i];
    }

    int getIntroducerPort(int i) {
        return this._introPorts[i];
    }

    byte[] getIntroducerKey(int i) {
        return this._introKeys[i];
    }

    long getIntroducerTag(int i) {
        return this._introTags[i];
    }

    int getMTU() {
        return this._mtu;
    }

    public String toString() {
        StringBuilder rv = new StringBuilder(64);
        if (this._introHosts != null) {
            for (int i = 0; i < this._introHosts.length; ++i) {
                rv.append("ssu://");
                rv.append(this._introTags[i]).append('@');
                rv.append(this._introHosts[i]).append(':').append(this._introPorts[i]);
                if (i + 1 >= this._introKeys.length) continue;
                rv.append(", ");
            }
        } else if (this._host != null && this._port > 0) {
            rv.append("ssu://").append(this._host).append(':').append(this._port);
        } else {
            rv.append("ssu://autodetect.not.yet.complete:").append(this._port);
        }
        return rv.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getByName(String host) {
        InetAddress rv;
        block11: {
            if (host == null) {
                return null;
            }
            Map<String, InetAddress> map = _inetAddressCache;
            synchronized (map) {
                rv = _inetAddressCache.get(host);
            }
            if (rv == null) {
                try {
                    boolean isIPv4;
                    boolean bl = isIPv4 = host.replaceAll("[0-9\\.]", "").length() == 0;
                    if (isIPv4 && host.replaceAll("[0-9]", "").length() != 3) {
                        return null;
                    }
                    rv = InetAddress.getByName(host);
                    if (!isIPv4 && host.replaceAll("[0-9a-fA-F:]", "").length() != 0) break block11;
                    Map<String, InetAddress> map2 = _inetAddressCache;
                    synchronized (map2) {
                        _inetAddressCache.put(host, rv);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        Map<String, InetAddress> map = _inetAddressCache;
        synchronized (map) {
            _inetAddressCache.clear();
        }
    }

    static {
        for (int i = 0; i < 3; ++i) {
            UDPAddress.PROP_INTRO_HOST[i] = PROP_INTRO_HOST_PREFIX + i;
            UDPAddress.PROP_INTRO_PORT[i] = PROP_INTRO_PORT_PREFIX + i;
            UDPAddress.PROP_INTRO_IKEY[i] = PROP_INTRO_KEY_PREFIX + i;
            UDPAddress.PROP_INTRO_TAG[i] = PROP_INTRO_TAG_PREFIX + i;
        }
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x6000000L;
        }
        long min = 128L;
        long max = 2048L;
        int size = (int)Math.max(min, Math.min(max, 1L + maxMemory / 262144L));
        _inetAddressCache = new LHMCache(size);
    }
}

