/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.InboundMessageFragments;
import net.i2p.router.transport.udp.IntroductionManager;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerTestManager;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.util.CoDelBlockingQueue;
import net.i2p.util.I2PThread;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;

class PacketHandler {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final EstablishmentManager _establisher;
    private final InboundMessageFragments _inbound;
    private final PeerTestManager _testManager;
    private final IntroductionManager _introManager;
    private volatile boolean _keepReading;
    private final Handler[] _handlers;
    private final Map<RemoteHostId, Object> _failCache;
    private final BlockingQueue<UDPPacket> _inboundQueue;
    private static final Object DUMMY = new Object();
    private static final int TYPE_POISON = -99999;
    private static final int MIN_QUEUE_SIZE = 16;
    private static final int MAX_QUEUE_SIZE = 192;
    private static final int MIN_NUM_HANDLERS = 1;
    private static final int MAX_NUM_HANDLERS = 1;
    private static final long GRACE_PERIOD = 90000L;
    private static final short OUTBOUND_FALLBACK = 1;
    private static final short INBOUND_FALLBACK = 2;
    private static final short NEW_PEER = 3;

    PacketHandler(RouterContext ctx, UDPTransport transport, EstablishmentManager establisher, InboundMessageFragments inbound, PeerTestManager testManager, IntroductionManager introManager) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(PacketHandler.class);
        this._transport = transport;
        this._establisher = establisher;
        this._inbound = inbound;
        this._testManager = testManager;
        this._introManager = introManager;
        this._failCache = new LHMCache(24);
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x6000000L;
        }
        int qsize = (int)Math.max(16L, Math.min(192L, maxMemory / 0x200000L));
        this._inboundQueue = new CoDelBlockingQueue<UDPPacket>(ctx, "UDP-Receiver", qsize);
        int num_handlers = maxMemory < 0x2000000L ? 1 : (maxMemory < 0x4000000L ? 2 : Math.max(1, Math.min(1, ctx.bandwidthLimiter().getInboundKBytesPerSecond() / 20)));
        this._handlers = new Handler[num_handlers];
        for (int i = 0; i < num_handlers; ++i) {
            this._handlers[i] = new Handler();
        }
        this._context.statManager().createRateStat("udp.handleTime", "How long it takes to handle a received packet after its been pulled off the queue", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.queueTime", "How long after a packet is received can we begin handling it", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSkew", "How long ago after the packet was sent did we receive it", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidUnkown", "How old the packet we dropped due to invalidity (unkown type) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidReestablish", "How old the packet we dropped due to invalidity (doesn't use existing key, not an establishment) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish", "How old the packet we dropped due to invalidity (establishment, bad key) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish.inbound", "How old the packet we dropped due to invalidity (even though we have an active inbound establishment with the peer) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish.outbound", "How old the packet we dropped due to invalidity (even though we have an active outbound establishment with the peer) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidEstablish.new", "How old the packet we dropped due to invalidity (even though we do not have any active establishment with the peer) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidInboundEstablish", "How old the packet we dropped due to invalidity (inbound establishment, bad key) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInvalidSkew", "How skewed the packet we dropped due to invalidity (valid except bad skew) was", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataKnown", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataKnownAck", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataUnknown", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receivePacketSize.dataUnknownAck", "Packet size of the given inbound packet type (period is the packet's lifetime)", "udp", UDPTransport.RATES);
    }

    public synchronized void startup() {
        this._keepReading = true;
        for (int i = 0; i < this._handlers.length; ++i) {
            I2PThread t = new I2PThread((Runnable)this._handlers[i], "UDP Packet handler " + (i + 1) + '/' + this._handlers.length, true);
            t.start();
        }
    }

    public synchronized void shutdown() {
        this._keepReading = false;
        this.stopQueue();
    }

    String getHandlerStatus() {
        StringBuilder rv = new StringBuilder();
        rv.append("Handlers: ").append(this._handlers.length);
        for (int i = 0; i < this._handlers.length; ++i) {
            Handler handler = this._handlers[i];
            rv.append(" handler ").append(i).append(" state: ").append(handler._state);
        }
        return rv.toString();
    }

    public void queueReceived(UDPPacket packet) throws InterruptedException {
        this._inboundQueue.put(packet);
    }

    private void stopQueue() {
        int i;
        this._inboundQueue.clear();
        for (i = 0; i < this._handlers.length; ++i) {
            UDPPacket poison = UDPPacket.acquire(this._context, false);
            poison.setMessageType(-99999);
            this._inboundQueue.offer(poison);
        }
        for (i = 1; i <= 5 && !this._inboundQueue.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 50);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._inboundQueue.clear();
    }

    public UDPPacket receiveNext() {
        UDPPacket rv = null;
        while (this._keepReading && rv == null) {
            try {
                rv = this._inboundQueue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (rv == null || rv.getMessageType() != -99999) continue;
            return null;
        }
        return rv;
    }

    private class Handler
    implements Runnable {
        private final UDPPacketReader _reader;
        public int _state;

        public Handler() {
            this._reader = new UDPPacketReader(PacketHandler.this._context);
        }

        public void run() {
            this._state = 1;
            while (PacketHandler.this._keepReading) {
                long handleStart;
                long queueTime;
                UDPPacket packet;
                block4: {
                    this._state = 2;
                    packet = PacketHandler.this.receiveNext();
                    this._state = 3;
                    if (packet == null) break;
                    packet.received();
                    if (PacketHandler.this._log.shouldLog(10)) {
                        PacketHandler.this._log.debug("Received: " + packet);
                    }
                    this._state = 4;
                    queueTime = packet.getLifetime();
                    handleStart = PacketHandler.this._context.clock().now();
                    try {
                        this._state = 5;
                        this.handlePacket(this._reader, packet);
                        this._state = 6;
                    }
                    catch (Exception e) {
                        this._state = 7;
                        if (!PacketHandler.this._log.shouldLog(40)) break block4;
                        PacketHandler.this._log.error("Crazy error handling a packet: " + packet, (Throwable)e);
                    }
                }
                long handleTime = PacketHandler.this._context.clock().now() - handleStart;
                PacketHandler.this._context.statManager().addRateData("udp.handleTime", handleTime, packet.getLifetime());
                PacketHandler.this._context.statManager().addRateData("udp.queueTime", queueTime, packet.getLifetime());
                this._state = 8;
                packet.release();
                this._state = 9;
            }
        }

        private void handlePacket(UDPPacketReader reader, UDPPacket packet) {
            this._state = 10;
            RemoteHostId rem = packet.getRemoteHost();
            PeerState state = PacketHandler.this._transport.getPeerState(rem);
            if (state == null) {
                this._state = 11;
                InboundEstablishState est = PacketHandler.this._establisher.getInboundState(rem);
                if (est != null) {
                    if (PacketHandler.this._log.shouldLog(10)) {
                        PacketHandler.this._log.debug("Packet received IS for an inbound establishment");
                    }
                    this._state = 12;
                    this.receivePacket(reader, packet, est);
                } else {
                    this._state = 13;
                    OutboundEstablishState oest = PacketHandler.this._establisher.getOutboundState(rem);
                    if (oest != null) {
                        if (PacketHandler.this._log.shouldLog(10)) {
                            PacketHandler.this._log.debug("Packet received IS for an outbound establishment");
                        }
                        this._state = 14;
                        this.receivePacket(reader, packet, oest);
                    } else {
                        if (PacketHandler.this._log.shouldLog(10)) {
                            PacketHandler.this._log.debug("Packet received is not for an inbound or outbound establishment");
                        }
                        this._state = 15;
                        this.receivePacket(reader, packet, (short)3);
                    }
                }
            } else {
                if (PacketHandler.this._log.shouldLog(10)) {
                    PacketHandler.this._log.debug("Packet received IS for an existing peer");
                }
                this._state = 16;
                this.receivePacket(reader, packet, state);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void receivePacket(UDPPacketReader reader, UDPPacket packet, PeerState state) {
            boolean isStray;
            block11: {
                this._state = 17;
                isStray = false;
                boolean isValid = packet.validate(state.getCurrentMACKey());
                if (!isValid) {
                    this._state = 18;
                    if (state.getNextMACKey() != null) {
                        isValid = packet.validate(state.getNextMACKey());
                    }
                    if (!isValid) {
                        this._state = 19;
                        if (PacketHandler.this._log.shouldLog(20)) {
                            PacketHandler.this._log.info("Failed validation with existing con, trying as new con: " + packet);
                        }
                        if (isValid = packet.validate(PacketHandler.this._transport.getIntroKey())) {
                            this._state = 20;
                            if (PacketHandler.this._log.shouldLog(10)) {
                                PacketHandler.this._log.debug("Validation with existing con failed, but validation as reestablish/stray passed");
                            }
                            packet.decrypt(PacketHandler.this._transport.getIntroKey());
                            isStray = true;
                            break block11;
                        } else {
                            this._state = 21;
                            InboundEstablishState est = PacketHandler.this._establisher.getInboundState(packet.getRemoteHost());
                            if (est != null) {
                                if (PacketHandler.this._log.shouldLog(10)) {
                                    PacketHandler.this._log.debug("Packet from an existing peer IS for an inbound establishment");
                                }
                                this._state = 22;
                                this.receivePacket(reader, packet, est, false);
                                return;
                            }
                            if (PacketHandler.this._log.shouldLog(30)) {
                                PacketHandler.this._log.warn("Validation with existing con failed, and validation as reestablish failed too.  DROP " + packet);
                            }
                            PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidReestablish", packet.getLifetime(), packet.getExpiration());
                            return;
                        }
                    }
                    this._state = 23;
                    packet.decrypt(state.getNextCipherKey());
                } else {
                    this._state = 24;
                    packet.decrypt(state.getCurrentCipherKey());
                }
            }
            this._state = 25;
            this.handlePacket(reader, packet, state, null, null, !isStray);
            this._state = 26;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receivePacket(UDPPacketReader reader, UDPPacket packet, short peerType) {
            this._state = 27;
            boolean isValid = packet.validate(PacketHandler.this._transport.getIntroKey());
            if (!isValid) {
                boolean alreadyFailed;
                RemoteHostId remoteHost = packet.getRemoteHost();
                Map map = PacketHandler.this._failCache;
                synchronized (map) {
                    alreadyFailed = PacketHandler.this._failCache.get(remoteHost) != null;
                }
                if (!alreadyFailed) {
                    List<PeerState> peers = PacketHandler.this._transport.getPeerStatesByIP(remoteHost);
                    if (!peers.isEmpty()) {
                        StringBuilder buf = new StringBuilder(256);
                        buf.append("Established peers with this IP: ");
                        boolean foundSamePort = false;
                        PeerState state = null;
                        int newPort = remoteHost.getPort();
                        for (PeerState ps : peers) {
                            boolean valid = false;
                            long now = PacketHandler.this._context.clock().now();
                            if (PacketHandler.this._log.shouldLog(30)) {
                                buf.append(ps.getRemoteHostId().toString()).append(" last sent: ").append(now - ps.getLastSendTime()).append(" last rcvd: ").append(now - ps.getLastReceiveTime());
                            }
                            if (ps.getRemotePort() == newPort) {
                                foundSamePort = true;
                                continue;
                            }
                            if (packet.validate(ps.getCurrentMACKey())) {
                                packet.decrypt(ps.getCurrentCipherKey());
                                reader.initialize(packet);
                                if (PacketHandler.this._log.shouldLog(30)) {
                                    buf.append(" VALID type ").append(reader.readPayloadType()).append("; ");
                                }
                                valid = true;
                                if (state != null) continue;
                                state = ps;
                                continue;
                            }
                            if (!PacketHandler.this._log.shouldLog(30)) continue;
                            buf.append(" INVALID; ");
                        }
                        if (state != null && !foundSamePort) {
                            PacketHandler.this._transport.changePeerPort(state, newPort);
                            if (PacketHandler.this._log.shouldLog(30)) {
                                buf.append(" CHANGED PORT TO ").append(newPort).append(" AND HANDLED");
                                PacketHandler.this._log.warn(buf.toString());
                            }
                            this.handlePacket(reader, packet, state, null, null, true);
                            return;
                        }
                        if (PacketHandler.this._log.shouldLog(30)) {
                            PacketHandler.this._log.warn(buf.toString());
                        }
                    }
                    Map map2 = PacketHandler.this._failCache;
                    synchronized (map2) {
                        PacketHandler.this._failCache.put(remoteHost, DUMMY);
                    }
                }
                if (PacketHandler.this._log.shouldLog(30)) {
                    PacketHandler.this._log.warn("Cannot validate rcvd pkt (path) wasCached? " + alreadyFailed + ": " + packet);
                }
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish", packet.getLifetime(), packet.getExpiration());
                switch (peerType) {
                    case 2: {
                        PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish.inbound", packet.getLifetime(), packet.getTimeSinceReceived());
                        break;
                    }
                    case 1: {
                        PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish.outbound", packet.getLifetime(), packet.getTimeSinceReceived());
                        break;
                    }
                    case 3: {
                        PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidEstablish.new", packet.getLifetime(), packet.getTimeSinceReceived());
                    }
                }
                this._state = 28;
                return;
            }
            if (PacketHandler.this._log.shouldLog(10)) {
                PacketHandler.this._log.debug("Valid introduction packet received: " + packet);
            }
            this._state = 29;
            packet.decrypt(PacketHandler.this._transport.getIntroKey());
            this.handlePacket(reader, packet, null, null, null, false);
            this._state = 30;
        }

        private void receivePacket(UDPPacketReader reader, UDPPacket packet, InboundEstablishState state) {
            this.receivePacket(reader, packet, state, true);
        }

        private void receivePacket(UDPPacketReader reader, UDPPacket packet, InboundEstablishState state, boolean allowFallback) {
            this._state = 31;
            if (PacketHandler.this._log.shouldLog(10)) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("Attempting to receive a packet on a known inbound state: ");
                buf.append(state);
                buf.append(" MAC key: ").append(state.getMACKey());
                buf.append(" intro key: ").append(PacketHandler.this._transport.getIntroKey());
                PacketHandler.this._log.debug(buf.toString());
            }
            boolean isValid = false;
            if (state.getMACKey() != null) {
                isValid = packet.validate(state.getMACKey());
                if (isValid) {
                    if (PacketHandler.this._log.shouldLog(20)) {
                        PacketHandler.this._log.info("Valid introduction packet received for inbound con: " + packet);
                    }
                    this._state = 32;
                    packet.decrypt(state.getCipherKey());
                    this.handlePacket(reader, packet, null, null, null, true);
                    return;
                }
                if (PacketHandler.this._log.shouldLog(30)) {
                    PacketHandler.this._log.warn("Invalid introduction packet received for inbound con, falling back: " + packet);
                }
                this._state = 33;
            }
            if (allowFallback) {
                this._state = 34;
                this.receivePacket(reader, packet, (short)2);
            } else {
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidInboundEstablish", packet.getLifetime(), packet.getExpiration());
            }
        }

        private void receivePacket(UDPPacketReader reader, UDPPacket packet, OutboundEstablishState state) {
            this._state = 35;
            if (PacketHandler.this._log.shouldLog(10)) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("Attempting to receive a packet on a known outbound state: ");
                buf.append(state);
                buf.append(" MAC key: ").append(state.getMACKey());
                buf.append(" intro key: ").append(state.getIntroKey());
                PacketHandler.this._log.debug(buf.toString());
            }
            boolean isValid = false;
            if (state.getMACKey() != null) {
                this._state = 36;
                isValid = packet.validate(state.getMACKey());
                if (isValid) {
                    if (PacketHandler.this._log.shouldLog(20)) {
                        PacketHandler.this._log.info("Valid introduction packet received for outbound established con: " + packet);
                    }
                    this._state = 37;
                    packet.decrypt(state.getCipherKey());
                    this.handlePacket(reader, packet, null, state, null, true);
                    this._state = 38;
                    return;
                }
            }
            if (isValid = packet.validate(state.getIntroKey())) {
                if (PacketHandler.this._log.shouldLog(20)) {
                    PacketHandler.this._log.info("Valid introduction packet received for outbound established con with old intro key: " + packet);
                }
                this._state = 39;
                packet.decrypt(state.getIntroKey());
                this.handlePacket(reader, packet, null, state, null, true);
                this._state = 40;
                return;
            }
            if (PacketHandler.this._log.shouldLog(30)) {
                PacketHandler.this._log.warn("Invalid introduction packet received for outbound established con with old intro key, falling back: " + packet);
            }
            this._state = 41;
            this.receivePacket(reader, packet, (short)1);
            this._state = 42;
        }

        private void handlePacket(UDPPacketReader reader, UDPPacket packet, PeerState state, OutboundEstablishState outState, InboundEstablishState inState, boolean isAuthenticated) {
            this._state = 43;
            reader.initialize(packet);
            this._state = 44;
            long recvOn = packet.getBegin();
            long sendOn = reader.readTimestamp() * 1000L;
            long skew = recvOn - sendOn;
            if (state != null) {
                if (PacketHandler.this._log.shouldLog(10)) {
                    PacketHandler.this._log.debug("Received packet from " + state.getRemoteHostId().toString() + " with skew " + skew);
                }
                if (isAuthenticated) {
                    state.adjustClockSkew(skew);
                }
            }
            PacketHandler.this._context.statManager().addRateData("udp.receivePacketSkew", skew, packet.getLifetime());
            if (!PacketHandler.this._context.clock().getUpdatedSuccessfully()) {
                PacketHandler.this._context.clock().setOffset(0L - skew, true);
                if (skew != 0L) {
                    PacketHandler.this._log.logAlways(30, "NTP failure, UDP adjusting clock by " + DataHelper.formatDuration((long)Math.abs(skew)));
                }
            }
            if (skew > 90000L) {
                if (PacketHandler.this._log.shouldLog(30)) {
                    PacketHandler.this._log.warn("Packet too far in the past: " + new Date(sendOn) + ": " + packet);
                }
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidSkew", skew, packet.getExpiration());
                return;
            }
            if (skew < -90000L) {
                if (PacketHandler.this._log.shouldLog(30)) {
                    PacketHandler.this._log.warn("Packet too far in the future: " + new Date(sendOn) + ": " + packet);
                }
                PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidSkew", 0L - skew, packet.getExpiration());
                return;
            }
            this._state = 45;
            RemoteHostId from = packet.getRemoteHost();
            this._state = 46;
            int type = reader.readPayloadType();
            switch (type) {
                case 0: {
                    this._state = 47;
                    PacketHandler.this._establisher.receiveSessionRequest(from, reader);
                    break;
                }
                case 2: {
                    this._state = 48;
                    if (!isAuthenticated) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping unauthenticated type " + type + ": " + packet);
                        break;
                    }
                    PacketHandler.this._establisher.receiveSessionConfirmed(from, reader);
                    break;
                }
                case 1: {
                    this._state = 49;
                    if (!isAuthenticated) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping unauthenticated type " + type + ": " + packet);
                        break;
                    }
                    PacketHandler.this._establisher.receiveSessionCreated(from, reader);
                    break;
                }
                case 6: {
                    this._state = 50;
                    if (!isAuthenticated) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping unauthenticated type " + type + ": " + packet);
                        break;
                    }
                    if (outState != null) {
                        state = PacketHandler.this._establisher.receiveData(outState);
                    }
                    if (PacketHandler.this._log.shouldLog(10)) {
                        PacketHandler.this._log.debug("Received new DATA packet from " + state + ": " + packet);
                    }
                    if (state != null) {
                        UDPPacketReader.DataReader dr = reader.getDataReader();
                        if (PacketHandler.this._log.shouldLog(20)) {
                            StringBuilder msg = new StringBuilder();
                            msg.append("Receive ").append(System.identityHashCode(packet));
                            msg.append(" from ").append(state.getRemotePeer().toBase64()).append(" ").append(state.getRemoteHostId());
                            for (int i = 0; i < dr.readFragmentCount(); ++i) {
                                msg.append(" msg ").append(dr.readMessageId(i));
                                msg.append(":").append(dr.readMessageFragmentNum(i));
                                if (!dr.readMessageIsLast(i)) continue;
                                msg.append("*");
                            }
                            msg.append(": ").append(dr.toString());
                            PacketHandler.this._log.info(msg.toString());
                        }
                        PacketHandler.this._inbound.receiveData(state, dr);
                        PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.dataKnown", (long)packet.getPacket().getLength(), packet.getLifetime());
                        if (dr.readFragmentCount() > 0) break;
                        PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.dataKnownAck", (long)packet.getPacket().getLength(), packet.getLifetime());
                        break;
                    }
                    PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.dataUnknown", (long)packet.getPacket().getLength(), packet.getLifetime());
                    UDPPacketReader.DataReader dr = reader.getDataReader();
                    if (dr.readFragmentCount() > 0) break;
                    PacketHandler.this._context.statManager().addRateData("udp.receivePacketSize.dataUnknownAck", (long)packet.getPacket().getLength(), packet.getLifetime());
                    break;
                }
                case 7: {
                    this._state = 51;
                    if (PacketHandler.this._log.shouldLog(10)) {
                        PacketHandler.this._log.debug("Received test packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._testManager.receiveTest(from, reader);
                    break;
                }
                case 3: {
                    if (PacketHandler.this._log.shouldLog(20)) {
                        PacketHandler.this._log.info("Received relay request packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._introManager.receiveRelayRequest(from, reader);
                    break;
                }
                case 5: {
                    if (!isAuthenticated) {
                        if (!PacketHandler.this._log.shouldLog(30)) break;
                        PacketHandler.this._log.warn("Dropping unauthenticated type " + type + ": " + packet);
                        break;
                    }
                    if (PacketHandler.this._log.shouldLog(20)) {
                        PacketHandler.this._log.info("Received relay intro packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._introManager.receiveRelayIntro(from, reader);
                    break;
                }
                case 4: {
                    if (PacketHandler.this._log.shouldLog(20)) {
                        PacketHandler.this._log.info("Received relay response packet: " + reader + " from " + from);
                    }
                    PacketHandler.this._establisher.receiveRelayResponse(from, reader);
                    break;
                }
                case 8: {
                    this._state = 53;
                    if (!isAuthenticated) {
                        PacketHandler.this._establisher.receiveSessionDestroy(from);
                        break;
                    }
                    if (outState != null) {
                        PacketHandler.this._establisher.receiveSessionDestroy(from, outState);
                        break;
                    }
                    if (state != null) {
                        PacketHandler.this._establisher.receiveSessionDestroy(from, state);
                        break;
                    }
                    PacketHandler.this._establisher.receiveSessionDestroy(from);
                    break;
                }
                default: {
                    this._state = 52;
                    if (PacketHandler.this._log.shouldLog(30)) {
                        PacketHandler.this._log.warn("Unknown payload type: " + type);
                    }
                    PacketHandler.this._context.statManager().addRateData("udp.droppedInvalidUnknown", packet.getLifetime(), packet.getExpiration());
                    return;
                }
            }
        }
    }
}

