/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class Writer {
    private final Log _log;
    private final Set<NTCPConnection> _pendingConnections;
    private final Set<NTCPConnection> _liveWrites;
    private final Set<NTCPConnection> _writeAfterLive;
    private final List<Runner> _runners;

    public Writer(RouterContext ctx) {
        this._log = ctx.logManager().getLog(this.getClass());
        this._pendingConnections = new LinkedHashSet<NTCPConnection>(16);
        this._runners = new ArrayList<Runner>(5);
        this._liveWrites = new HashSet<NTCPConnection>(5);
        this._writeAfterLive = new HashSet<NTCPConnection>(5);
    }

    public synchronized void startWriting(int numWriters) {
        for (int i = 1; i <= numWriters; ++i) {
            Runner r = new Runner();
            I2PThread t = new I2PThread((Runnable)r, "NTCP writer " + i + '/' + numWriters, true);
            this._runners.add(r);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopWriting() {
        while (!this._runners.isEmpty()) {
            Runner r = this._runners.remove(0);
            r.stop();
        }
        Set<NTCPConnection> set = this._pendingConnections;
        synchronized (set) {
            this._writeAfterLive.clear();
            this._pendingConnections.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantsWrite(NTCPConnection con, String source) {
        boolean already = false;
        boolean pending = false;
        Set<NTCPConnection> set = this._pendingConnections;
        synchronized (set) {
            if (this._liveWrites.contains(con)) {
                this._writeAfterLive.add(con);
                already = true;
            } else {
                pending = this._pendingConnections.add(con);
            }
            this._pendingConnections.notify();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("wantsWrite: " + con + " already live? " + already + " added to pending? " + pending + ": " + source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(NTCPConnection con) {
        Set<NTCPConnection> set = this._pendingConnections;
        synchronized (set) {
            this._writeAfterLive.remove(con);
            this._pendingConnections.remove(con);
            this._pendingConnections.notify();
        }
    }

    private class Runner
    implements Runnable {
        private volatile boolean _stop;

        public void stop() {
            this._stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (Writer.this._log.shouldLog(20)) {
                Writer.this._log.info("Starting writer");
            }
            NTCPConnection con = null;
            while (!this._stop) {
                try {
                    Set set = Writer.this._pendingConnections;
                    synchronized (set) {
                        boolean keepWriting;
                        boolean bl = keepWriting = con != null && Writer.this._writeAfterLive.remove(con);
                        if (keepWriting) {
                            if (Writer.this._log.shouldLog(10)) {
                                Writer.this._log.debug("Keep writing on the same connection: " + con);
                            }
                        } else {
                            Writer.this._liveWrites.remove(con);
                            con = null;
                            if (Writer.this._pendingConnections.isEmpty()) {
                                if (Writer.this._log.shouldLog(10)) {
                                    Writer.this._log.debug("Done writing, but nothing pending, so wait");
                                }
                                Writer.this._pendingConnections.wait();
                            } else {
                                Iterator iter = Writer.this._pendingConnections.iterator();
                                con = (NTCPConnection)iter.next();
                                iter.remove();
                                Writer.this._liveWrites.add(con);
                                if (Writer.this._log.shouldLog(10)) {
                                    Writer.this._log.debug("Switch to writing on: " + con);
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (this._stop || con == null) continue;
                try {
                    if (Writer.this._log.shouldLog(10)) {
                        Writer.this._log.debug("Prepare next write on: " + con);
                    }
                    con.prepareNextWrite();
                }
                catch (RuntimeException re) {
                    Writer.this._log.log(50, "Error in the ntcp writer", (Throwable)re);
                }
            }
            if (Writer.this._log.shouldLog(20)) {
                Writer.this._log.info("Stopping writer");
            }
        }
    }
}

