/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.crypto;

import java.math.BigInteger;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.ByteArray;
import net.i2p.data.SessionKey;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.RandomSource;

public class DHSessionKeyBuilder {
    private final BigInteger _myPrivateValue;
    private final BigInteger _myPublicValue;
    private BigInteger _peerValue;
    private SessionKey _sessionKey;
    private final ByteArray _extraExchangedBytes;
    private static final String PROP_DH_PRECALC_MIN = "crypto.dh.precalc.min";
    private static final String PROP_DH_PRECALC_MAX = "crypto.dh.precalc.max";
    private static final String PROP_DH_PRECALC_DELAY = "crypto.dh.precalc.delay";
    private static final int DEFAULT_DH_PRECALC_MIN = 15;
    private static final int DEFAULT_DH_PRECALC_MAX = 40;
    private static final int DEFAULT_DH_PRECALC_DELAY = 200;

    DHSessionKeyBuilder() {
        this(RandomSource.getInstance());
    }

    DHSessionKeyBuilder(RandomSource random) {
        this._myPrivateValue = new NativeBigInteger(226, (Random)random);
        this._myPublicValue = CryptoConstants.elgg.modPow(this._myPrivateValue, CryptoConstants.elgp);
        this._extraExchangedBytes = new ByteArray();
    }

    public BigInteger getMyPublicValue() {
        return this._myPublicValue;
    }

    public byte[] getMyPublicValueBytes() {
        return DHSessionKeyBuilder.toByteArray(this.getMyPublicValue());
    }

    private static final byte[] toByteArray(BigInteger bi) {
        byte[] data = bi.toByteArray();
        byte[] rv = new byte[256];
        if (data.length == 257) {
            System.arraycopy(data, 1, rv, 0, rv.length);
        } else if (data.length == 256) {
            System.arraycopy(data, 0, rv, 0, rv.length);
        } else {
            System.arraycopy(data, 0, rv, rv.length - data.length, data.length);
        }
        return rv;
    }

    public synchronized void setPeerPublicValue(BigInteger peerVal) throws InvalidPublicParameterException {
        if (this._peerValue != null) {
            if (!this._peerValue.equals(peerVal)) {
                throw new IllegalStateException();
            }
            return;
        }
        DHSessionKeyBuilder.validatePublic(peerVal);
        this._peerValue = peerVal;
    }

    public void setPeerPublicValue(byte[] val) throws InvalidPublicParameterException {
        if (val.length != 256) {
            throw new IllegalArgumentException("Peer public value must be exactly 256 bytes");
        }
        if (1 == (val[0] & 0x80)) {
            byte[] val2 = new byte[257];
            System.arraycopy(val, 0, val2, 1, 256);
            val = val2;
        }
        this.setPeerPublicValue((BigInteger)new NativeBigInteger(1, val));
    }

    public BigInteger getPeerPublicValue() {
        return this._peerValue;
    }

    public byte[] getPeerPublicValueBytes() {
        return DHSessionKeyBuilder.toByteArray(this.getPeerPublicValue());
    }

    public synchronized SessionKey getSessionKey() {
        if (this._sessionKey != null) {
            return this._sessionKey;
        }
        if (this._peerValue != null) {
            this._sessionKey = this.calculateSessionKey(this._myPrivateValue, this._peerValue);
        }
        return this._sessionKey;
    }

    public ByteArray getExtraBytes() {
        return this._extraExchangedBytes;
    }

    private final SessionKey calculateSessionKey(BigInteger myPrivateValue, BigInteger publicPeerValue) {
        byte[] val;
        SessionKey key = new SessionKey();
        BigInteger exchangedKey = publicPeerValue.modPow(myPrivateValue, CryptoConstants.elgp);
        byte[] buf = exchangedKey.toByteArray();
        if (buf.length < (val = new byte[32]).length) {
            System.arraycopy(buf, 0, val, 0, buf.length);
            byte[] remaining = SHA256Generator.getInstance().calculateHash(val).getData();
            this._extraExchangedBytes.setData(remaining);
        } else {
            System.arraycopy(buf, 0, val, 0, val.length);
            RandomSource.getInstance().harvester().feedEntropy("DH", buf, val.length, buf.length - val.length);
            byte[] remaining = new byte[buf.length - val.length];
            System.arraycopy(buf, val.length, remaining, 0, remaining.length);
            this._extraExchangedBytes.setData(remaining);
        }
        key.setData(val);
        return key;
    }

    private static final void validatePublic(BigInteger publicValue) throws InvalidPublicParameterException {
        int cmp = publicValue.compareTo(NativeBigInteger.ONE);
        if (cmp <= 0) {
            throw new InvalidPublicParameterException("Public value is below two: " + publicValue.toString());
        }
        cmp = publicValue.compareTo(CryptoConstants.elgp);
        if (cmp >= 0) {
            throw new InvalidPublicParameterException("Public value is above p-1: " + publicValue.toString());
        }
    }

    public static class InvalidPublicParameterException
    extends I2PException {
        public InvalidPublicParameterException() {
        }

        public InvalidPublicParameterException(String msg) {
            super(msg);
        }
    }

    public static class PrecalcRunner
    extends I2PThread
    implements Factory {
        private final I2PAppContext _context;
        private final Log _log;
        private final int _minSize;
        private final int _maxSize;
        private final int _calcDelay;
        private final LinkedBlockingQueue<DHSessionKeyBuilder> _builders;
        private volatile boolean _isRunning;
        private long _checkDelay = 30000L;

        public PrecalcRunner(I2PAppContext ctx) {
            super("DH Precalc");
            this._context = ctx;
            this._log = ctx.logManager().getLog(DHSessionKeyBuilder.class);
            ctx.statManager().createRateStat("crypto.dhGeneratePublicTime", "How long it takes to create x and X", "Encryption", new long[]{3600000L});
            ctx.statManager().createRateStat("crypto.DHUsed", "Need a DH from the queue", "Encryption", new long[]{3600000L});
            ctx.statManager().createRateStat("crypto.DHEmpty", "DH queue empty", "Encryption", new long[]{3600000L});
            long maxMemory = Runtime.getRuntime().maxMemory();
            if (maxMemory == Long.MAX_VALUE) {
                maxMemory = 0x7F00000L;
            }
            int factor = (int)Math.max(1L, Math.min(4L, 1L + maxMemory / 0x8000000L));
            int defaultMin = 15 * factor;
            int defaultMax = 40 * factor;
            this._minSize = ctx.getProperty(DHSessionKeyBuilder.PROP_DH_PRECALC_MIN, defaultMin);
            this._maxSize = ctx.getProperty(DHSessionKeyBuilder.PROP_DH_PRECALC_MAX, defaultMax);
            this._calcDelay = ctx.getProperty(DHSessionKeyBuilder.PROP_DH_PRECALC_DELAY, 200);
            if (this._log.shouldLog(10)) {
                this._log.debug("DH Precalc (minimum: " + this._minSize + " max: " + this._maxSize + ", delay: " + this._calcDelay + ")");
            }
            this._builders = new LinkedBlockingQueue(this._maxSize);
            this.setPriority(1);
        }

        public void shutdown() {
            this._isRunning = false;
            this.interrupt();
            this._builders.clear();
        }

        public void run() {
            this._isRunning = true;
            while (this._isRunning) {
                int startSize = this.getSize();
                if (startSize <= this._minSize * 2 / 3 && this._checkDelay > 1000L) {
                    this._checkDelay -= 1000L;
                } else if (startSize > this._minSize * 3 / 2 && this._checkDelay < 60000L) {
                    this._checkDelay += 1000L;
                }
                if (startSize < this._minSize) {
                    while (this.getSize() < this._maxSize && this._isRunning) {
                        long curStart = System.currentTimeMillis();
                        if (!this.addBuilder(this.precalc())) break;
                        long curCalc = System.currentTimeMillis() - curStart;
                        try {
                            Thread.sleep((long)this._calcDelay + curCalc * 3L);
                        }
                        catch (InterruptedException ie) {}
                    }
                }
                if (!this._isRunning) break;
                try {
                    Thread.sleep(this._checkDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public DHSessionKeyBuilder getBuilder() {
            this._context.statManager().addRateData("crypto.DHUsed", 1L, 0L);
            DHSessionKeyBuilder builder = this._builders.poll();
            if (builder == null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("No more builders, creating one now");
                }
                this._context.statManager().addRateData("crypto.DHEmpty", 1L, 0L);
                builder = this.precalc();
            }
            return builder;
        }

        private DHSessionKeyBuilder precalc() {
            long start = System.currentTimeMillis();
            DHSessionKeyBuilder builder = new DHSessionKeyBuilder(this._context.random());
            long end = System.currentTimeMillis();
            long diff = end - start;
            this._context.statManager().addRateData("crypto.dhGeneratePublicTime", diff, diff);
            if (diff > 1000L) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Took more than a second (" + diff + "ms) to generate local DH value");
                }
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Took " + diff + "ms to generate local DH value");
            }
            return builder;
        }

        private final boolean addBuilder(DHSessionKeyBuilder builder) {
            return this._builders.offer(builder);
        }

        private final int getSize() {
            return this._builders.size();
        }
    }

    public static interface Factory {
        public DHSessionKeyBuilder getBuilder();
    }
}

