/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.transport.TransportUtil;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.Translate;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.ArgumentList;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.ServiceList;
import org.cybergarage.upnp.UPnPStatus;
import org.cybergarage.upnp.device.DeviceChangeListener;
import org.cybergarage.upnp.event.EventListener;
import org.freenetproject.DetectedIP;
import org.freenetproject.ForwardPort;
import org.freenetproject.ForwardPortCallback;
import org.freenetproject.ForwardPortStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UPnP
extends ControlPoint
implements DeviceChangeListener,
EventListener {
    private final Log _log;
    private final I2PAppContext _context;
    private static final String ROUTER_DEVICE = "urn:schemas-upnp-org:device:InternetGatewayDevice:1";
    private static final String WAN_DEVICE = "urn:schemas-upnp-org:device:WANDevice:1";
    private static final String WANCON_DEVICE = "urn:schemas-upnp-org:device:WANConnectionDevice:1";
    private static final String WAN_IP_CONNECTION = "urn:schemas-upnp-org:service:WANIPConnection:1";
    private static final String WAN_PPP_CONNECTION = "urn:schemas-upnp-org:service:WANPPPConnection:1";
    private Device _router;
    private Service _service;
    private boolean isDisabled = false;
    private volatile boolean _serviceLacksAPM;
    private final Object lock = new Object();
    private volatile boolean thinksWeAreDoubleNatted = false;
    private final Set<ForwardPort> portsToForward;
    private final Set<ForwardPort> portsForwarded;
    private ForwardPortCallback forwardCallback;
    private String _lastAction;
    private Service _lastService;
    private ArgumentList _lastArgumentList;
    private final Object toStringLock = new Object();
    private static int __id = 0;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public UPnP(I2PAppContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(UPnP.class);
        this.portsToForward = new HashSet<ForwardPort>();
        this.portsForwarded = new HashSet<ForwardPort>();
        this.addDeviceChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean runPlugin() {
        Object object = this.lock;
        synchronized (object) {
            this.portsToForward.clear();
        }
        return super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        Object object = this.lock;
        synchronized (object) {
            this.portsToForward.clear();
        }
        this.unregisterPortMappings();
        int i = 0;
        while (i++ < 20 && !this.portsForwarded.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        super.stop();
        this._router = null;
        this._service = null;
        this._serviceLacksAPM = false;
    }

    public DetectedIP[] getAddress() {
        this._log.info("UP&P.getAddress() is called \\o/");
        if (this.isDisabled) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Plugin has been disabled previously, ignoring request.");
            }
            return null;
        }
        if (!this.isNATPresent()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No UP&P device found, detection of the external ip address using the plugin has failed");
            }
            return null;
        }
        DetectedIP result = null;
        String natAddress = this.getNATAddress();
        if (natAddress == null || natAddress.length() <= 0) {
            if (this._log.shouldLog(30)) {
                this._log.warn("No external address returned");
            }
            return null;
        }
        try {
            InetAddress detectedIP = InetAddress.getByName(natAddress);
            short status = 1;
            boolean bl = this.thinksWeAreDoubleNatted = !TransportUtil.isPubliclyRoutable(detectedIP.getAddress(), false);
            if (this._log.shouldLog(30)) {
                this._log.warn("NATAddress: \"" + natAddress + "\" detectedIP: " + detectedIP + " double? " + this.thinksWeAreDoubleNatted);
            }
            if (this.portsForwarded.size() > 1 && !this.thinksWeAreDoubleNatted) {
                status = 2;
            }
            result = new DetectedIP(detectedIP, status);
            if (this._log.shouldLog(30)) {
                this._log.warn("Successful UP&P discovery :" + result);
            }
            return new DetectedIP[]{result};
        }
        catch (UnknownHostException e) {
            this._log.error("Caught an UnknownHostException resolving " + natAddress, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceAdded(Device dev) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDisabled) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Plugin has been disabled previously, ignoring new device.");
                }
                return;
            }
        }
        if (!ROUTER_DEVICE.equals(dev.getDeviceType()) || !dev.isRootDevice()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("UP&P non-IGD device found, ignoring : " + dev.getFriendlyName());
            }
            return;
        }
        if (this.isNATPresent()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("UP&P ignoring additional IGD device found: " + dev.getFriendlyName() + " UDN: " + dev.getUDN());
            }
            return;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("UP&P IGD found : " + dev.getFriendlyName() + " UDN: " + dev.getUDN() + " lease time: " + dev.getLeaseTime());
        }
        object = this.lock;
        synchronized (object) {
            this._router = dev;
        }
        this.discoverService();
        object = this.lock;
        synchronized (object) {
            if (this._service == null) {
                this._log.error("The IGD device we got isn't suiting our needs, let's disable the plugin");
                this.isDisabled = true;
                this._router = null;
                return;
            }
            this.subscribe(this._service);
        }
        this.registerPortMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPortMappings() {
        HashSet<ForwardPort> ports;
        Object object = this.lock;
        synchronized (object) {
            ports = new HashSet<ForwardPort>(this.portsForwarded);
        }
        if (ports.isEmpty()) {
            return;
        }
        this.registerPorts(ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverService() {
        Object object = this.lock;
        synchronized (object) {
            for (Device current : this._router.getDeviceList()) {
                if (!current.getDeviceType().equals(WAN_DEVICE)) continue;
                DeviceList l = current.getDeviceList();
                for (int i = 0; i < current.getDeviceList().size(); ++i) {
                    Device current2 = l.getDevice(i);
                    if (!current2.getDeviceType().equals(WANCON_DEVICE)) continue;
                    this._service = current2.getService(WAN_PPP_CONNECTION);
                    if (this._service == null) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn(this._router.getFriendlyName() + " doesn't seems to be using PPP; we won't be able to extract bandwidth-related informations out of it.");
                        }
                        this._service = current2.getService(WAN_IP_CONNECTION);
                        if (this._service == null) {
                            this._log.error(this._router.getFriendlyName() + " doesn't export WAN_IP_CONNECTION either: we won't be able to use it!");
                        }
                    }
                    this._serviceLacksAPM = false;
                    return;
                }
            }
        }
    }

    private boolean tryAddMapping(String protocol, int port, String description, ForwardPort fp) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Registering a port mapping for " + port + "/" + protocol);
        }
        int nbOfTries = 0;
        boolean isPortForwarded = false;
        while (!(this._serviceLacksAPM || nbOfTries++ >= 5 || (isPortForwarded = this.addMapping(protocol, port, "I2P " + description, fp)) || this._serviceLacksAPM)) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {}
        }
        if (this._log.shouldLog(30)) {
            this._log.warn((isPortForwarded ? "Mapping is successful!" : "Mapping has failed!") + " (" + nbOfTries + " tries)");
        }
        return isPortForwarded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortMappings() {
        HashSet<ForwardPort> ports;
        Object object = this.lock;
        synchronized (object) {
            ports = new HashSet<ForwardPort>(this.portsForwarded);
        }
        if (ports.isEmpty()) {
            return;
        }
        this.unregisterPorts(ports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceRemoved(Device dev) {
        if (this._log.shouldLog(30)) {
            this._log.warn("UP&P device removed : " + dev.getFriendlyName() + " UDN: " + dev.getUDN());
        }
        Object object = this.lock;
        synchronized (object) {
            if (this._router == null) {
                return;
            }
            if (ROUTER_DEVICE.equals(dev.getDeviceType()) && dev.isRootDevice() && UPnP.stringEquals(this._router.getFriendlyName(), dev.getFriendlyName()) && UPnP.stringEquals(this._router.getUDN(), dev.getUDN())) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("UP&P IGD device removed : " + dev.getFriendlyName());
                }
                this._router = null;
                this._service = null;
                this._serviceLacksAPM = false;
            }
        }
    }

    @Override
    public void eventNotifyReceived(String uuid, long seq, String varName, String value) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Event: " + uuid + ' ' + seq + ' ' + varName + '=' + value);
        }
    }

    private static boolean stringEquals(String a, String b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }

    public boolean isNATPresent() {
        return this._router != null && this._service != null;
    }

    public String getNATAddress() {
        if (!this.isNATPresent()) {
            return null;
        }
        Action getIP = this._service.getAction("GetExternalIPAddress");
        if (getIP == null || !getIP.postControlAction()) {
            return null;
        }
        String rv = getIP.getOutputArgumentList().getArgument("NewExternalIPAddress").getValue();
        if ("0.0.0.0".equals(rv)) {
            return null;
        }
        return rv;
    }

    public int getUpstreamMaxBitRate() {
        if (!this.isNATPresent() || this.thinksWeAreDoubleNatted) {
            return -1;
        }
        Action getIP = this._service.getAction("GetLinkLayerMaxBitRates");
        if (getIP == null || !getIP.postControlAction()) {
            return -1;
        }
        return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewUpstreamMaxBitRate").getValue());
    }

    public int getDownstreamMaxBitRate() {
        if (!this.isNATPresent() || this.thinksWeAreDoubleNatted) {
            return -1;
        }
        Action getIP = this._service.getAction("GetLinkLayerMaxBitRates");
        if (getIP == null || !getIP.postControlAction()) {
            return -1;
        }
        return Integer.valueOf(getIP.getOutputArgumentList().getArgument("NewDownstreamMaxBitRate").getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(String action, String arg, Service serv) {
        Object object = this.toStringLock;
        synchronized (object) {
            if (!action.equals(this._lastAction) || !serv.equals(this._lastService) || this._lastArgumentList == null) {
                Action getIP = serv.getAction(action);
                if (getIP == null || !getIP.postControlAction()) {
                    this._lastAction = null;
                    return null;
                }
                this._lastAction = action;
                this._lastService = serv;
                this._lastArgumentList = getIP.getOutputArgumentList();
            }
            return this._lastArgumentList.getArgument(arg).getValue();
        }
    }

    private void listSubServices(Device dev, StringBuilder sb) {
        ServiceList sl = dev.getServiceList();
        if (sl.isEmpty()) {
            return;
        }
        sb.append("<ul>\n");
        for (int i = 0; i < sl.size(); ++i) {
            Service serv = sl.getService(i);
            if (serv == null) continue;
            sb.append("<li>").append(this._("Service")).append(": ");
            if ("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1".equals(serv.getServiceType())) {
                sb.append(this._("WAN Common Interface Configuration"));
                sb.append("<ul><li>").append(this._("Status")).append(": " + this.toString("GetCommonLinkProperties", "NewPhysicalLinkStatus", serv));
                sb.append("<li>").append(this._("Type")).append(": " + this.toString("GetCommonLinkProperties", "NewWANAccessType", serv));
                sb.append("<li>").append(this._("Upstream")).append(": " + this.toString("GetCommonLinkProperties", "NewLayer1UpstreamMaxBitRate", serv));
                sb.append("<li>").append(this._("Downstream")).append(": " + this.toString("GetCommonLinkProperties", "NewLayer1DownstreamMaxBitRate", serv) + "<br>");
            } else if (WAN_PPP_CONNECTION.equals(serv.getServiceType())) {
                sb.append(this._("WAN PPP Connection"));
                sb.append("<ul><li>").append(this._("Status")).append(": " + this.toString("GetStatusInfo", "NewConnectionStatus", serv));
                sb.append("<li>").append(this._("Type")).append(": " + this.toString("GetConnectionTypeInfo", "NewConnectionType", serv));
                sb.append("<li>").append(this._("Upstream")).append(": " + this.toString("GetLinkLayerMaxBitRates", "NewUpstreamMaxBitRate", serv));
                sb.append("<li>").append(this._("Downstream")).append(": " + this.toString("GetLinkLayerMaxBitRates", "NewDownstreamMaxBitRate", serv) + "<br>");
                sb.append("<li>").append(this._("External IP")).append(": " + this.toString("GetExternalIPAddress", "NewExternalIPAddress", serv) + "<br>");
            } else if ("urn:schemas-upnp-org:service:Layer3Forwarding:1".equals(serv.getServiceType())) {
                sb.append(this._("Layer 3 Forwarding"));
                sb.append("<ul><li>").append(this._("Default Connection Service")).append(": " + this.toString("GetDefaultConnectionService", "NewDefaultConnectionService", serv));
            } else if (WAN_IP_CONNECTION.equals(serv.getServiceType())) {
                sb.append(this._("WAN IP Connection"));
                sb.append("<ul><li>").append(this._("Status")).append(": " + this.toString("GetStatusInfo", "NewConnectionStatus", serv));
                sb.append("<li>").append(this._("Type")).append(": " + this.toString("GetConnectionTypeInfo", "NewConnectionType", serv));
                sb.append("<li>").append(this._("External IP")).append(": " + this.toString("GetExternalIPAddress", "NewExternalIPAddress", serv) + "<br>");
            } else if ("urn:schemas-upnp-org:service:WANEthernetLinkConfig:1".equals(serv.getServiceType())) {
                sb.append(this._("WAN Ethernet Link Configuration"));
                sb.append("<ul><li>").append(this._("Status")).append(": " + this.toString("GetEthernetLinkStatus", "NewEthernetLinkStatus", serv) + "<br>");
            } else {
                sb.append("~~~~~~~ " + serv.getServiceType() + "<ul>");
            }
            sb.append("</ul>\n");
        }
        sb.append("</ul>\n");
    }

    private void listSubDev(String prefix, Device dev, StringBuilder sb) {
        if (prefix == null) {
            sb.append("<p>").append(this._("Found Device")).append(": ");
        } else {
            sb.append("<li>").append(this._("Subdevice")).append(": ");
        }
        sb.append(dev.getFriendlyName());
        if (prefix == null) {
            sb.append("</p>");
        }
        this.listSubServices(dev, sb);
        DeviceList dl = dev.getDeviceList();
        if (dl.isEmpty()) {
            return;
        }
        sb.append("<ul>\n");
        for (int j = 0; j < dl.size(); ++j) {
            Device subDev = dl.getDevice(j);
            if (subDev == null) continue;
            this.listSubDev(dev.getFriendlyName(), subDev, sb);
        }
        sb.append("</ul>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderStatusHTML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h3><a name=\"upnp\"></a>").append(this._("UPnP Status")).append("</h3>");
        if (this.isDisabled) {
            sb.append(this._("UPnP has been disabled; Do you have more than one UPnP Internet Gateway Device on your LAN ?"));
            return sb.toString();
        }
        if (!this.isNATPresent()) {
            sb.append(this._("UPnP has not found any UPnP-aware, compatible device on your LAN."));
            return sb.toString();
        }
        this.listSubDev(null, this._router, sb);
        String addr = this.getNATAddress();
        sb.append("<p>");
        if (addr != null) {
            sb.append(this._("The current external IP address reported by UPnP is {0}", addr));
        } else {
            sb.append(this._("The current external IP address is not available."));
        }
        int downstreamMaxBitRate = this.getDownstreamMaxBitRate();
        int upstreamMaxBitRate = this.getUpstreamMaxBitRate();
        if (downstreamMaxBitRate > 0) {
            sb.append("<br>").append(this._("UPnP reports the maximum downstream bit rate is {0}bits/sec", DataHelper.formatSize2((long)downstreamMaxBitRate)));
        }
        if (upstreamMaxBitRate > 0) {
            sb.append("<br>").append(this._("UPnP reports the maximum upstream bit rate is {0}bits/sec", DataHelper.formatSize2((long)upstreamMaxBitRate)));
        }
        Object object = this.lock;
        synchronized (object) {
            for (ForwardPort port : this.portsToForward) {
                sb.append("<br>");
                if (this.portsForwarded.contains(port)) {
                    sb.append(this._("{0} port {1,number,#####} was successfully forwarded by UPnP.", UPnP.protoToString(port.protocol), port.portNumber));
                    continue;
                }
                sb.append(this._("{0} port {1,number,#####} was not forwarded by UPnP.", UPnP.protoToString(port.protocol), port.portNumber));
            }
        }
        sb.append("</p>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMapping(String protocol, int port, String description, ForwardPort fp) {
        int level;
        if (this.isDisabled || !this.isNATPresent() || this._router == null) {
            this._log.error("Can't addMapping: " + this.isDisabled + " " + this.isNATPresent() + " " + this._router);
            return false;
        }
        Action add = this._service.getAction("AddPortMapping");
        if (add == null) {
            if (this._serviceLacksAPM) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Couldn't find AddPortMapping action!");
                }
            } else {
                this._serviceLacksAPM = true;
                this._log.logAlways(30, "UPnP device does not support port forwarding");
            }
            return false;
        }
        add.setArgumentValue("NewRemoteHost", "");
        add.setArgumentValue("NewExternalPort", port);
        String intf = this._router.getInterfaceAddress();
        String us = this.getOurAddress(intf);
        if (this._log.shouldLog(30) && !us.equals(intf)) {
            this._log.warn("Requesting port forward to " + us + ':' + port + " when cybergarage wanted " + intf);
        }
        add.setArgumentValue("NewInternalClient", us);
        add.setArgumentValue("NewInternalPort", port);
        add.setArgumentValue("NewProtocol", protocol);
        add.setArgumentValue("NewPortMappingDescription", description);
        add.setArgumentValue("NewEnabled", "1");
        add.setArgumentValue("NewLeaseDuration", 0);
        boolean rv = add.postControlAction();
        if (rv) {
            Object object = this.lock;
            synchronized (object) {
                this.portsForwarded.add(fp);
            }
        }
        int n = level = rv ? 20 : 30;
        if (this._log.shouldLog(level)) {
            StringBuilder buf = new StringBuilder();
            buf.append("AddPortMapping result for ").append(protocol).append(" port ").append(port);
            UPnPStatus status = add.getStatus();
            if (status != null) {
                buf.append(" Status: ").append(status.getCode()).append(' ').append(status.getDescription());
            }
            if ((status = add.getControlStatus()) != null) {
                buf.append(" ControlStatus: ").append(status.getCode()).append(' ').append(status.getDescription());
            }
            this._log.log(level, buf.toString());
        }
        return rv;
    }

    private String getOurAddress(String deflt) {
        URL url;
        String rv = deflt;
        String hisIP = null;
        String him = this._router.getURLBase();
        if (him != null && him.length() > 0) {
            try {
                url = new URL(him);
                hisIP = url.getHost();
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
        if (hisIP == null && (him = this._router.getLocation()) != null && him.length() > 0) {
            try {
                url = new URL(him);
                hisIP = url.getHost();
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
        if (hisIP == null) {
            return rv;
        }
        try {
            byte[] hisBytes = InetAddress.getByName(hisIP).getAddress();
            if (hisBytes.length != 4) {
                return deflt;
            }
            long hisLong = DataHelper.fromLong((byte[])hisBytes, (int)0, (int)4);
            long distance = Long.MAX_VALUE;
            SortedSet myAddresses = Addresses.getAddresses((boolean)true, (boolean)false);
            myAddresses.add(deflt);
            for (String me : myAddresses) {
                if (me.startsWith("127.") || me.equals("0.0.0.0")) continue;
                try {
                    byte[] myBytes = InetAddress.getByName(me).getAddress();
                    long myLong = DataHelper.fromLong((byte[])myBytes, (int)0, (int)4);
                    long newDistance = myLong ^ hisLong;
                    if (newDistance >= distance) continue;
                    rv = me;
                    distance = newDistance;
                }
                catch (UnknownHostException uhe) {}
            }
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMapping(String protocol, int port, ForwardPort fp, boolean noLog) {
        if (this.isDisabled || !this.isNATPresent()) {
            return false;
        }
        Action remove = this._service.getAction("DeletePortMapping");
        if (remove == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Couldn't find DeletePortMapping action!");
            }
            return false;
        }
        remove.setArgumentValue("NewExternalPort", port);
        remove.setArgumentValue("NewProtocol", protocol);
        boolean retval = remove.postControlAction();
        Object object = this.lock;
        synchronized (object) {
            this.portsForwarded.remove(fp);
        }
        if (this._log.shouldLog(30) && !noLog) {
            this._log.warn("UPnP: Removed mapping for " + fp.name + " " + port + " / " + protocol);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangePublicPorts(Set<ForwardPort> ports, ForwardPortCallback cb) {
        Set<ForwardPort> portsToDumpNow = null;
        Set<ForwardPort> portsToForwardNow = null;
        if (this._log.shouldLog(20)) {
            this._log.info("UP&P Forwarding " + ports.size() + " ports...");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.forwardCallback != null && this.forwardCallback != cb && cb != null) {
                this._log.error("ForwardPortCallback changed from " + this.forwardCallback + " to " + cb + " - using new value, but this is very strange!");
            }
            this.forwardCallback = cb;
            if (this.portsToForward.isEmpty()) {
                this.portsToForward.addAll(ports);
                portsToForwardNow = ports;
                portsToDumpNow = null;
            } else if (ports.isEmpty()) {
                portsToDumpNow = this.portsToForward;
                this.portsToForward.clear();
                portsToForwardNow = null;
            } else {
                for (ForwardPort port : ports) {
                    if (this.portsForwarded.contains(port)) continue;
                    if (portsToForwardNow == null) {
                        portsToForwardNow = new HashSet<ForwardPort>();
                    }
                    portsToForwardNow.add(port);
                }
                for (ForwardPort port : this.portsToForward) {
                    if (ports.contains(port)) continue;
                    if (portsToDumpNow == null) {
                        portsToDumpNow = new HashSet<ForwardPort>();
                    }
                    portsToDumpNow.add(port);
                }
                this.portsToForward.clear();
                this.portsToForward.addAll(ports);
            }
            if (this._router == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("No UPnP router available to update");
                }
                return;
            }
        }
        if (portsToDumpNow != null && !portsToDumpNow.isEmpty()) {
            this.unregisterPorts(portsToDumpNow);
        }
        if (portsToForwardNow != null && !portsToForwardNow.isEmpty()) {
            this.registerPorts(portsToForwardNow);
        }
    }

    private static String protoToString(int p) {
        if (p == 17) {
            return "UDP";
        }
        if (p == 6) {
            return "TCP";
        }
        return "?";
    }

    private void registerPorts(Set<ForwardPort> portsToForwardNow) {
        if (this._serviceLacksAPM) {
            if (this._log.shouldLog(30)) {
                this._log.warn("UPnP device does not support port forwarding");
            }
            for (ForwardPort port : portsToForwardNow) {
                ForwardPortStatus fps = new ForwardPortStatus(-2, "UPnP device does not support port forwarding", port.portNumber);
                Map<ForwardPort, ForwardPortStatus> map = Collections.singletonMap(port, fps);
                this.forwardCallback.portForwardStatus(map);
            }
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Starting thread to forward " + portsToForwardNow.size() + " ports");
        }
        Thread t = new Thread(new RegisterPortsThread(portsToForwardNow));
        t.setName("UPnP Port Opener " + ++__id);
        t.setDaemon(true);
        t.start();
    }

    private void unregisterPorts(Set<ForwardPort> portsToForwardNow) {
        if (this._log.shouldLog(20)) {
            this._log.info("Starting thread to un-forward " + portsToForwardNow.size() + " ports");
        }
        Thread t = new Thread(new UnregisterPortsThread(portsToForwardNow));
        t.setName("UPnP Port Closer " + ++__id);
        t.setDaemon(true);
        t.start();
    }

    public static void main(String[] args) throws Exception {
        UPnP upnp = new UPnP(I2PAppContext.getGlobalContext());
        ControlPoint cp = new ControlPoint();
        System.out.println("Searching for up&p devices:");
        cp.start();
        cp.search();
        while (true) {
            DeviceList list = cp.getDeviceList();
            System.out.println("Found " + list.size() + " devices!");
            StringBuilder sb = new StringBuilder();
            for (Device device : list) {
                upnp.listSubDev(device.toString(), device, sb);
                System.out.println("Here is the listing for " + device.toString() + " :");
                System.out.println(sb.toString());
                sb = new StringBuilder();
            }
            System.out.println("End");
            Thread.sleep(2000L);
        }
    }

    private final String _(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private final String _(String s, Object o) {
        return Translate.getString((String)s, (Object)o, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private final String _(String s, Object o, Object o2) {
        return Translate.getString((String)s, (Object)o, (Object)o2, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnregisterPortsThread
    implements Runnable {
        private Set<ForwardPort> portsToForwardNow;

        public UnregisterPortsThread(Set<ForwardPort> ports) {
            this.portsToForwardNow = ports;
        }

        @Override
        public void run() {
            for (ForwardPort port : this.portsToForwardNow) {
                String proto = UPnP.protoToString(port.protocol);
                if (proto.length() <= 1) continue;
                UPnP.this.removeMapping(proto, port.portNumber, port, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegisterPortsThread
    implements Runnable {
        private Set<ForwardPort> portsToForwardNow;

        public RegisterPortsThread(Set<ForwardPort> ports) {
            this.portsToForwardNow = ports;
        }

        @Override
        public void run() {
            for (ForwardPort port : this.portsToForwardNow) {
                String proto = UPnP.protoToString(port.protocol);
                ForwardPortStatus fps = proto.length() <= 1 ? new ForwardPortStatus(-2, "Protocol not supported", port.portNumber) : (UPnP.this.tryAddMapping(proto, port.portNumber, port.name, port) ? new ForwardPortStatus(1, "Port apparently forwarded by UPnP", port.portNumber) : new ForwardPortStatus(-1, "UPnP port forwarding apparently failed", port.portNumber));
                Map<ForwardPort, ForwardPortStatus> map = Collections.singletonMap(port, fps);
                try {
                    UPnP.this.forwardCallback.portForwardStatus(map);
                }
                catch (Exception e) {
                    UPnP.this._log.error("UPnP RPT error", (Throwable)e);
                }
            }
        }
    }
}

