/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class UpdateRoutingKeyModifierJob
extends JobImpl {
    private final Log _log;
    private final Calendar _cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private static final long MAX_DELAY_FAILSAFE = 900000L;

    public UpdateRoutingKeyModifierJob(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
    }

    public String getName() {
        return "Update Routing Key Modifier";
    }

    public void runJob() {
        long delay = Math.min(900000L, this.getTimeTillMidnight());
        this.getContext().routingKeyGenerator().generateDateBasedModData();
        this.requeue(delay);
    }

    private long getTimeTillMidnight() {
        long now = this.getContext().clock().now();
        this._cal.setTime(new Date(now));
        this._cal.set(1, this._cal.get(1));
        this._cal.set(6, this._cal.get(6));
        this._cal.add(5, 1);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        long then = this._cal.getTime().getTime();
        long howLong = then - now;
        if (howLong < 0L) {
            howLong = 86400000L + howLong;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Time till midnight: " + howLong + "ms");
        }
        return howLong;
    }
}

