/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.io.File;
import java.io.IOException;
import net.i2p.router.Router;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SimpleTimer;

public class MarkLiveliness
implements SimpleTimer.TimedEvent {
    private final Router _router;
    private final File _pingFile;

    public MarkLiveliness(Router router, File pingFile) {
        this._router = router;
        this._pingFile = pingFile;
        this._pingFile.deleteOnExit();
    }

    public void timeReached() {
        if (this._router.isAlive()) {
            this.ping();
        } else {
            this._pingFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ping() {
        SecureFileOutputStream fos = null;
        try {
            fos = new SecureFileOutputStream(this._pingFile);
            fos.write(("" + System.currentTimeMillis()).getBytes());
        }
        catch (IOException ioe) {
            System.err.println("Error writing to ping file");
            ioe.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

