/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Hash;
import net.i2p.router.PeerSelectionCriteria;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.ProfileOrganizer;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PeerManager {
    private final Log _log;
    private final RouterContext _context;
    private final ProfileOrganizer _organizer;
    private final ProfilePersistenceHelper _persistenceHelper;
    private final Map<Character, Set<Hash>> _peersByCapability;
    private final Map<Hash, String> _capabilitiesByPeer;
    private static final long REORGANIZE_TIME = 45000L;
    private static final long REORGANIZE_TIME_MEDIUM = 123000L;
    private static final long REORGANIZE_TIME_LONG = 351000L;
    public static final String TRACKED_CAPS = "fHKLMNORU";

    public PeerManager(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(PeerManager.class);
        this._persistenceHelper = new ProfilePersistenceHelper(context);
        this._organizer = context.profileOrganizer();
        this._organizer.setUs(context.routerHash());
        this._capabilitiesByPeer = new ConcurrentHashMap<Hash, String>(256);
        this._peersByCapability = new HashMap<Character, Set<Hash>>(TRACKED_CAPS.length());
        for (int i = 0; i < TRACKED_CAPS.length(); ++i) {
            this._peersByCapability.put(Character.valueOf(Character.toLowerCase(TRACKED_CAPS.charAt(i))), (Set<Hash>)new ConcurrentHashSet());
        }
        this.loadProfilesInBackground();
    }

    void storeProfiles() {
        Set<Hash> peers = this.selectPeers();
        for (Hash peer : peers) {
            this.storeProfile(peer);
        }
    }

    void clearProfiles() {
        this._organizer.clearProfiles();
        this._capabilitiesByPeer.clear();
        for (Set<Hash> p : this._peersByCapability.values()) {
            p.clear();
        }
    }

    Set<Hash> selectPeers() {
        return this._organizer.selectAllPeers();
    }

    void storeProfile(Hash peer) {
        if (peer == null) {
            return;
        }
        PeerProfile prof = this._organizer.getProfile(peer);
        if (prof == null) {
            return;
        }
        this._persistenceHelper.writeProfile(prof);
    }

    private void loadProfilesInBackground() {
        new Thread(new ProfileLoader()).start();
    }

    void loadProfiles() {
        Set<PeerProfile> profiles = this._persistenceHelper.readProfiles();
        for (PeerProfile prof : profiles) {
            this._organizer.addProfile(prof);
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Profile for " + prof.getPeer().toBase64() + " loaded");
        }
    }

    List<Hash> selectPeers(PeerSelectionCriteria criteria) {
        HashSet<Hash> peers = new HashSet<Hash>(criteria.getMinimumRequired());
        HashSet<Hash> exclude = new HashSet<Hash>(1);
        exclude.add(this._context.routerHash());
        switch (criteria.getPurpose()) {
            case 4: {
                this._organizer.selectActiveNotFailingPeers(criteria.getMinimumRequired(), exclude, peers);
                break;
            }
            case 1: {
                this._organizer.selectFastPeers(criteria.getMaximumRequired(), exclude, peers);
                break;
            }
            case 3: {
                this._organizer.selectHighCapacityPeers(criteria.getMinimumRequired(), exclude, peers);
                break;
            }
            case 2: {
                this._organizer.selectHighCapacityPeers(criteria.getMinimumRequired(), exclude, peers);
                break;
            }
        }
        if (peers.isEmpty() && this._log.shouldLog(30)) {
            this._log.warn("We ran out of peers when looking for reachable ones after finding 0 with " + this._organizer.countHighCapacityPeers() + "/" + this._organizer.countFastPeers() + " high capacity/fast peers");
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Peers selected: " + peers);
        }
        return new ArrayList<Hash>(peers);
    }

    public void setCapabilities(Hash peer, String caps) {
        Set<Hash> peers;
        char c;
        int i;
        String oldCaps;
        if (this._log.shouldLog(10)) {
            this._log.debug("Setting capabilities for " + peer.toBase64() + " to " + caps);
        }
        if ((caps = caps.toLowerCase(Locale.US)).equals(oldCaps = this._capabilitiesByPeer.put(peer, caps))) {
            return;
        }
        if (oldCaps != null) {
            for (i = 0; i < oldCaps.length(); ++i) {
                c = oldCaps.charAt(i);
                if (caps.indexOf(c) >= 0 || (peers = this.locked_getPeers(c)) == null) continue;
                peers.remove(peer);
            }
        }
        for (i = 0; i < caps.length(); ++i) {
            c = caps.charAt(i);
            if (oldCaps != null && oldCaps.indexOf(c) >= 0 || (peers = this.locked_getPeers(c)) == null) continue;
            peers.add(peer);
        }
    }

    private Set<Hash> locked_getPeers(char c) {
        c = Character.toLowerCase(c);
        return this._peersByCapability.get(Character.valueOf(c));
    }

    public void removeCapabilities(Hash peer) {
        String oldCaps;
        if (this._log.shouldLog(10)) {
            this._log.debug("Removing capabilities from " + peer.toBase64());
        }
        if ((oldCaps = this._capabilitiesByPeer.remove(peer)) != null) {
            for (int i = 0; i < oldCaps.length(); ++i) {
                char c = oldCaps.charAt(i);
                Set<Hash> peers = this.locked_getPeers(c);
                if (peers == null) continue;
                peers.remove(peer);
            }
        }
    }

    public Set<Hash> getPeersByCapability(char capability) {
        Set<Hash> peers = this.locked_getPeers(capability);
        if (peers != null) {
            return Collections.unmodifiableSet(peers);
        }
        return Collections.EMPTY_SET;
    }

    private class ProfileLoader
    implements Runnable {
        private ProfileLoader() {
        }

        public void run() {
            PeerManager.this.loadProfiles();
            new Reorg();
        }
    }

    private class Reorg
    extends SimpleTimer2.TimedEvent {
        public Reorg() {
            super(PeerManager.this._context.simpleTimer2(), 45000L);
        }

        public void timeReached() {
            long start = System.currentTimeMillis();
            try {
                PeerManager.this._organizer.reorganize(true);
            }
            catch (Throwable t) {
                PeerManager.this._log.log(50, "Error evaluating profiles", t);
            }
            long orgtime = System.currentTimeMillis() - start;
            long uptime = PeerManager.this._context.router().getUptime();
            long delay = orgtime > 1000L || uptime > 0x6DDD00L ? 351000L : (uptime > 600000L ? 123000L : 45000L);
            this.schedule(delay);
        }
    }
}

