/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.MessageSelector;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.IterativeLookupJob;
import net.i2p.router.networkdb.kademlia.IterativeSearchJob;
import net.i2p.util.Log;

class IterativeLookupSelector
implements MessageSelector {
    private final RouterContext _context;
    private final IterativeSearchJob _search;
    private boolean _matchFound;
    private final Log _log;

    public IterativeLookupSelector(RouterContext ctx, IterativeSearchJob search) {
        this._context = ctx;
        this._search = search;
        this._log = ctx.logManager().getLog(this.getClass());
    }

    public boolean continueMatching() {
        return !this._matchFound && this._context.clock().now() < this.getExpiration();
    }

    public long getExpiration() {
        return this._matchFound ? -1L : this._search.getExpiration();
    }

    public boolean isMatch(I2NPMessage message) {
        if (message == null) {
            return false;
        }
        if (message instanceof DatabaseStoreMessage) {
            DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
            if (this._search.getKey().equals((Object)dsm.getKey())) {
                this._matchFound = true;
                return true;
            }
        } else if (message instanceof DatabaseSearchReplyMessage) {
            DatabaseSearchReplyMessage dsrm = (DatabaseSearchReplyMessage)message;
            if (this._search.getKey().equals((Object)dsrm.getSearchKey())) {
                if (this._log.shouldLog(20)) {
                    Hash from = dsrm.getFromHash();
                    this._log.info(this._search.getJobId() + ": Processing DSRM via IterativeLookupJob, apparently from " + from);
                }
                this._context.jobQueue().addJob(new IterativeLookupJob(this._context, dsrm, this._search));
            }
        }
        return false;
    }
}

