/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.IterativeFollowupJob;
import net.i2p.router.networkdb.kademlia.IterativeSearchJob;

class IterativeLookupJob
extends JobImpl {
    private final DatabaseSearchReplyMessage _dsrm;
    private final IterativeSearchJob _search;

    public IterativeLookupJob(RouterContext ctx, DatabaseSearchReplyMessage dsrm, IterativeSearchJob search) {
        super(ctx);
        this._dsrm = dsrm;
        this._search = search;
    }

    public void runJob() {
        Hash from = this._dsrm.getFromHash();
        int limit = Math.min(this._dsrm.getNumReplies(), 8);
        int newPeers = 0;
        int oldPeers = 0;
        int invalidPeers = 0;
        for (int i = 0; i < limit; ++i) {
            Hash peer = this._dsrm.getReply(i);
            if (peer.equals((Object)this.getContext().routerHash())) {
                ++oldPeers;
                continue;
            }
            if (peer.equals((Object)from)) {
                ++invalidPeers;
                continue;
            }
            RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(peer);
            if (ri == null) {
                this.getContext().jobQueue().addJob(new IterativeFollowupJob(this.getContext(), peer, from, this._search));
                ++newPeers;
                continue;
            }
            if (ri.getPublished() < this.getContext().clock().now() - 3600000L || !FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
                this.getContext().jobQueue().addJob(new IterativeFollowupJob(this.getContext(), peer, peer, this._search));
                ++oldPeers;
                continue;
            }
            this._search.newPeerToTry(peer);
            ++oldPeers;
        }
        long timeSent = this._search.timeSent(from);
        if (timeSent > 0L) {
            this.getContext().profileManager().dbLookupReply(from, newPeers, oldPeers, invalidPeers, 0, this.getContext().clock().now() - timeSent);
        }
        this._search.failed(this._dsrm.getFromHash(), false);
    }

    public String getName() {
        return "NetDb process DSRM";
    }
}

