/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.SendMessageDirectJob;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class HarvesterJob
extends JobImpl {
    private Log _log;
    private KademliaNetworkDatabaseFacade _facade;
    private static final long REQUEUE_DELAY = 60000L;
    private static final long MIN_UPDATE_FREQUENCY = 1800000L;
    private static final int MAX_PER_RUN = 5;
    private static final int PRIORITY = 100;
    public static final String PROP_ENABLED = "netDb.shouldHarvest";

    private boolean harvestDirectly() {
        return this.getContext().getBooleanProperty("netDb.harvestDirectly");
    }

    public HarvesterJob(RouterContext context, KademliaNetworkDatabaseFacade facade) {
        super(context);
        this._facade = facade;
        this._log = context.logManager().getLog(HarvesterJob.class);
    }

    public String getName() {
        return "Harvest the netDb";
    }

    public void runJob() {
        if (this.shouldHarvest()) {
            List peers = this.selectPeersToUpdate();
            for (int i = 0; i < peers.size(); ++i) {
                Hash peer = (Hash)peers.get(i);
                this.harvest(peer);
            }
        }
        this.requeue(60000L);
    }

    private boolean shouldHarvest() {
        String should = this.getContext().getProperty(PROP_ENABLED, "false");
        return should != null && "true".equals(should);
    }

    private List selectPeersToUpdate() {
        TreeMap<Long, Hash> routersByAge = new TreeMap<Long, Hash>();
        Set<Hash> peers = this._facade.getAllRouters();
        long now = this.getContext().clock().now();
        for (Hash peer : peers) {
            long when;
            RouterInfo info = this._facade.lookupRouterInfoLocally(peer);
            if (info == null || (when = info.getPublished()) + 1800000L > now) continue;
            while (routersByAge.containsKey(when)) {
                ++when;
            }
            routersByAge.put(when, info.getIdentity().getHash());
        }
        ArrayList<Hash> rv = new ArrayList<Hash>();
        for (Hash peer : routersByAge.values()) {
            rv.add(peer);
            if (rv.size() < 5) continue;
            break;
        }
        return rv;
    }

    private void harvest(Hash peer) {
        long now = this.getContext().clock().now();
        if (this.harvestDirectly()) {
            DatabaseLookupMessage msg = new DatabaseLookupMessage(this.getContext(), true);
            msg.setFrom(this.getContext().routerHash());
            msg.setMessageExpiration(10000L + now);
            msg.setSearchKey(peer);
            msg.setReplyTunnel(null);
            SendMessageDirectJob job = new SendMessageDirectJob(this.getContext(), msg, peer, 10000, 100);
            job.runJob();
        } else {
            TunnelInfo replyTunnel = this.getContext().tunnelManager().selectInboundTunnel();
            TunnelInfo sendTunnel = this.getContext().tunnelManager().selectOutboundTunnel();
            if (replyTunnel != null && sendTunnel != null) {
                DatabaseLookupMessage msg = new DatabaseLookupMessage(this.getContext(), true);
                msg.setFrom(replyTunnel.getPeer(0));
                msg.setMessageExpiration(10000L + now);
                msg.setSearchKey(peer);
                msg.setReplyTunnel(replyTunnel.getReceiveTunnelId(0));
                this.getContext().tunnelDispatcher().dispatchOutbound(msg, sendTunnel.getSendTunnelId(0), peer);
            }
        }
    }
}

