/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.dummy;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.i2p.data.Hash;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

public class VMCommSystem
extends CommSystemFacade {
    private final Log _log;
    private final RouterContext _context;
    private static Map _commSystemFacades = Collections.synchronizedMap(new HashMap(16));

    public VMCommSystem(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(VMCommSystem.class);
        this._context.statManager().createFrequencyStat("transport.sendMessageFailureFrequency", "How often do we fail to send messages?", "Transport", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.sendMessageSize", "Size of sent messages (bytes)", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.receiveMessageSize", "Size of received messages (bytes)", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.sendMessageSmall", "How many messages under 1KB are sent?", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.receiveMessageSmall", "How many messages under 1KB are received?", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.sendMessageMedium", "How many messages between 1KB and 4KB are sent?", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.receiveMessageMedium", "How many messages between 1KB and 4KB are received?", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.sendMessageLarge", "How many messages over 4KB are sent?", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.receiveMessageLarge", "How many messages over 4KB are received?", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.sendProcessingTime", "Time to process and send a message (ms)", "Transport", new long[]{60000L, 600000L, 3600000L, 86400000L});
    }

    public void processMessage(OutNetMessage msg) {
        Hash peer = msg.getTarget().getIdentity().getHash();
        VMCommSystem peerSys = (VMCommSystem)_commSystemFacades.get(peer);
        long now = this._context.clock().now();
        long sendTime = now - msg.getSendBegin();
        boolean sendSuccessful = false;
        if (peerSys == null) {
            this._context.jobQueue().addJob(msg.getOnFailedSendJob());
            this._context.statManager().updateFrequency("transport.sendMessageFailureFrequency");
            this._context.profileManager().messageFailed(msg.getTarget().getIdentity().getHash(), "vm");
        } else {
            this._context.jobQueue().addJob(msg.getOnSendJob());
            this._context.profileManager().messageSent(msg.getTarget().getIdentity().getHash(), "vm", sendTime, msg.getMessageSize());
            byte[] data = new byte[(int)msg.getMessageSize()];
            msg.getMessageData(data);
            this._context.statManager().addRateData("transport.sendMessageSize", (long)data.length, sendTime);
            if (data.length < 1024) {
                this._context.statManager().addRateData("transport.sendMessageSmall", 1L, sendTime);
            } else if (data.length <= 4096) {
                this._context.statManager().addRateData("transport.sendMessageMedium", 1L, sendTime);
            } else {
                this._context.statManager().addRateData("transport.sendMessageLarge", 1L, sendTime);
            }
            peerSys.receive(data, this._context.routerHash());
            sendSuccessful = true;
        }
        I2NPMessage dmsg = msg.getMessage();
        String type = dmsg.getClass().getName();
        this._context.messageHistory().sendMessage(type, dmsg.getUniqueId(), dmsg.getMessageExpiration(), msg.getTarget().getIdentity().getHash(), sendSuccessful, null);
        msg.discardData();
        this._context.statManager().addRateData("transport.sendProcessingTime", msg.getLifetime(), msg.getLifetime());
    }

    public void receive(byte[] message, Hash fromPeer) {
        this._context.jobQueue().addJob(new ReceiveJob(fromPeer, message, this._context));
    }

    public void shutdown() {
        _commSystemFacades.remove(this._context.routerHash());
    }

    public void startup() {
        _commSystemFacades.put(this._context.routerHash(), this);
    }

    public void restart() {
        _commSystemFacades.remove(this._context.routerHash());
        _commSystemFacades.put(this._context.routerHash(), this);
    }

    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        out.write("Dummy! i2p.vmCommSystem=true!");
    }

    private class ReceiveJob
    extends JobImpl {
        private Hash _from;
        private byte[] _msg;
        private RouterContext _ctx;

        public ReceiveJob(Hash from, byte[] msg, RouterContext us) {
            super(us);
            this._ctx = us;
            this._from = from;
            this._msg = msg;
            this.getTiming().setStartAfter(us.clock().now());
        }

        public void runJob() {
            I2NPMessageHandler handler = new I2NPMessageHandler(this._ctx);
            try {
                I2NPMessage msg = handler.readMessage(this._msg);
                int size = this._msg.length;
                this._ctx.profileManager().messageReceived(this._from, "vm", 1L, size);
                this._ctx.statManager().addRateData("transport.receiveMessageSize", (long)size, 1L);
                if (size < 1024) {
                    this.getContext().statManager().addRateData("transport.receiveMessageSmall", 1L, 1L);
                } else if (size <= 4096) {
                    this.getContext().statManager().addRateData("transport.receiveMessageMedium", 1L, 1L);
                } else {
                    this.getContext().statManager().addRateData("transport.receiveMessageLarge", 1L, 1L);
                }
                this._ctx.inNetMessagePool().add(msg, null, this._from);
            }
            catch (Exception e) {
                VMCommSystem.this._log.error("wtf, error reading/formatting a VM message?", (Throwable)e);
            }
        }

        public String getName() {
            return "Receive Message";
        }
    }
}

