/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.HashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import net.i2p.data.Base32;
import net.i2p.data.Base64;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientListenerRunner;
import net.i2p.router.client.ClientManager;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.ShellCommand;

class SSLClientListenerRunner
extends ClientListenerRunner {
    private SSLServerSocketFactory _factory;
    private static final String PROP_KEYSTORE_PASSWORD = "i2cp.keystorePassword";
    private static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static final String PROP_KEY_PASSWORD = "i2cp.keyPassword";
    private static final String KEY_ALIAS = "i2cp";
    private static final String ASCII_KEYFILE = "i2cp.local.crt";
    private static final int LINE_LENGTH = 64;

    public SSLClientListenerRunner(RouterContext context, ClientManager manager, int port) {
        super(context, manager, port);
    }

    private boolean verifyKeyStore(File ks) {
        SecureDirectory sdir;
        if (ks.exists()) {
            boolean rv;
            boolean bl = rv = this._context.getProperty(PROP_KEY_PASSWORD) != null;
            if (!rv) {
                this._log.error("I2CP SSL error, must set i2cp.keyPassword in " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath());
            }
            return rv;
        }
        File dir = ks.getParentFile();
        if (!dir.exists() && !(sdir = new SecureDirectory(dir.getAbsolutePath())).mkdir()) {
            return false;
        }
        boolean rv = this.createKeyStore(ks);
        if (rv) {
            this.exportCert(ks);
        }
        return rv;
    }

    private boolean createKeyStore(File ks) {
        byte[] rand = new byte[30];
        this._context.random().nextBytes(rand);
        String keyPassword = Base32.encode((byte[])rand);
        this._context.random().nextBytes(rand);
        String cname = Base32.encode((byte[])rand) + ".i2cp.i2p.net";
        String keytool = new File(System.getProperty("java.home"), "bin/keytool").getAbsolutePath();
        String[] args = new String[]{keytool, "-genkey", "-storetype", KeyStore.getDefaultType(), "-keystore", ks.getAbsolutePath(), "-storepass", DEFAULT_KEYSTORE_PASSWORD, "-alias", KEY_ALIAS, "-dname", "CN=" + cname + ",OU=I2CP,O=I2P Anonymous Network,L=XX,ST=XX,C=XX", "-validity", "3652", "-keyalg", "DSA", "-keysize", "1024", "-keypass", keyPassword};
        boolean success = new ShellCommand().executeSilentAndWaitTimed(args, 30);
        if (success && (success = ks.exists())) {
            SecureFileOutputStream.setPerms((File)ks);
            HashMap<String, String> changes = new HashMap<String, String>();
            changes.put(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
            changes.put(PROP_KEY_PASSWORD, keyPassword);
            this._context.router().saveConfig(changes, null);
        }
        if (success) {
            this._log.logAlways(20, "Created self-signed certificate for " + cname + " in keystore: " + ks.getAbsolutePath() + "\n" + "The certificate name was generated randomly, and is not associated with your " + "IP address, host name, router identity, or destination keys.");
        } else {
            this._log.error("Failed to create I2CP SSL keystore using command line:");
            StringBuilder buf = new StringBuilder(256);
            for (int i = 0; i < args.length; ++i) {
                buf.append('\"').append(args[i]).append("\" ");
            }
            this._log.error(buf.toString());
            this._log.error("This is for the Sun/Oracle keytool, others may be incompatible.\nIf you create the keystore manually, you must add i2cp.keystorePassword and i2cp.keyPassword to " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath());
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportCert(File ks) {
        SecureDirectory sdir = new SecureDirectory(this._context.getConfigDir(), "certificates");
        if (sdir.exists() || sdir.mkdir()) {
            InputStream fis = null;
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                fis = new FileInputStream(ks);
                String ksPass = this._context.getProperty(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
                keyStore.load(fis, ksPass.toCharArray());
                Certificate cert = keyStore.getCertificate(KEY_ALIAS);
                if (cert != null) {
                    File certFile = new File((File)sdir, ASCII_KEYFILE);
                    this.saveCert(cert, certFile);
                }
                this._log.error("Error getting SSL cert to save as ASCII");
            }
            catch (GeneralSecurityException gse) {
                this._log.error("Error saving ASCII SSL keys", (Throwable)gse);
            }
            catch (IOException ioe) {
                this._log.error("Error saving ASCII SSL keys", (Throwable)ioe);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        } else {
            this._log.error("Error saving ASCII SSL keys");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCert(Certificate cert, File file) {
        OutputStream os = null;
        try {
            byte[] buf = cert.getEncoded();
            os = new SecureFileOutputStream(file);
            PrintWriter wr = new PrintWriter(os);
            wr.println("-----BEGIN CERTIFICATE-----");
            String b64 = Base64.encode((byte[])buf, (boolean)true);
            for (int i = 0; i < b64.length(); i += 64) {
                wr.println(b64.substring(i, Math.min(i + 64, b64.length())));
            }
            wr.println("-----END CERTIFICATE-----");
            wr.flush();
        }
        catch (CertificateEncodingException cee) {
            this._log.error("Error writing X509 Certificate " + file.getAbsolutePath(), (Throwable)cee);
        }
        catch (IOException ioe) {
            this._log.error("Error writing X509 Certificate " + file.getAbsolutePath(), (Throwable)ioe);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException foo) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeFactory(File ks) {
        String ksPass = this._context.getProperty(PROP_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD);
        String keyPass = this._context.getProperty(PROP_KEY_PASSWORD);
        if (keyPass == null) {
            this._log.error("No key password, set i2cp.keyPassword in " + new File(this._context.getConfigDir(), "router.config").getAbsolutePath());
            return false;
        }
        InputStream fis = null;
        try {
            SSLContext sslc = SSLContext.getInstance("TLS");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(ks);
            keyStore.load(fis, ksPass.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keyPass.toCharArray());
            sslc.init(kmf.getKeyManagers(), null, (SecureRandom)this._context.random());
            this._factory = sslc.getServerSocketFactory();
            boolean bl = true;
            return bl;
        }
        catch (GeneralSecurityException gse) {
            this._log.error("Error loading SSL keys", (Throwable)gse);
        }
        catch (IOException ioe) {
            this._log.error("Error loading SSL keys", (Throwable)ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        return false;
    }

    protected ServerSocket getServerSocket() throws IOException {
        ServerSocket rv;
        if (this._bindAllInterfaces) {
            if (this._log.shouldLog(20)) {
                this._log.info("Listening on port " + this._port + " on all interfaces");
            }
            rv = this._factory.createServerSocket(this._port);
        } else {
            String listenInterface = this._context.getProperty("i2cp.hostname", "127.0.0.1");
            if (this._log.shouldLog(20)) {
                this._log.info("Listening on port " + this._port + " of the specific interface: " + listenInterface);
            }
            rv = this._factory.createServerSocket(this._port, 0, InetAddress.getByName(listenInterface));
        }
        return rv;
    }

    public void runServer() {
        File keyStore = new File(this._context.getConfigDir(), "keystore/i2cp.ks");
        if (this.verifyKeyStore(keyStore) && this.initializeFactory(keyStore)) {
            super.runServer();
        } else {
            this._log.error("SSL I2CP server error - Failed to create or open key store");
        }
    }

    protected boolean validate(Socket socket) {
        try {
            InputStream is = socket.getInputStream();
            int oldTimeout = socket.getSoTimeout();
            socket.setSoTimeout(20000);
            boolean rv = is.read() == 42;
            socket.setSoTimeout(oldTimeout);
            return rv;
        }
        catch (IOException iOException) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Peer did not authenticate themselves as I2CP quickly enough, dropping");
            }
            return false;
        }
    }
}

