/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.internal.PoisonI2CPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;

class ClientWriterRunner
implements Runnable {
    private final BlockingQueue<I2CPMessage> _messagesToWrite = new LinkedBlockingQueue<I2CPMessage>(256);
    private final ClientConnectionRunner _runner;
    private static final int QUEUE_SIZE = 256;

    public ClientWriterRunner(RouterContext context, ClientConnectionRunner runner) {
        this._runner = runner;
    }

    public void addMessage(I2CPMessage msg) throws I2CPMessageException {
        boolean success = this._messagesToWrite.offer(msg);
        if (!success) {
            throw new I2CPMessageException("I2CP write to queue failed");
        }
    }

    public void stopWriting() {
        this._messagesToWrite.clear();
        try {
            this._messagesToWrite.put((I2CPMessage)new PoisonI2CPMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this._runner.getIsDead()) {
            I2CPMessage msg;
            try {
                msg = this._messagesToWrite.take();
            }
            catch (InterruptedException ie) {
                continue;
            }
            if (msg.getType() == 999999) break;
            this._runner.writeMessage(msg);
        }
    }
}

