/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;

public abstract class FastI2NPMessageImpl
extends I2NPMessageImpl {
    protected byte _checksum;
    protected boolean _hasChecksum;
    private static final boolean VERIFY_TEST = false;

    public FastI2NPMessageImpl(I2PAppContext context) {
        super(context);
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        throw new UnsupportedOperationException();
    }

    public int readBytes(InputStream in, int type, byte[] buffer) throws I2NPMessageException, IOException {
        throw new UnsupportedOperationException();
    }

    public int readBytes(byte[] data, int type, int offset, int maxLen) throws I2NPMessageException {
        if (this._hasChecksum) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " read twice");
        }
        int headerSize = 16;
        if (type >= 0) {
            --headerSize;
        }
        if (maxLen < headerSize) {
            throw new I2NPMessageException("Payload is too short " + maxLen);
        }
        int cur = offset;
        if (type < 0) {
            type = (int)DataHelper.fromLong((byte[])data, (int)cur, (int)1);
            ++cur;
        }
        this._uniqueId = DataHelper.fromLong((byte[])data, (int)cur, (int)4);
        this._expiration = DataHelper.fromLong((byte[])data, (int)(cur += 4), (int)8);
        int size = (int)DataHelper.fromLong((byte[])data, (int)(cur += 8), (int)2);
        this._checksum = data[cur += 2];
        if (++cur + size > data.length || headerSize + size > maxLen) {
            throw new I2NPMessageException("Payload is too short [data.len=" + data.length + "maxLen=" + maxLen + " offset=" + offset + " cur=" + cur + " wanted=" + size + "]: " + this.getClass().getSimpleName());
        }
        int sz = Math.min(size, maxLen - headerSize);
        this.readMessage(data, cur, sz, type);
        this._hasChecksum = true;
        return (cur += sz) - offset;
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        throw new UnsupportedOperationException();
    }

    public int toByteArray(byte[] buffer) {
        if (this._hasChecksum) {
            return this.toByteArrayWithSavedChecksum(buffer);
        }
        return super.toByteArray(buffer);
    }

    protected int toByteArrayWithSavedChecksum(byte[] buffer) {
        try {
            int writtenLen = this.writeMessageBody(buffer, 16);
            int payloadLen = writtenLen - 16;
            int off = 0;
            DataHelper.toLong((byte[])buffer, (int)off, (int)1, (long)this.getType());
            DataHelper.toLong((byte[])buffer, (int)(++off), (int)4, (long)this._uniqueId);
            DataHelper.toLong((byte[])buffer, (int)(off += 4), (int)8, (long)this._expiration);
            DataHelper.toLong((byte[])buffer, (int)(off += 8), (int)2, (long)payloadLen);
            buffer[off += 2] = this._checksum;
            return writtenLen;
        }
        catch (I2NPMessageException ime) {
            this._context.logManager().getLog(this.getClass()).log(50, "Error writing", (Throwable)((Object)ime));
            throw new IllegalStateException("Unable to serialize the message " + this.getClass().getSimpleName(), (Throwable)((Object)ime));
        }
    }
}

