/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Lease;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.VersionComparator;

public class RequestVariableLeaseSetMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 37;
    private SessionId _sessionId;
    private final List<Lease> _endpoints = new ArrayList<Lease>();
    private static final String MIN_VERSION = "0.9.7";

    public static boolean isSupported(String clientVersion) {
        return clientVersion != null && VersionComparator.comp(clientVersion, MIN_VERSION) >= 0;
    }

    public SessionId getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public int getEndpoints() {
        return this._endpoints.size();
    }

    public Lease getEndpoint(int endpoint) {
        if (endpoint < 0 || this._endpoints.size() <= endpoint) {
            return null;
        }
        return this._endpoints.get(endpoint);
    }

    public void addEndpoint(Lease lease) {
        if (lease == null) {
            throw new IllegalArgumentException();
        }
        this._endpoints.add(lease);
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            if (this._sessionId != null) {
                throw new IllegalStateException();
            }
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            int numTunnels = (int)DataHelper.readLong(in, 1);
            for (int i = 0; i < numTunnels; ++i) {
                Lease lease = new Lease();
                lease.readBytes(in);
                this._endpoints.add(lease);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId == null) {
            throw new I2CPMessageException("No data");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(256);
        try {
            this._sessionId.writeBytes(os);
            DataHelper.writeLong(os, 1, this._endpoints.size());
            for (int i = 0; i < this._endpoints.size(); ++i) {
                this._endpoints.get(i).writeBytes(os);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 37;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[RequestVariableLeaseSetMessage: ");
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("\n\tTunnels:");
        for (int i = 0; i < this.getEndpoints(); ++i) {
            buf.append('\n').append(this._endpoints.get(i));
        }
        buf.append("]");
        return buf.toString();
    }
}

