/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import net.i2p.I2PAppContext;
import net.i2p.crypto.ElGamalAESEngine;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

public class AESEngine {
    protected final Log _log;
    protected final I2PAppContext _context;

    public AESEngine(I2PAppContext ctx) {
        this._context = ctx;
        this._log = this._context.logManager().getLog(this.getClass());
        if (this.getClass().equals(AESEngine.class)) {
            this._log.logAlways(30, "AES is disabled");
        }
    }

    public void encrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int length) {
        this.encrypt(payload, payloadIndex, out, outIndex, sessionKey, iv, 0, length);
    }

    public void encrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int ivOffset, int length) {
        System.arraycopy(payload, payloadIndex, out, outIndex, length);
        this._log.logAlways(30, "AES is disabled");
    }

    public byte[] safeEncrypt(byte[] payload, SessionKey sessionKey, byte[] iv, int paddedSize) {
        if (iv == null || payload == null || sessionKey == null || iv.length != 16) {
            return null;
        }
        int size = 36 + payload.length;
        int padding = ElGamalAESEngine.getPaddingSize(size, paddedSize);
        byte[] data = new byte[size + padding];
        this._context.sha().calculateHash(iv, 0, 16, data, 0);
        int cur = 32;
        DataHelper.toLong(data, cur, 4, payload.length);
        System.arraycopy(payload, 0, data, cur += 4, payload.length);
        byte[] paddingData = ElGamalAESEngine.getPadding(this._context, size, paddedSize);
        System.arraycopy(paddingData, 0, data, cur += payload.length, paddingData.length);
        this.encrypt(data, 0, data, 0, sessionKey, iv, data.length);
        return data;
    }

    public byte[] safeDecrypt(byte[] payload, SessionKey sessionKey, byte[] iv) {
        long len;
        if (iv == null || payload == null || sessionKey == null || iv.length != 16) {
            return null;
        }
        byte[] decr = new byte[payload.length];
        this.decrypt(payload, 0, decr, 0, sessionKey, iv, payload.length);
        if (decr == null) {
            this._log.error("Error decrypting the data - payload " + payload.length + " decrypted to null");
            return null;
        }
        byte[] h = SimpleByteCache.acquire(32);
        this._context.sha().calculateHash(iv, 0, 16, h, 0);
        boolean eq = DataHelper.eq(decr, 0, h, 0, 32);
        SimpleByteCache.release(h);
        if (!eq) {
            this._log.error("Hash does not match [key=" + sessionKey + " / iv =" + DataHelper.toString(iv, iv.length) + "]", new Exception("Hash error"));
            return null;
        }
        int cur = 32;
        if ((long)(cur += 4) + (len = DataHelper.fromLong(decr, cur, 4)) > (long)decr.length) {
            this._log.error("Not enough to read");
            return null;
        }
        byte[] data = new byte[(int)len];
        System.arraycopy(decr, cur, data, 0, (int)len);
        return data;
    }

    public void decrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int length) {
        this.decrypt(payload, payloadIndex, out, outIndex, sessionKey, iv, 0, length);
    }

    public void decrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int ivOffset, int length) {
        System.arraycopy(payload, payloadIndex, out, outIndex, length);
        this._log.logAlways(30, "AES is disabled");
    }

    public void encryptBlock(byte[] payload, int inIndex, SessionKey sessionKey, byte[] out, int outIndex) {
        System.arraycopy(payload, inIndex, out, outIndex, out.length - outIndex);
    }

    public void decryptBlock(byte[] payload, int inIndex, SessionKey sessionKey, byte[] rv, int outIndex) {
        System.arraycopy(payload, inIndex, rv, outIndex, rv.length - outIndex);
    }
}

