/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import net.i2p.data.DataHelper;
import net.i2p.util.RandomSource;
import org.klomp.snark.BitField;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.bencode.BDecoder;
import org.klomp.snark.bencode.BEValue;

class MagnetState {
    public static final int CHUNK_SIZE = 16384;
    private final byte[] infohash;
    private boolean complete;
    private boolean isInitialized;
    private int metaSize;
    private int totalChunks;
    private BitField requested;
    private BitField have;
    private byte[] metainfoBytes;
    private MetaInfo metainfo;

    public MagnetState(byte[] iHash, MetaInfo meta) {
        this.infohash = iHash;
        if (meta != null) {
            this.metainfo = meta;
            this.initialize(meta.getInfoBytes().length);
            this.complete = true;
        }
    }

    public void initialize(int size) {
        if (this.isInitialized) {
            throw new IllegalArgumentException("already set");
        }
        this.isInitialized = true;
        this.metaSize = size;
        this.totalChunks = (size + 16383) / 16384;
        if (this.metainfo != null) {
            this.metainfoBytes = this.metainfo.getInfoBytes();
        } else {
            this.have = new BitField(this.totalChunks);
            this.requested = new BitField(this.totalChunks);
            this.metainfoBytes = new byte[this.metaSize];
        }
    }

    public void setMetaInfo(MetaInfo meta) {
        this.metainfo = meta;
    }

    public MetaInfo getMetaInfo() {
        if (!this.complete) {
            throw new IllegalArgumentException("not complete");
        }
        return this.metainfo;
    }

    public int getSize() {
        if (!this.isInitialized) {
            throw new IllegalArgumentException("not initialized");
        }
        return this.metaSize;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int chunkSize(int chunk) {
        return Math.min(16384, this.metaSize - chunk * 16384);
    }

    public int chunksRemaining() {
        if (!this.isInitialized) {
            throw new IllegalArgumentException("not initialized");
        }
        if (this.complete) {
            return 0;
        }
        return this.totalChunks - this.have.count();
    }

    public int getNextRequest() {
        int chk;
        int i;
        if (!this.isInitialized) {
            throw new IllegalArgumentException("not initialized");
        }
        if (this.complete) {
            throw new IllegalArgumentException("complete");
        }
        int rand = RandomSource.getInstance().nextInt(this.totalChunks);
        for (i = 0; i < this.totalChunks; ++i) {
            chk = (i + rand) % this.totalChunks;
            if (this.have.get(chk) || this.requested.get(chk)) continue;
            this.requested.set(chk);
            return chk;
        }
        for (i = 0; i < this.totalChunks; ++i) {
            chk = (i + rand) % this.totalChunks;
            if (this.have.get(chk)) continue;
            return chk;
        }
        throw new IllegalArgumentException("complete");
    }

    public byte[] getChunk(int chunk) {
        if (!this.complete) {
            throw new IllegalArgumentException("not complete");
        }
        if (chunk < 0 || chunk >= this.totalChunks) {
            throw new IllegalArgumentException("bad chunk number");
        }
        int size = this.chunkSize(chunk);
        byte[] rv = new byte[size];
        System.arraycopy(this.metainfoBytes, chunk * 16384, rv, 0, size);
        return rv;
    }

    public boolean saveChunk(int chunk, byte[] data, int off, int length) throws Exception {
        if (!this.isInitialized) {
            throw new IllegalArgumentException("not initialized");
        }
        if (chunk < 0 || chunk >= this.totalChunks) {
            throw new IllegalArgumentException("bad chunk number");
        }
        if (this.have.get(chunk)) {
            return false;
        }
        int size = this.chunkSize(chunk);
        if (size != length) {
            throw new IllegalArgumentException("bad chunk length");
        }
        System.arraycopy(data, off, this.metainfoBytes, chunk * 16384, size);
        this.have.set(chunk);
        boolean done = this.have.complete();
        if (done) {
            this.metainfo = this.buildMetaInfo();
            this.complete = true;
        }
        return done;
    }

    public MetaInfo buildMetaInfo() throws Exception {
        HashMap<String, BEValue> map = new HashMap<String, BEValue>();
        ByteArrayInputStream is = new ByteArrayInputStream(this.metainfoBytes);
        BDecoder dec = new BDecoder(is);
        BEValue bev = dec.bdecodeMap();
        map.put("info", bev);
        MetaInfo newmeta = new MetaInfo(map);
        if (!DataHelper.eq(newmeta.getInfoHash(), this.infohash)) {
            this.have = new BitField(this.totalChunks);
            this.requested = new BitField(this.totalChunks);
            throw new IOException("info hash mismatch");
        }
        return newmeta;
    }
}

