/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.util.Map;
import java.util.Properties;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.PeerCoordinatorSet;

class IdleChecker
extends SimpleTimer2.TimedEvent {
    private final I2PSnarkUtil _util;
    private final PeerCoordinatorSet _pcs;
    private final Log _log;
    private int _consec;
    private boolean _isIdle;
    private static final long CHECK_TIME = 63000L;
    private static final int MAX_CONSEC_IDLE = 4;

    public IdleChecker(I2PSnarkUtil util, PeerCoordinatorSet pcs) {
        super(util.getContext().simpleTimer2());
        this._log = util.getContext().logManager().getLog(IdleChecker.class);
        this._util = util;
        this._pcs = pcs;
    }

    public void timeReached() {
        if (this._util.connected()) {
            boolean hasPeers = false;
            for (PeerCoordinator pc : this._pcs) {
                if (pc.getPeers() <= 0) continue;
                hasPeers = true;
                break;
            }
            if (hasPeers) {
                if (this._isIdle) {
                    this.restoreTunnels();
                }
            } else if (!this._isIdle && this._consec++ >= 4) {
                this.reduceTunnels();
            }
        } else {
            this._isIdle = false;
            this._consec = 0;
        }
        this.schedule(63000L);
    }

    private void reduceTunnels() {
        this._isIdle = true;
        if (this._log.shouldLog(20)) {
            this._log.info("Reducing tunnels on idle");
        }
        this.setTunnels("1", "1", "0", "0");
    }

    private void restoreTunnels() {
        String ob;
        String ib;
        String o;
        Map<String, String> opts;
        String i;
        this._isIdle = false;
        if (this._log.shouldLog(20)) {
            this._log.info("Restoring tunnels on activity");
        }
        if ((i = (opts = this._util.getI2CPOptions()).get("inbound.quantity")) == null) {
            i = "3";
        }
        if ((o = opts.get("outbound.quantity")) == null) {
            o = "3";
        }
        if ((ib = opts.get("inbound.backupQuantity")) == null) {
            ib = "0";
        }
        if ((ob = opts.get("outbound.backupQuantity")) == null) {
            ob = "0";
        }
        this.setTunnels(i, o, ib, ob);
    }

    private void setTunnels(String i, String o, String ib, String ob) {
        I2PSession sess;
        this._consec = 0;
        I2PSocketManager mgr = this._util.getSocketManager();
        if (mgr != null && (sess = mgr.getSession()) != null) {
            Properties newProps = new Properties();
            newProps.setProperty("inbound.quantity", i);
            newProps.setProperty("outbound.quantity", o);
            newProps.setProperty("inbound.backupQuantity", ib);
            newProps.setProperty("outbound.backupQuantity", ob);
            sess.updateOptions(newProps);
        }
    }
}

