/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.kademlia;

import java.util.ArrayList;
import net.i2p.I2PAppContext;
import net.i2p.data.SimpleDataStructure;
import net.i2p.kademlia.KBucket;
import net.i2p.kademlia.KBucketTrimmer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomTrimmer<T extends SimpleDataStructure>
implements KBucketTrimmer<T> {
    protected final I2PAppContext _ctx;
    private final int _max;

    public RandomTrimmer(I2PAppContext ctx, int max) {
        this._ctx = ctx;
        this._max = max;
    }

    @Override
    public boolean trim(KBucket<T> kbucket, T toAdd) {
        ArrayList<T> e = new ArrayList<T>(kbucket.getEntries());
        int sz = e.size();
        if (sz < this._max) {
            return true;
        }
        SimpleDataStructure toRemove = (SimpleDataStructure)e.get(this._ctx.random().nextInt(sz));
        return kbucket.remove(toRemove);
    }
}

