/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.streaming.ConnThrottler;
import net.i2p.client.streaming.Connection;
import net.i2p.client.streaming.ConnectionHandler;
import net.i2p.client.streaming.ConnectionOptions;
import net.i2p.client.streaming.ConnectionPacketHandler;
import net.i2p.client.streaming.I2PSocketManagerFull;
import net.i2p.client.streaming.MessageHandler;
import net.i2p.client.streaming.MessageInputStream;
import net.i2p.client.streaming.Packet;
import net.i2p.client.streaming.PacketHandler;
import net.i2p.client.streaming.PacketLocal;
import net.i2p.client.streaming.PacketQueue;
import net.i2p.client.streaming.RetransmissionTimer;
import net.i2p.client.streaming.SchedulerChooser;
import net.i2p.client.streaming.TCBShare;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.ConvertToHash;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectionManager {
    private final I2PAppContext _context;
    private final Log _log;
    private final I2PSession _session;
    private final MessageHandler _messageHandler;
    private final PacketHandler _packetHandler;
    private final ConnectionHandler _connectionHandler;
    private final PacketQueue _outboundQueue;
    private final SchedulerChooser _schedulerChooser;
    private final ConnectionPacketHandler _conPacketHandler;
    private final TCBShare _tcbShare;
    private final ConcurrentHashMap<Long, Connection> _connectionByInboundId;
    private final Map<Long, PingRequest> _pendingPings;
    private volatile boolean _throttlersInitialized;
    private final ConnectionOptions _defaultOptions;
    private volatile int _numWaiting;
    private long _soTimeout;
    private volatile ConnThrottler _minuteThrottler;
    private volatile ConnThrottler _hourThrottler;
    private volatile ConnThrottler _dayThrottler;
    private final SimpleTimer2 _timer;
    private static volatile String _currentBlacklist = "";
    private static final Set<Hash> _globalBlacklist = new ConcurrentHashSet();
    public static final String PROP_BLACKLIST = "i2p.streaming.blacklist";
    private static final long DEFAULT_STREAM_DELAY_MAX = 10000L;

    public ConnectionManager(I2PAppContext context, I2PSession session, ConnectionOptions defaultOptions) {
        this._context = context;
        this._session = session;
        this._defaultOptions = defaultOptions;
        this._log = this._context.logManager().getLog(ConnectionManager.class);
        this._connectionByInboundId = new ConcurrentHashMap(32);
        this._pendingPings = new ConcurrentHashMap<Long, PingRequest>(4);
        this._messageHandler = new MessageHandler(this._context, this);
        this._packetHandler = new PacketHandler(this._context, this);
        this._connectionHandler = new ConnectionHandler(this._context, this);
        this._schedulerChooser = new SchedulerChooser(this._context);
        this._conPacketHandler = new ConnectionPacketHandler(this._context);
        this._timer = new RetransmissionTimer(this._context, "Streaming Timer " + session.getMyDestination().calculateHash().toBase64().substring(0, 4));
        this._tcbShare = new TCBShare(this._context, this._timer);
        int protocol = defaultOptions.getEnforceProtocol() ? 6 : 0;
        this._session.addMuxedSessionListener((I2PSessionMuxedListener)this._messageHandler, protocol, defaultOptions.getLocalPort());
        this._outboundQueue = new PacketQueue(this._context, this._session, this);
        this._soTimeout = -1L;
        this._context.statManager().createRateStat("stream.con.lifetimeMessagesSent", "How many messages do we send on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeMessagesReceived", "How many messages do we receive on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeBytesSent", "How many bytes do we send on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeBytesReceived", "How many bytes do we receive on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeDupMessagesSent", "How many duplicate messages do we send on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeDupMessagesReceived", "How many duplicate messages do we receive on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeRTT", "What is the final RTT when a stream closes?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeCongestionSeenAt", "When was the last congestion seen at when a stream closes?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeSendWindowSize", "What is the final send window size when a stream closes?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.receiveActive", "How many streams are active when a new one is received (period being not yet dropped)", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.windowSizeAtCongestion", "How large was our send window when we send a dup?", "Stream", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("stream.chokeSizeBegin", "How many messages were outstanding when we started to choke?", "Stream", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("stream.chokeSizeEnd", "How many messages were outstanding when we stopped being choked?", "Stream", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("stream.fastRetransmit", "How long a packet has been around for if it has been resent per the fast retransmit timer?", "Stream", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("stream.con.sendMessageSize", "Size of a message sent on a connection", "Stream", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("stream.con.sendDuplicateSize", "Size of a message resent on a connection", "Stream", new long[]{60000L, 600000L, 3600000L});
    }

    Connection getConnectionByInboundId(long id) {
        return this._connectionByInboundId.get(id);
    }

    Connection getConnectionByOutboundId(long id) {
        for (Connection con : this._connectionByInboundId.values()) {
            if (con.getSendStreamId() != id) continue;
            return con;
        }
        return null;
    }

    public void setSoTimeout(long x) {
        this._soTimeout = x;
    }

    public long getSoTimeout() {
        return this._soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowIncomingConnections(boolean allow) {
        this._connectionHandler.setActive(allow);
        if (allow) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                if (!this._throttlersInitialized) {
                    this.updateOptions();
                    this._throttlersInitialized = true;
                }
            }
        }
    }

    public synchronized void updateOptions() {
        if ((this._defaultOptions.getMaxConnsPerMinute() > 0 || this._defaultOptions.getMaxTotalConnsPerMinute() > 0) && this._minuteThrottler == null) {
            this._context.statManager().createRateStat("stream.con.throttledMinute", "Dropped for conn limit", "Stream", new long[]{300000L});
            this._minuteThrottler = new ConnThrottler(this._defaultOptions.getMaxConnsPerMinute(), this._defaultOptions.getMaxTotalConnsPerMinute(), 60000L);
        } else if (this._minuteThrottler != null) {
            this._minuteThrottler.updateLimits(this._defaultOptions.getMaxConnsPerMinute(), this._defaultOptions.getMaxTotalConnsPerMinute());
        }
        if ((this._defaultOptions.getMaxConnsPerHour() > 0 || this._defaultOptions.getMaxTotalConnsPerHour() > 0) && this._hourThrottler == null) {
            this._context.statManager().createRateStat("stream.con.throttledHour", "Dropped for conn limit", "Stream", new long[]{300000L});
            this._hourThrottler = new ConnThrottler(this._defaultOptions.getMaxConnsPerHour(), this._defaultOptions.getMaxTotalConnsPerHour(), 3600000L);
        } else if (this._hourThrottler != null) {
            this._hourThrottler.updateLimits(this._defaultOptions.getMaxConnsPerHour(), this._defaultOptions.getMaxTotalConnsPerHour());
        }
        if ((this._defaultOptions.getMaxConnsPerDay() > 0 || this._defaultOptions.getMaxTotalConnsPerDay() > 0) && this._dayThrottler == null) {
            this._context.statManager().createRateStat("stream.con.throttledDay", "Dropped for conn limit", "Stream", new long[]{300000L});
            this._dayThrottler = new ConnThrottler(this._defaultOptions.getMaxConnsPerDay(), this._defaultOptions.getMaxTotalConnsPerDay(), 86400000L);
        } else if (this._dayThrottler != null) {
            this._dayThrottler.updateLimits(this._defaultOptions.getMaxConnsPerDay(), this._defaultOptions.getMaxTotalConnsPerDay());
        }
    }

    public boolean getAllowIncomingConnections() {
        return this._connectionHandler.getActive();
    }

    public Connection receiveConnection(Packet synPacket) {
        ConnectionOptions opts = new ConnectionOptions(this._defaultOptions);
        opts.setPort(synPacket.getRemotePort());
        opts.setLocalPort(synPacket.getLocalPort());
        Connection con = new Connection(this._context, this, this._schedulerChooser, this._timer, this._outboundQueue, this._conPacketHandler, opts);
        this._tcbShare.updateOptsFromShare(con);
        con.setInbound();
        long receiveId = this._context.random().nextLong(0xFFFFFFFEL) + 1L;
        boolean reject = false;
        int active = 0;
        int total = 0;
        if (this.locked_tooManyStreams()) {
            if (!this._defaultOptions.getDisableRejectLogging() || this._log.shouldLog(30)) {
                this._log.logAlways(30, "Refusing connection since we have exceeded our max of " + this._defaultOptions.getMaxConns() + " connections");
            }
            reject = true;
        } else {
            String why = this.shouldRejectConnection(synPacket);
            if (why != null) {
                if (!this._defaultOptions.getDisableRejectLogging() || this._log.shouldLog(30)) {
                    this._log.logAlways(30, "Refusing connection since peer is " + why + (synPacket.getOptionalFrom() == null ? "" : ": " + synPacket.getOptionalFrom().calculateHash().toBase64()));
                }
                reject = true;
            } else {
                Connection oldCon;
                while ((oldCon = this._connectionByInboundId.putIfAbsent(receiveId, con)) != null) {
                    receiveId = this._context.random().nextLong(0xFFFFFFFEL) + 1L;
                }
            }
        }
        this._context.statManager().addRateData("stream.receiveActive", (long)active, (long)total);
        if (reject) {
            Destination from = synPacket.getOptionalFrom();
            if (from == null) {
                return null;
            }
            if (this._dayThrottler != null || this._hourThrottler != null) {
                Hash h = from.calculateHash();
                if (this._hourThrottler != null && this._hourThrottler.isThrottled(h) || this._dayThrottler != null && this._dayThrottler.isThrottled(h) || _globalBlacklist.contains(h) || this._defaultOptions.isAccessListEnabled() && !this._defaultOptions.getAccessList().contains(h) || this._defaultOptions.isBlacklistEnabled() && this._defaultOptions.getBlacklist().contains(h)) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Dropping RST to " + h);
                    }
                    return null;
                }
            }
            PacketLocal reply = new PacketLocal(this._context, from);
            reply.setFlag(4);
            reply.setFlag(8);
            reply.setAckThrough(synPacket.getSequenceNum());
            reply.setSendStreamId(synPacket.getReceiveStreamId());
            reply.setReceiveStreamId(0L);
            reply.setOptionalFrom(this._session.getMyDestination());
            this._outboundQueue.enqueue(reply);
            return null;
        }
        con.setReceiveStreamId(receiveId);
        if (I2PSocketManagerFull.pcapWriter != null && this._context.getBooleanProperty("i2p.streaming.pcap")) {
            synPacket.logTCPDump(con);
        }
        try {
            con.getPacketHandler().receivePacket(synPacket, con);
        }
        catch (I2PException ie) {
            this._connectionByInboundId.remove(receiveId);
            return null;
        }
        this._context.statManager().addRateData("stream.connectionReceived", 1L, 0L);
        return con;
    }

    public Connection connect(Destination peer, ConnectionOptions opts) {
        Connection con = null;
        long receiveId = this._context.random().nextLong(0xFFFFFFFEL) + 1L;
        long expiration = this._context.clock().now() + opts.getConnectTimeout();
        if (opts.getConnectTimeout() <= 0L) {
            expiration = this._context.clock().now() + 10000L;
        }
        ++this._numWaiting;
        while (true) {
            long remaining;
            if ((remaining = expiration - this._context.clock().now()) <= 0L) {
                this._log.logAlways(30, "Refusing to connect since we have exceeded our max of " + this._defaultOptions.getMaxConns() + " connections");
                --this._numWaiting;
                return null;
            }
            if (!this.locked_tooManyStreams()) break;
            int max = this._defaultOptions.getMaxConns();
            if (this._numWaiting > max) {
                this._log.logAlways(30, "Refusing connection since we have exceeded our max of " + max + " and there are " + this._numWaiting + " waiting already");
                --this._numWaiting;
                return null;
            }
            try {
                Thread.sleep(remaining / 4L);
            }
            catch (InterruptedException ie) {}
        }
        con = new Connection(this._context, this, this._schedulerChooser, this._timer, this._outboundQueue, this._conPacketHandler, opts);
        con.setRemotePeer(peer);
        while (this._connectionByInboundId.containsKey(receiveId)) {
            receiveId = this._context.random().nextLong(0xFFFFFFFEL) + 1L;
        }
        this._connectionByInboundId.put(receiveId, con);
        con.setReceiveStreamId(receiveId);
        con.eventOccurred();
        if (this._log.shouldLog(10)) {
            this._log.debug("Connect() conDelay = " + opts.getConnectDelay());
        }
        if (opts.getConnectDelay() <= 0) {
            con.waitForConnect();
        }
        if (this._numWaiting > 0) {
            --this._numWaiting;
        }
        this._context.statManager().addRateData("stream.connectionCreated", 1L, 0L);
        return con;
    }

    private boolean locked_tooManyStreams() {
        int max = this._defaultOptions.getMaxConns();
        if (max <= 0) {
            return false;
        }
        if (this._connectionByInboundId.size() < max) {
            return false;
        }
        int active = 0;
        for (Connection con : this._connectionByInboundId.values()) {
            if (!con.getIsConnected()) continue;
            ++active;
        }
        if (this._connectionByInboundId.size() > 100 && this._log.shouldLog(20)) {
            this._log.info("More than 100 connections!  " + active + " total: " + this._connectionByInboundId.size());
        }
        return active >= max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String shouldRejectConnection(Packet syn) {
        Destination from = syn.getOptionalFrom();
        if (from == null) {
            return "null";
        }
        Hash h = from.calculateHash();
        String throttled = null;
        if (this._minuteThrottler != null && this._minuteThrottler.shouldThrottle(h)) {
            this._context.statManager().addRateData("stream.con.throttledMinute", 1L, 0L);
            throttled = this._defaultOptions.getMaxConnsPerMinute() <= 0 ? "throttled by total limit of " + this._defaultOptions.getMaxTotalConnsPerMinute() + " per minute" : (this._defaultOptions.getMaxTotalConnsPerMinute() <= 0 ? "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerMinute() + " per minute" : "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerMinute() + " or total limit of " + this._defaultOptions.getMaxTotalConnsPerMinute() + " per minute");
        }
        if (this._hourThrottler != null && this._hourThrottler.shouldThrottle(h)) {
            this._context.statManager().addRateData("stream.con.throttledHour", 1L, 0L);
            throttled = this._defaultOptions.getMaxConnsPerHour() <= 0 ? "throttled by total limit of " + this._defaultOptions.getMaxTotalConnsPerHour() + " per hour" : (this._defaultOptions.getMaxTotalConnsPerHour() <= 0 ? "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerHour() + " per hour" : "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerHour() + " or total limit of " + this._defaultOptions.getMaxTotalConnsPerHour() + " per hour");
        }
        if (this._dayThrottler != null && this._dayThrottler.shouldThrottle(h)) {
            this._context.statManager().addRateData("stream.con.throttledDay", 1L, 0L);
            throttled = this._defaultOptions.getMaxConnsPerDay() <= 0 ? "throttled by total limit of " + this._defaultOptions.getMaxTotalConnsPerDay() + " per day" : (this._defaultOptions.getMaxTotalConnsPerDay() <= 0 ? "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerDay() + " per day" : "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerDay() + " or total limit of " + this._defaultOptions.getMaxTotalConnsPerDay() + " per day");
        }
        if (throttled != null) {
            return throttled;
        }
        if (this._defaultOptions.isAccessListEnabled() && !this._defaultOptions.getAccessList().contains(h)) {
            return "not whitelisted";
        }
        if (this._defaultOptions.isBlacklistEnabled() && this._defaultOptions.getBlacklist().contains(h)) {
            return "blacklisted";
        }
        String hashes = this._context.getProperty(PROP_BLACKLIST, "");
        if (!_currentBlacklist.equals(hashes)) {
            Set<Hash> set = _globalBlacklist;
            synchronized (set) {
                if (hashes.length() > 0) {
                    HashSet<Hash> newSet = new HashSet<Hash>();
                    StringTokenizer tok = new StringTokenizer(hashes, ",; ");
                    while (tok.hasMoreTokens()) {
                        String hashstr = tok.nextToken();
                        Hash hh = ConvertToHash.getHash((String)hashstr);
                        if (hh != null) {
                            newSet.add(hh);
                            continue;
                        }
                        this._log.error("Bad blacklist entry: " + hashstr);
                    }
                    _globalBlacklist.addAll(newSet);
                    _globalBlacklist.retainAll(newSet);
                    _currentBlacklist = hashes;
                } else {
                    _globalBlacklist.clear();
                    _currentBlacklist = "";
                }
            }
        }
        if (hashes.length() > 0 && _globalBlacklist.contains(h)) {
            return "blacklisted globally";
        }
        return null;
    }

    public MessageHandler getMessageHandler() {
        return this._messageHandler;
    }

    public PacketHandler getPacketHandler() {
        return this._packetHandler;
    }

    public I2PSession getSession() {
        return this._session;
    }

    public void updateOptsFromShare(Connection con) {
        this._tcbShare.updateOptsFromShare(con);
    }

    public void updateShareOpts(Connection con) {
        this._tcbShare.updateShareOpts(con);
    }

    public ConnectionHandler getConnectionHandler() {
        return this._connectionHandler;
    }

    public PacketQueue getPacketQueue() {
        return this._outboundQueue;
    }

    public boolean answerPings() {
        return this._defaultOptions.getAnswerPings();
    }

    public void disconnectAllHard() {
        Iterator<Connection> iter = this._connectionByInboundId.values().iterator();
        while (iter.hasNext()) {
            Connection con = iter.next();
            con.disconnect(false, false);
            iter.remove();
        }
        this._tcbShare.stop();
        this._timer.stop();
    }

    public void removeConnection(Connection con) {
        boolean removed;
        Connection o = this._connectionByInboundId.remove(con.getReceiveStreamId());
        boolean bl = removed = o == con;
        if (this._log.shouldLog(10)) {
            this._log.debug("Connection removed? " + removed + " remaining: " + this._connectionByInboundId.size() + ": " + con);
        }
        if (!removed && this._log.shouldLog(10)) {
            this._log.debug("Failed to remove " + con + "\n" + this._connectionByInboundId.values());
        }
        if (removed) {
            this._context.statManager().addRateData("stream.con.lifetimeMessagesSent", 1L + con.getLastSendId(), con.getLifetime());
            MessageInputStream stream = con.getInputStream();
            long rcvd = 1L + stream.getHighestBlockId();
            long[] nacks = stream.getNacks();
            if (nacks != null) {
                rcvd -= (long)nacks.length;
            }
            this._context.statManager().addRateData("stream.con.lifetimeMessagesReceived", rcvd, con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeBytesSent", con.getLifetimeBytesSent(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeBytesReceived", con.getLifetimeBytesReceived(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeDupMessagesSent", con.getLifetimeDupMessagesSent(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeDupMessagesReceived", con.getLifetimeDupMessagesReceived(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeRTT", (long)con.getOptions().getRTT(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeCongestionSeenAt", (long)con.getLastCongestionSeenAt(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeSendWindowSize", (long)con.getOptions().getWindowSize(), con.getLifetime());
        }
    }

    public Set<Connection> listConnections() {
        return new HashSet<Connection>(this._connectionByInboundId.values());
    }

    public boolean ping(Destination peer, long timeoutMs) {
        return this.ping(peer, timeoutMs, true, null);
    }

    public boolean ping(Destination peer, long timeoutMs, boolean blocking) {
        return this.ping(peer, timeoutMs, blocking, null);
    }

    public boolean ping(Destination peer, long timeoutMs, boolean blocking, SessionKey keyToUse, Set tagsToSend, PingNotifier notifier) {
        return this.ping(peer, timeoutMs, blocking, notifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(Destination peer, long timeoutMs, boolean blocking, PingNotifier notifier) {
        Long id = this._context.random().nextLong(0xFFFFFFFEL) + 1L;
        PacketLocal packet = new PacketLocal(this._context, peer);
        packet.setSendStreamId(id);
        packet.setFlag(512);
        packet.setFlag(8);
        packet.setOptionalFrom(this._session.getMyDestination());
        PingRequest req = new PingRequest(peer, packet, notifier);
        this._pendingPings.put(id, req);
        this._outboundQueue.enqueue(packet);
        packet.releasePayload();
        if (blocking) {
            PingRequest pingRequest = req;
            synchronized (pingRequest) {
                if (!req.pongReceived()) {
                    try {
                        req.wait(timeoutMs);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            this._pendingPings.remove(id);
        } else {
            PingFailed pf = new PingFailed(id, notifier);
            pf.schedule(timeoutMs);
        }
        boolean ok = req.pongReceived();
        return ok;
    }

    void receivePong(long pingId) {
        PingRequest req = this._pendingPings.remove(pingId);
        if (req != null) {
            req.pong();
        }
    }

    private static class PingRequest {
        private boolean _ponged;
        private final PingNotifier _notifier;

        public PingRequest(Destination peer, PacketLocal packet, PingNotifier notifier) {
            this._notifier = notifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pong() {
            PingRequest pingRequest = this;
            synchronized (pingRequest) {
                this._ponged = true;
                this.notifyAll();
            }
            if (this._notifier != null) {
                this._notifier.pingComplete(true);
            }
        }

        public boolean pongReceived() {
            return this._ponged;
        }
    }

    private class PingFailed
    extends SimpleTimer2.TimedEvent {
        private final Long _id;
        private final PingNotifier _notifier;

        public PingFailed(Long id, PingNotifier notifier) {
            super(ConnectionManager.this._context.simpleTimer2());
            this._id = id;
            this._notifier = notifier;
        }

        public void timeReached() {
            PingRequest pr = (PingRequest)ConnectionManager.this._pendingPings.remove(this._id);
            if (pr != null) {
                if (this._notifier != null) {
                    this._notifier.pingComplete(false);
                }
                if (ConnectionManager.this._log.shouldLog(20)) {
                    ConnectionManager.this._log.info("Ping failed");
                }
            }
        }
    }

    public static interface PingNotifier {
        public void pingComplete(boolean var1);
    }
}

