/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.Hash;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

class ConnThrottler {
    private final ObjectCounter<Hash> counter;
    private volatile int _max;
    private volatile int _totalMax;
    private final AtomicInteger _currentTotal;

    ConnThrottler(int max, int totalMax, long period) {
        this._max = max;
        this._totalMax = totalMax;
        this.counter = new ObjectCounter();
        this._currentTotal = new AtomicInteger();
        SimpleScheduler.getInstance().addPeriodicEvent((SimpleTimer.TimedEvent)new Cleaner(), period);
    }

    public void updateLimits(int max, int totalMax) {
        this._max = max;
        this._totalMax = totalMax;
    }

    boolean shouldThrottle(Hash h) {
        if (this._totalMax > 0 && this._currentTotal.incrementAndGet() > this._totalMax) {
            return true;
        }
        if (this._max > 0) {
            return this.counter.increment((Object)h) > this._max;
        }
        return false;
    }

    boolean isThrottled(Hash h) {
        if (this._max > 0) {
            return this.counter.count((Object)h) > this._max;
        }
        return false;
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        public void timeReached() {
            if (ConnThrottler.this._totalMax > 0) {
                ConnThrottler.this._currentTotal.set(0);
            }
            if (ConnThrottler.this._max > 0) {
                ConnThrottler.this.counter.clear();
            }
        }
    }
}

