/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.util.Set;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.WriterOutputStream;

public class StatHelper
extends HelperBase {
    private String _peer;

    public void setPeer(String peer) {
        this._peer = peer;
    }

    public String getProfile() {
        if (this._peer == null || this._peer.length() <= 0) {
            return "No peer specified";
        }
        if (this._peer.length() >= 44) {
            return this.outputProfile();
        }
        Set<Hash> peers = this._context.profileOrganizer().selectAllPeers();
        for (Hash peer : peers) {
            if (!peer.toBase64().startsWith(this._peer)) continue;
            return this.dumpProfile(peer);
        }
        return "Unknown peer " + this._peer;
    }

    private String outputProfile() {
        Hash peer = new Hash();
        try {
            peer.fromBase64(this._peer);
            return this.dumpProfile(peer);
        }
        catch (DataFormatException dfe) {
            return "Bad peer hash " + this._peer;
        }
    }

    private String dumpProfile(Hash peer) {
        try {
            WriterOutputStream wos = new WriterOutputStream(this._out);
            boolean success = this._context.profileOrganizer().exportProfile(peer, wos);
            if (success) {
                wos.flush();
                this._out.flush();
                return "";
            }
            return "Unknown peer " + this._peer;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "IO Error " + e;
        }
    }
}

